/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractCredentialsDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractSubRequestLogDao;
import ru.bitel.bgbilling.modules.megogo.server.bean.MegogoContractTryAndBuyDao;
import ru.bitel.bgbilling.modules.megogo.server.event.MegogoSubscriptionRequestedEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class MegogoApi
extends BGLogger {
    int userId;
    int moduleId;
    private Connection con;
    private ModuleSetup moduleSetup = null;
    private MegogoContractSubRequestLogDao logDao;
    private int contractSubscriptionId = -1;

    public MegogoApi(int moduleId, int userId, Connection con, int contractSubscriptionId) {
        this(moduleId, userId, con);
        if (contractSubscriptionId > 0) {
            this.contractSubscriptionId = contractSubscriptionId;
        }
    }

    public MegogoApi(int moduleId, int userId, Connection con) {
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.logDao = new MegogoContractSubRequestLogDao(con, moduleId);
        this.con = con;
        this.userId = userId;
        this.moduleId = moduleId;
    }

    public MegogoContractSubRequestLog subscribe(int contractId, MegogoSubscription subscription) throws Exception {
        return this.requestService(contractId, subscription, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_SUBSCRIBE);
    }

    @Deprecated
    public MegogoContractSubRequestLog unsubscribe(int contractId, MegogoSubscription subscription) throws Exception {
        return this.requestService(contractId, subscription, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_UNSUBSCRIBE);
    }

    public MegogoContractSubRequestLog unsubscribe(MegogoContractSubscription contractSubscription, MegogoSubscription subscription) throws Exception {
        MegogoContractSubRequestLog log = this.requestService(contractSubscription.getContractId(), subscription, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_UNSUBSCRIBE);
        MegogoContractTryAndBuyDao contractTryAndBuyDao = new MegogoContractTryAndBuyDao(this.con, this.moduleId);
        MegogoContractTryAndBuy contractTryAndBuy = contractTryAndBuyDao.getContractTBByIdSub(contractSubscription.getId());
        if (contractTryAndBuy != null && TimeUtils.dateInPeriod((Date)contractSubscription.getPeriod().getDateTo(), (Period)contractTryAndBuy.getPeriod())) {
            contractTryAndBuy.getPeriod().setDateTo(contractSubscription.getPeriod().getDateTo());
            contractTryAndBuyDao.update(contractTryAndBuy);
        }
        return log;
    }

    public MegogoContractSubRequestLog suspend(int contractId, MegogoSubscription subscription) throws Exception {
        return this.requestService(contractId, subscription, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_SUSPEND);
    }

    public MegogoContractSubRequestLog resume(int contractId, MegogoSubscription subscription) throws Exception {
        return this.requestService(contractId, subscription, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_RESUME);
    }

    public String getRedirectUrl(int contractId) {
        Object result = "http://megogo.net/auth/by_partners/dialog?";
        try {
            String userId = this.getUserId(contractId);
            String partnerId = this.getPartnerId();
            String sign = this.getSign(userId, partnerId);
            result = (String)result + "isdn=" + userId + "&partner_key=" + partnerId + "&token=" + sign;
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        return result;
    }

    public MegogoContractSubRequestLog createUser(int contractId, String login, String pwd) throws BGException {
        MegogoRequest request = (megogoLog, cid) -> {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                MegogoContractCredentialsDao credentialsDao = new MegogoContractCredentialsDao(this.con, this.moduleId);
                Contract contract = (Contract)contractDao.get(contractId);
                if (contract == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c - " + contractId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
                }
                String loginSet = Utils.isBlankString((String)login) ? this.createLogin(contract, credentialsDao) : login;
                String partnerIdEncode = URLEncoder.encode(this.getPartnerId(), "UTF-8");
                String userIdEncode = URLEncoder.encode(this.getUserId(contractId), "UTF-8");
                String urlText = "http://billing.megogo.net/partners/" + partnerIdEncode + "/user/create?identifier=" + userIdEncode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + urlText);
                }
                URL url = new URL(urlText);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                if (conn.getResponseCode() == 200) {
                    byte[] d = Utils.readByBlock((InputStream)conn.getInputStream());
                    JSONObject jsonAnswer = new JSONObject(new String(d, "UTF-8"));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + jsonAnswer.toString());
                    }
                    int uid = jsonAnswer.getInt("uid");
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0440\u043e\u0441 CREATE USER cid - " + contractId);
                    }
                    MegogoContractCredentials credentials = new MegogoContractCredentials();
                    credentials.setContractId(contractId);
                    credentials.setLogin(loginSet);
                    credentials.setUid(uid);
                    megogoLog.setAnswerResult(MegogoContractSubRequestLog.MEGOGO_REQUEST_RESULT_SUCCESSFUL.intValue());
                    MegogoContractCredentials reqCred = null;
                    try {
                        reqCred = this.requestCredentials(contractId, loginSet, pwd, uid);
                    }
                    catch (Exception e) {
                        this.getLogger().error(e.getMessage());
                    }
                    if (reqCred == null) {
                        credentialsDao.update(credentials);
                    }
                    MegogoContractSubRequestLog megogoContractSubRequestLog = megogoLog;
                    return megogoContractSubRequestLog;
                }
                megogoLog.setAnswerResult(conn.getResponseCode());
                megogoLog.setErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430. HTTP Code - " + conn.getResponseCode());
                this.getLogger().error(megogoLog.getErrorMessage());
                throw new BGMessageException(megogoLog.getErrorMessage());
            }
        };
        MegogoContractSubRequestLog megogoLog2 = new MegogoContractSubRequestLog(contractId, 0, MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_CREATE_USER.intValue(), new Date(), this.userId);
        return this.request(request, megogoLog2, contractId);
    }

    private MegogoContractSubRequestLog requestService(int contractId, MegogoSubscription subscription, int requestType) throws Exception {
        MegogoRequest request = (megogoLog, cid) -> {
            String path = this.getRequestKey(requestType);
            String partnerIdEncode = URLEncoder.encode(this.getPartnerId(), "UTF-8");
            String userIdEncode = URLEncoder.encode(this.getUserId(contractId), "UTF-8");
            String subKeyEncode = URLEncoder.encode(subscription.getKey(), "UTF-8");
            String urlText = "http://billing.megogo.net/partners/" + partnerIdEncode + "/subscription/" + path + "?userId=" + userIdEncode + "&serviceId=" + subKeyEncode;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + urlText);
            }
            URL url = new URL(urlText);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (conn.getResponseCode() == 200) {
                byte[] d = Utils.readByBlock((InputStream)conn.getInputStream());
                JSONObject jsonAnswer = new JSONObject(new String(d, "UTF-8"));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + jsonAnswer.toString());
                }
                if (jsonAnswer.getBoolean("successful")) {
                    MegogoContractCredentialsDao credentialsDao;
                    MegogoContractCredentials credentials;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0440\u043e\u0441 " + path + " cid - " + contractId);
                    }
                    megogoLog.setAnswerResult(MegogoContractSubRequestLog.MEGOGO_REQUEST_RESULT_SUCCESSFUL.intValue());
                    if (requestType == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_SUBSCRIBE && (credentials = (credentialsDao = new MegogoContractCredentialsDao(this.con, this.moduleId)).getByContractId(contractId)) == null) {
                        this.requestCredentials(contractId, null, null, -1);
                    }
                    EventProcessor.getInstance().publishAfterCommit((Event)new MegogoSubscriptionRequestedEvent(this.moduleId, contractId, cid, subscription, this.contractSubscriptionId, requestType));
                    return megogoLog;
                }
                megogoLog.setAnswerResult(MegogoContractSubRequestLog.MEGOGO_REQUEST_RESULT_ERROR.intValue());
                megogoLog.setErrorMessage(jsonAnswer.getString("message"));
                this.getLogger().error("Error. " + jsonAnswer.getString("message"));
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430. " + jsonAnswer.getString("message"));
            }
            megogoLog.setAnswerResult(conn.getResponseCode());
            megogoLog.setErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430. HTTP Code - " + conn.getResponseCode());
            this.getLogger().error(megogoLog.getErrorMessage());
            throw new BGMessageException(megogoLog.getErrorMessage());
        };
        MegogoContractSubRequestLog megogoLog2 = new MegogoContractSubRequestLog(contractId, subscription.getSid(), requestType, new Date(), this.userId);
        if (this.contractSubscriptionId > 0) {
            megogoLog2.setContractSubId(this.contractSubscriptionId);
        }
        return this.request(request, megogoLog2, contractId);
    }

    /*
     * Exception decompiling
     */
    public MegogoContractCredentials requestCredentials(int contractId, String login, String pwd, int uid) throws BGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MegogoContractCredentials getMegogoUidAndLogin(int contractId) {
        try {
            String userId = this.getUserId(contractId);
            String urlText = "http://billing.megogo.net/partners/" + URLEncoder.encode(this.getPartnerId(), "UTF-8") + "/user/innerId?identifier=" + URLEncoder.encode(userId, "UTF-8");
            URL url = new URL(urlText);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (conn.getResponseCode() == 200) {
                byte[] d = Utils.readByBlock((InputStream)conn.getInputStream());
                JSONObject jsonAnswer = new JSONObject(new String(d, "UTF-8"));
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0435\u043d.");
                int uid = jsonAnswer.getInt("uid");
                String login = jsonAnswer.getString("email");
                this.getLogger().debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0440\u043e\u0441 Identifier cid - " + contractId);
                return new MegogoContractCredentials(contractId, uid, login);
            }
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430. HTTP Code - " + conn.getResponseCode());
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getRequestKey(int type) {
        if (type == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_SUBSCRIBE) {
            return "subscribe";
        }
        if (type == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_UNSUBSCRIBE) {
            return "unsubscribe";
        }
        if (type == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_SUSPEND) {
            return "suspend";
        }
        if (type == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_RESUME) {
            return "resume";
        }
        return "none";
    }

    private MegogoContractSubRequestLog request(MegogoRequest request, MegogoContractSubRequestLog megogoLog, int contractId) throws BGException {
        boolean wasException = false;
        boolean commitFlag = false;
        try {
            commitFlag = this.con.getAutoCommit();
            MegogoContractSubRequestLog megogoContractSubRequestLog = request.request(megogoLog, contractId);
            return megogoContractSubRequestLog;
        }
        catch (Exception e) {
            wasException = true;
            try {
                this.con.rollback();
            }
            catch (SQLException e1) {
                this.getLogger().error(e1.getMessage(), (Throwable)e1);
            }
            if (e instanceof BGMessageException) {
                throw (BGMessageException)e;
            }
            megogoLog.setAnswerResult(MegogoContractSubRequestLog.MEGOGO_REQUEST_RESULT_RUNTIME_ERROR.intValue());
            megogoLog.setErrorMessage((String)(Utils.isBlankString((String)megogoLog.getErrorMessage()) ? e.getMessage() : megogoLog.getErrorMessage() + "  " + e.getMessage()));
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.logDao.update(megogoLog);
                if (wasException) {
                    this.con.commit();
                }
                this.con.setAutoCommit(commitFlag);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    private String createLogin(Contract contract, MegogoContractCredentialsDao credentialsDao) throws Exception {
        String pref = this.moduleSetup.get("credentials.domain", null);
        if (Utils.isBlankString((String)pref)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 credentials.domain");
        }
        String login = contract.getTitle() + "@" + pref;
        int count = 0;
        while (credentialsDao.getByLogin(login) != null && count < 100) {
            login = contract.getTitle() + "_" + ++count + "@" + pref;
        }
        return login;
    }

    private String getSign(String userId, String partnerId) throws BGException {
        try {
            String secretString = userId + partnerId + this.getSalt();
            MessageDigest md = MessageDigest.getInstance("md5");
            byte[] digest = md.digest(secretString.toString().getBytes());
            return Utils.bytesToHexString((byte[])digest).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    private String getPartnerId() throws BGMessageException {
        String partnerId = this.moduleSetup.get("megogo.partner.id", this.moduleSetup.get("partnerId", null));
        if (partnerId == null) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d megogo.partner.id \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        return partnerId;
    }

    private String getUserId(int contractId) throws BGMessageException {
        String prefixUser = this.moduleSetup.get("megogo.prefix.user", this.moduleSetup.get("prefixUser", null));
        if (prefixUser == null) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d megogo.prefix.user \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        return prefixUser + contractId;
    }

    private String getSalt() throws BGMessageException {
        String salt = this.moduleSetup.get("megogo.salt", this.moduleSetup.get("salt", null));
        if (salt == null) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d megogo.salt \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        return salt;
    }

    private static interface MegogoRequest {
        public MegogoContractSubRequestLog request(MegogoContractSubRequestLog var1, int var2) throws Exception;
    }
}

