/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.servlet;

import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.mps.server.MPSJaxWsHandler;
import ru.bitel.bgbilling.modules.mps.server.RequestProcessException;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="mpsexecutor", urlPatterns={"/mpsexecuter/*"})
public class MPSExecutor
extends CommonExecutor {
    private static final Pattern slashPattern = Pattern.compile("/");
    private MPSJaxWsHandler soapHandler;

    public void init() {
        this.setup = Setup.getSetup();
        try {
            this.soapHandler = new MPSJaxWsHandler(this.getServletContext());
        }
        catch (BGException ex) {
            this.logError((Exception)((Object)ex));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                int moduleId = 0;
                String mpsId = null;
                Object[] params = null;
                String pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    if (pathInfo.startsWith("/mps-ws")) {
                        this.soapHandler.handle(request, response);
                        return;
                    }
                    params = slashPattern.split(pathInfo);
                    if (params.length > 2) {
                        mpsId = params[2];
                    }
                    if (params.length > 1) {
                        moduleId = Utils.parseInt((String)params[1], (int)0);
                    }
                    request.setAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PATH_INFO", (Object)params);
                } else {
                    moduleId = 0;
                    mpsId = null;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("request.getPathInfo() = " + request.getPathInfo() + "; mpsId = " + mpsId + "; mid = " + moduleId + "; params = " + Arrays.toString(params));
                }
                this.getLoginAndPassword(request);
                if (moduleId <= 0) {
                    moduleId = Utils.parseInt((String)request.getParameter("mid"), (int)0);
                }
                ServerUtils.addNoCache((HttpServletResponse)response);
                if (moduleId <= 0) {
                    throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d/\u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d ID \u043c\u043e\u0434\u0443\u043b\u044f");
                }
                AtomicReference<Conf.MPSSystem> systemRef = new AtomicReference<Conf.MPSSystem>();
                byte[] data = MPSTransactionManager.processRequest(request, response, this.setup, con, moduleId, mpsId, systemRef);
                if (this.getLogger().isDebugEnabled()) {
                    try {
                        StringBuilder sb = new StringBuilder(100);
                        FilterRegistration filterRegistration = this.getServletContext().getFilterRegistration("mpsexecuterSetCharacterEncoding");
                        sb.append("Filter (mpsexecuterSetCharacterEncoding) = " + filterRegistration + "\n");
                        if (filterRegistration != null) {
                            sb.append("\tUrlPatternMappings:\n");
                            for (String urlPatternMapping : filterRegistration.getUrlPatternMappings()) {
                                sb.append("\t" + urlPatternMapping + "\n");
                            }
                        }
                        sb.append("FilterCharacterEncoding=" + request.getCharacterEncoding() + "\n");
                        Conf.MPSSystem system = systemRef.get();
                        if (system != null) {
                            sb.append("System: ").append(system.title).append('\n');
                        }
                        sb.append("Request:\n").append(request.getPathInfo()).append('\n');
                        Map map = request.getParameterMap();
                        for (Map.Entry e : map.entrySet()) {
                            Object key = e.getKey();
                            String[] values = (String[])e.getValue();
                            if (values != null && values.length > 0) {
                                for (String value : values) {
                                    sb.append(key).append('=').append(value).append('&');
                                }
                                continue;
                            }
                            sb.append(key).append('=').append('&');
                        }
                        sb.append("\nResponse:\n");
                        if (system.protocol == Conf.Protocol.osmp || system.protocol == Conf.Protocol.pegas || system.protocol == Conf.Protocol.empay || system.protocol == Conf.Protocol.erc || system.protocol == Conf.Protocol.mgpe || system.protocol == Conf.Protocol.unikassa || system.protocol == Conf.Protocol.bisys || system.protocol == Conf.Protocol.comepay) {
                            sb.append(data != null ? new String(data, "UTF-8") : "null");
                        } else if (system.protocol == Conf.Protocol.cp || system.protocol == Conf.Protocol.eport || system.protocol == Conf.Protocol.xplat || system.protocol == Conf.Protocol.sbrf || system.protocol == Conf.Protocol.rapida || system.protocol == Conf.Protocol.sfoura || system.protocol == Conf.Protocol.elecsnet || system.protocol == Conf.Protocol.quickpay) {
                            sb.append(data != null ? new String(data, "cp1251") : "null");
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
                response.setContentLength(data.length);
                ServletOutputStream sout = response.getOutputStream();
                sout.write(data);
                sout.flush();
                sout.close();
            }
            catch (RequestProcessException ex) {
                if ("auth".equals(ex.getSubject())) {
                    if (ex.getTxt() != null) {
                        this.getLogger().warn("MPSExecutor. Authentication error of payment system [remoteAddr=" + ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup) + ", authType=" + request.getAuthType() + "]. " + ex.getTxt());
                    }
                    response.setHeader("WWW-Authenticate", "Basic realm=\"BGBilling MPS\"");
                    response.setStatus(401);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("MPS. Authentication error of payment system [remoteAddr=" + ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup) + ", authType=" + request.getAuthType() + "]. " + ex.getTxt());
                    }
                    byte[] data = ex.getTxt().getBytes();
                    response.setContentType("text/plain");
                    response.setContentLength(data.length);
                    ServletOutputStream sout = response.getOutputStream();
                    sout.write(data);
                    sout.flush();
                    sout.close();
                }
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void getLoginAndPassword(HttpServletRequest request) {
        String userName = null;
        String userPswd = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic ")) {
            int colon;
            authorization = authorization.substring(6).trim();
            String unencoded = Base64.decodeUTF8((String)authorization);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("MPS (getLoginAndPasswordFromHeaderAuthorization): authorization=" + authorization + "; unencoded=" + unencoded + "; encoding=UTF-8");
            }
            if ((colon = unencoded.indexOf(58)) > 0) {
                try {
                    userName = unencoded.substring(0, colon);
                    userPswd = unencoded.substring(colon + 1);
                    request.setAttribute("userName", (Object)userName);
                    request.setAttribute("userPswd", (Object)userPswd);
                }
                catch (Exception ex) {
                    userName = null;
                    userPswd = null;
                    ex.printStackTrace();
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("MPS (getLoginAndPasswordFromHeaderAuthorization): userName=" + userName + "; userPswd=" + userPswd);
        }
    }
}

