/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.account;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DialUpModuleAccount
extends ModuleAccount {
    @Override
    public BigDecimal getPeriodAccount(Connection con, int contractId, Calendar from, Calendar to) {
        BigDecimal result = BigDecimal.ZERO;
        String sessionAccount = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)from.getTime(), (int)this.getModleId());
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)from.getTime(), (int)this.getModleId());
        String loginTable = "user_login_" + this.getModleId();
        if (ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT ROUND(SUM(summa), 2) FROM ");
            query.append(sessionAccount);
            query.append(" AS session_account INNER JOIN ");
            query.append(sessionTable);
            query.append(" AS session ON session_account.session_id=session.id INNER JOIN ");
            query.append(loginTable);
            query.append(" AS login ON session.lid=login.id ");
            query.append(" WHERE login.cid=? ");
            if (from.get(5) != 1) {
                query.append(" AND session.session_start>='");
                query.append(TimeUtils.formatSQLDate((Date)from.getTime()));
                query.append("'");
            }
            if (to.get(5) != to.getActualMaximum(5)) {
                Calendar afterTo = (Calendar)to.clone();
                afterTo.add(5, 1);
                query.append(" AND session.session_start<'");
                query.append(TimeUtils.formatSQLDate((Date)afterTo.getTime()));
                query.append("'");
            }
            if (Utils.notBlankString((String)this.getSids())) {
                query.append(" AND session_account.sid IN ( ");
                query.append(this.getSids());
                query.append(" ) ");
            }
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                ps.setInt(1, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return result;
    }
}

