/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.modules.npay.common.bean.FilterMode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class MonthServiceFilterTariffTreeNode
extends DefaultTariffTreeNode {
    protected FilterMode filterMode = FilterMode.ALL;
    protected int serviceId = 0;
    protected int beforeDayValue = 1;
    protected int afterDayValue = 1;
    protected int beforeValue = 1;
    protected int afterValue = 1;
    protected BGUComboBox<IdTitle> serviceCombo;
    protected ButtonGroup buttonGroup = null;
    protected CountField beforeDayField = null;
    protected CountField afterDayField = null;
    protected CountField beforeField = null;
    protected CountField afterField = null;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
    }

    public Component getView() throws Exception {
        this.loadData();
        String serviceName = this.getDirManager().getDirectory("services").getValue(this.serviceId);
        String string = serviceName == null ? "<\u0423\u0421\u041b\u0423\u0413\u0410 \u041d\u0415 \u0417\u0410\u0414\u0410\u041d\u0410>" : serviceName;
        String text = "\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435: " + string + " [ \u0440\u0435\u0436\u0438\u043c: " + (String)(switch (this.filterMode) {
            case FilterMode.ALL -> "\u0432\u0435\u0441\u044c \u043c\u0435\u0441\u044f\u0446";
            case FilterMode.PERIOD -> "\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0443\u0441\u043b\u0443\u0433 (\u0432 \u043c\u0435\u0441\u044f\u0446\u0435)";
            case FilterMode.DAY_BEFORE -> "\u0434\u043d\u0435\u0439 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043c\u0435\u0441\u044f\u0446\u0435: \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e => " + this.beforeDayValue;
            case FilterMode.DAY_AFTER -> "\u0434\u043d\u0435\u0439 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043c\u0435\u0441\u044f\u0446\u0435: \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e => " + this.afterDayValue;
            case FilterMode.BEFORE -> "\u043c\u0435\u0441\u044f\u0446 \u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438: \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e => " + this.beforeValue;
            case FilterMode.AFTER -> "\u043c\u0435\u0441\u044f\u0446 \u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438: \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e => " + this.afterValue;
            case FilterMode.LAST -> "\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043c\u0435\u0441\u044f\u0446 \u0443\u0441\u043b\u0443\u0433\u0438";
            case FilterMode.FIRST_DAY_OF_MONTH -> "\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u043f\u0435\u0440\u0432\u044b\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0439 \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430";
            default -> throw new IllegalArgumentException("Unexpected value: " + this.filterMode);
        }) + " ]";
        JLabel view = new JLabel(text);
        view.setIcon(ClientUtils.getIcon((String)"fugue/funnel"));
        return view;
    }

    protected JPanel getEditorPanel() throws Exception {
        JPanel edit = new JPanel(new GridBagLayout());
        edit.add((Component)this.getServicePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        edit.add((Component)this.getSelectModePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 10, 5), 0, 0));
        return edit;
    }

    protected JPanel getServicePanel() throws Exception {
        if (this.serviceCombo == null) {
            this.serviceCombo = new BGUComboBox();
            this.buttonGroup = new ButtonGroup();
            this.beforeDayField = new CountField();
            this.afterDayField = new CountField();
            this.beforeField = new CountField();
            this.afterField = new CountField();
        }
        ArrayList<IdTitle> serviceItems = new ArrayList<IdTitle>();
        serviceItems.add(new IdTitle(0, "<\u0423\u0421\u041b\u0423\u0413\u0410 \u041d\u0415 \u0417\u0410\u0414\u0410\u041d\u0410>"));
        serviceItems.addAll(this.getDirManager().getDirectory("services").getItems());
        this.serviceCombo.setData(serviceItems);
        this.setDirectoryItemSelection((JComboBox)this.serviceCombo, this.serviceId);
        JPanel edit = new JPanel(new GridBagLayout());
        edit.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        edit.add((Component)this.serviceCombo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return edit;
    }

    protected JPanel getSelectModePanel() {
        ModeButton fullMonthButton = new ModeButton("\u0432\u0435\u0441\u044c \u043c\u0435\u0441\u044f\u0446", FilterMode.ALL);
        ModeButton periodButton = new ModeButton("\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u0432 \u0443\u0441\u043b\u0443\u0433 (\u0432 \u043c\u0435\u0441\u044f\u0446\u0435)", FilterMode.PERIOD);
        ModeButton beforeDayButton = new ModeButton("\u0434\u043d\u0435\u0439 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043c\u0435\u0441\u044f\u0446\u0435: \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e -> ", FilterMode.DAY_BEFORE);
        ModeButton afterDayButton = new ModeButton("\u0434\u043d\u0435\u0439 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043c\u0435\u0441\u044f\u0446\u0435: \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e -> ", FilterMode.DAY_AFTER);
        ModeButton beforeMonthServiceStartButton = new ModeButton("\u043c\u0435\u0441\u044f\u0446 \u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438: \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e -> ", FilterMode.BEFORE);
        ModeButton afterMonthServiceStartButton = new ModeButton("\u043c\u0435\u0441\u044f\u0446 \u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438: \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e -> ", FilterMode.AFTER);
        ModeButton monthServiceLastButton = new ModeButton("\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043c\u0435\u0441\u044f\u0446 \u0443\u0441\u043b\u0443\u0433\u0438", FilterMode.LAST);
        ModeButton checkServiceFirstMonthDay = new ModeButton("\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u043f\u0435\u0440\u0432\u044b\u0439 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0439 \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430", FilterMode.FIRST_DAY_OF_MONTH);
        this.beforeDayField.setText(String.valueOf(this.beforeDayValue));
        this.afterDayField.setText(String.valueOf(this.afterDayValue));
        this.beforeField.setText(String.valueOf(this.beforeValue));
        this.afterField.setText(String.valueOf(this.afterValue));
        this.buttonGroup.getElements().asIterator().forEachRemaining(a -> a.setSelected(a.getActionCommand().equals(this.filterMode.name())));
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)fullMonthButton, constraints);
        panel.add((Component)periodButton, constraints);
        panel.add((Component)this.getStartPanel(beforeDayButton, this.beforeDayField), constraints);
        panel.add((Component)this.getStartPanel(afterDayButton, this.afterDayField), constraints);
        panel.add((Component)this.getStartPanel(beforeMonthServiceStartButton, this.beforeField), constraints);
        panel.add((Component)this.getStartPanel(afterMonthServiceStartButton, this.afterField), constraints);
        panel.add((Component)monthServiceLastButton, constraints);
        panel.add((Component)checkServiceFirstMonthDay, constraints);
        return panel;
    }

    private JPanel getStartPanel(ModeButton modeButton, BGTextField textField) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)modeButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)textField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void loadData() {
        Map data = this.getDataInHash();
        this.serviceId = Utils.parseInt((String)((String)data.get("serviceId")), (int)0);
        this.filterMode = FilterMode.valueOf((String)data.getOrDefault("filterMode", FilterMode.ALL.name()));
        this.beforeDayValue = Utils.parseInt((String)((String)data.get("beforeDayValue")), (int)1);
        this.afterDayValue = Utils.parseInt((String)data.getOrDefault("afterDayValue", (String)data.get("dayValue")), (int)1);
        this.beforeValue = Utils.parseInt((String)((String)data.get("beforeValue")), (int)1);
        this.afterValue = Utils.parseInt((String)((String)data.get("afterValue")), (int)1);
    }

    protected void serializeData() {
        this.serviceId = this.getIdFromDirectoryCombo((JComboBox)this.serviceCombo);
        this.filterMode = FilterMode.valueOf((String)this.buttonGroup.getSelection().getActionCommand());
        this.afterDayValue = Utils.parseInt((String)this.afterDayField.getText(), (int)1);
        this.beforeDayValue = Utils.parseInt((String)this.beforeDayField.getText(), (int)1);
        this.beforeValue = Utils.parseInt((String)this.beforeField.getText(), (int)1);
        this.afterValue = Utils.parseInt((String)this.afterField.getText(), (int)1);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("serviceId", String.valueOf(this.serviceId));
        data.put("filterMode", this.filterMode.name());
        data.put("beforeDayValue", String.valueOf(this.beforeDayValue));
        data.put("afterDayValue", String.valueOf(this.afterDayValue));
        data.put("beforeValue", String.valueOf(this.beforeValue));
        data.put("afterValue", String.valueOf(this.afterValue));
        this.setDataInHash(data);
    }

    class CountField
    extends BGTextField {
        public CountField() {
            super(3);
            this.setHorizontalAlignment(0);
            this.setText("1");
            this.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    boolean result = ((JTextField)input).getText().matches("^[0-9]+$");
                    if (!result) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
                    }
                    return result;
                }
            });
        }
    }

    class ModeButton
    extends JRadioButton {
        public ModeButton(String text, FilterMode filterMode) {
            super(text);
            this.setActionCommand(filterMode.name());
            MonthServiceFilterTariffTreeNode.this.buttonGroup.add(this);
        }
    }
}

