/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.BGToggleButton;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;

public class ServiceReportPanel
extends ServicePanel {
    private String destId;
    private String serviceId;
    private String itemId;
    protected int show_mode = 0;
    protected static final int SESSION_SHOW_MODE = 0;
    protected static final int BALANCE_SHOW_MODE = 1;
    protected static final int DIR_SHOW_MODE = 2;
    protected static final int SERVICE_SHOW_MODE = 3;
    protected static final int SERVICE_SESSIONS_SHOW_MODE = 4;
    protected static final int SESSION_INCOMING_SHOW_MODE = 5;
    boolean init = true;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGToggleButton jToggleCost = new BGToggleButton("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430");
    private BGToggleButton jToggleSession = new BGToggleButton("\u0421\u0435\u0441\u0441\u0438\u0438");
    private BGToggleButton jToggleDest = new BGToggleButton("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
    private BGToggleButton jToggleService = new BGToggleButton("\u0423\u0441\u043b\u0443\u0433\u0438");
    private BGToggleButton jToggleServiceSessions = new BGToggleButton("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
    private BGToggleButton jToggleIncoming = new BGToggleButton("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private CardLayout cardLayout = new CardLayout();
    private JTextField time_sum = new JTextField();
    private JTextField time_sum_round = new JTextField();
    private JTextField money_sum = new JTextField();
    private JTextField sessions_count = new JTextField();
    private BGTable tableSession = new BGTable();
    private BGTable table0Rule = new BGTable();
    private BGTable tableCost = new BGTable();
    private BGTable tableDest = new BGTable();
    private BGTable tableService = new BGTable();
    private BGTable tableServiceSessions = new BGTable();
    private BGTable tableSessionIncoming = new BGTable();
    final BGButtonPanel controlPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M});
    private JPanel tablePanel = new JPanel();
    private JTabbedPane tabPanel = new JTabbedPane();
    private BGControlPanelListSelect points = new BGControlPanelListSelect();
    private BGControlPanelListSelect rules = new BGControlPanelListSelect();
    private JMenuItem emailCsvZipitem = new JMenuItem("CSV/ZIP");
    private JMenuItem emailHtmlZipitem = new JMenuItem("HTML/ZIP");
    private JCheckBox noFreeCombo = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u043f\u043b\u0430\u0442\u043d\u044b\u0435");
    private final JPopupMenu popup = new JPopupMenu();
    private int type = 1;
    private JPanel dataLogPanel = new JPanel(new GridBagLayout());
    private BGTable dataLogTable = new BGTable();

    public ServiceReportPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.dataLogTable.setHeader(this.rb_name, this.moduleDoc, "data_log");
        this.tableSession.setHeader(this.rb_name, this.moduleDoc, "report_session");
        this.table0Rule.setHeader(this.rb_name, this.moduleDoc, "report_session_rule");
        this.tableCost.setHeader(this.rb_name, this.moduleDoc, "report_cost");
        this.tableDest.setHeader(this.rb_name, this.moduleDoc, "report_direct");
        this.tableService.setHeader(this.rb_name, this.moduleDoc, "report_service");
        this.tableServiceSessions.setHeader(this.rb_name, this.moduleDoc, "report_service_sessions");
        this.tableSessionIncoming.setHeader(this.rb_name, this.moduleDoc, "report_session_incoming");
        this.tableSession.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ServiceReportPanel.this.tableSession.getSelectedRow()) >= 0) {
                    ServiceReportPanel.this.showDataLog(ServiceReportPanel.this.tableSession.getColumnValueString(row, "cdr_id"), ServiceReportPanel.this.tableSession.getColumnValueString(row, "hour"));
                }
            }
        });
        this.tableServiceSessions.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String cdrId;
                int row;
                if (e.getClickCount() == 2 && (row = ServiceReportPanel.this.tableServiceSessions.getSelectedRow()) >= 0 && (cdrId = ServiceReportPanel.this.tableServiceSessions.getColumnValueString(row, "cdr_id")).length() > 0) {
                    ServiceReportPanel.this.showDataLog(cdrId, ServiceReportPanel.this.tableServiceSessions.getColumnValueString(row, "hour"));
                }
            }
        });
        this.table0Rule.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ServiceReportPanel.this.table0Rule.getSelectedRow()) >= 0) {
                    ServiceReportPanel.this.showDataLog(ServiceReportPanel.this.table0Rule.getColumnValueString(row, "cdr_id"), ServiceReportPanel.this.table0Rule.getColumnValueString(row, "hour"));
                }
            }
        });
        this.tableDest.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceReportPanel.this.showSessionsForDest();
                }
            }
        });
        this.tableService.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceReportPanel.this.showSessionsForService();
                }
            }
        });
        this.tabPanel.addChangeListener(e -> this.tabChanged());
        this.tableSessionIncoming.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ServiceReportPanel.this.tableSessionIncoming.getSelectedRow()) >= 0) {
                    ServiceReportPanel.this.showDataLog(ServiceReportPanel.this.tableSessionIncoming.getColumnValueString(row, "cdr_id"), ServiceReportPanel.this.tableSessionIncoming.getColumnValueString(row, "hour"));
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.createLeftPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createRigthPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pagePanel.addPropertyChangeListener(e -> this.pageCounter_propertyChange(e));
        this.controlPanel.addActionListener(e -> this.bGControlPanel_12_actionPerformed(e));
        this.initButtonGroups();
        this.initPopup();
    }

    private void initButtonGroups() {
        this.buttonGroup.add((AbstractButton)this.jToggleCost);
        this.buttonGroup.add((AbstractButton)this.jToggleSession);
        this.buttonGroup.add((AbstractButton)this.jToggleDest);
        this.buttonGroup.add((AbstractButton)this.jToggleService);
        this.buttonGroup.add((AbstractButton)this.jToggleServiceSessions);
        this.buttonGroup.add((AbstractButton)this.jToggleIncoming);
    }

    private void initPopup() {
        this.emailCsvZipitem.setActionCommand("email");
        this.emailCsvZipitem.addActionListener(e -> this.bGControlPanel_12_actionPerformed(e));
        this.popup.add(this.emailCsvZipitem);
        this.emailHtmlZipitem.setActionCommand("email");
        this.emailHtmlZipitem.addActionListener(e -> this.bGControlPanel_12_actionPerformed(e));
        this.popup.add(this.emailHtmlZipitem);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ServiceReportPanel.this.controlPanel.getButton(BGButtonPanel.EMAIL_M).getModel().setSelected(false);
                ServiceReportPanel.this.controlPanel.getButton(BGButtonPanel.EMAIL_M).getModel().setPressed(false);
            }
        });
    }

    private JPanel createRigthPanel() {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.setBorder((Border)new BGTitleBorder(" \u041b\u043e\u0433\u0438 "));
        JPanel topPanel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(null);
        Insets margin = this.jToggleSession.getMargin();
        margin.right = 2;
        margin.left = 2;
        this.jToggleCost.setMargin(margin);
        this.jToggleSession.setMargin(margin);
        this.jToggleDest.setMargin(margin);
        this.jToggleService.setMargin(margin);
        this.jToggleServiceSessions.setMargin(margin);
        this.jToggleIncoming.setMargin(margin);
        this.jToggleSession.setSelected(true);
        buttonPanel.add((Component)this.jToggleSession, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.jToggleCost, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        buttonPanel.add((Component)this.jToggleDest, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        buttonPanel.add((Component)this.jToggleService, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        buttonPanel.add((Component)this.jToggleServiceSessions, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        buttonPanel.add((Component)this.jToggleIncoming, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.pagePanel.init();
        this.pagePanel.setKey(((Object)((Object)this)).getClass().getName());
        topPanel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.noFreeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.tablePanel.setLayout(this.cardLayout);
        this.tablePanel.setBorder(null);
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableSession), "sessions");
        this.tablePanel.add((Component)new JScrollPane((Component)this.table0Rule), "sessions_rule");
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableCost), "amounts");
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableDest), "dirs");
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableService), "services");
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableServiceSessions), "service_sessions");
        this.tablePanel.add((Component)new JScrollPane((Component)this.tableSessionIncoming), "session_incoming");
        this.dataLogPanel.setVisible(false);
        this.dataLogPanel.add((Component)this.createLogPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        rightPanel.add((Component)this.tablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.dataLogPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        rightPanel.add((Component)this.createTotalPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        return rightPanel;
    }

    private JPanel createLogPanel() {
        this.dataLogTable.setMinimumSize(new Dimension(0, 50));
        JScrollPane scrollPane = new JScrollPane((Component)this.dataLogTable);
        scrollPane.setMinimumSize(new Dimension(0, 50));
        JButton button = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        button.addActionListener(e -> this.dataLogPanel.setVisible(false));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043b\u043e\u0433 "));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)button, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel createTotalPanel() {
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        jLabel2.setToolTipText("");
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setText("\u0421\u0443\u043c\u043c\u0430 (" + this.setup.get("dbinfo.currency.title.medium", "\u0440\u0443\u0431.") + "):");
        this.time_sum.setEnabled(true);
        this.time_sum.setMinimumSize(new Dimension(165, 20));
        this.time_sum.setEditable(false);
        this.time_sum.setText("");
        this.time_sum.setColumns(18);
        this.time_sum.setHorizontalAlignment(0);
        this.time_sum_round.setEnabled(true);
        this.time_sum_round.setMinimumSize(new Dimension(165, 20));
        this.time_sum_round.setEditable(false);
        this.time_sum_round.setText("");
        this.time_sum_round.setColumns(18);
        this.time_sum_round.setHorizontalAlignment(0);
        this.money_sum.setMinimumSize(new Dimension(110, 20));
        this.money_sum.setDisabledTextColor(Color.white);
        this.money_sum.setEditable(false);
        this.money_sum.setText("");
        this.money_sum.setColumns(10);
        this.money_sum.setHorizontalAlignment(0);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setText("\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439: ");
        this.sessions_count.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.sessions_count.setMinimumSize(new Dimension(30, 22));
        this.sessions_count.setPreferredSize(new Dimension(30, 20));
        this.sessions_count.setEditable(false);
        this.sessions_count.setText("");
        this.sessions_count.setColumns(8);
        this.sessions_count.setHorizontalAlignment(0);
        JPanel totalPanel = new JPanel();
        totalPanel.setLayout(new GridBagLayout());
        totalPanel.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        totalPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 (\u0441\u0435\u043a.):"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        totalPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 (\u0441\u0435\u043a. \u043e\u043a\u0440.):"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        totalPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        totalPanel.add((Component)this.sessions_count, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        totalPanel.add((Component)this.time_sum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        totalPanel.add((Component)this.time_sum_round, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        totalPanel.add((Component)this.money_sum, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return totalPanel;
    }

    private JPanel createLeftPanel() {
        this.points.getList().getParent().setMaximumSize(new Dimension(240, 0));
        this.points.getList().getParent().setPreferredSize(new Dimension(217, 0));
        this.rules.getList().getParent().setMaximumSize(new Dimension(240, 0));
        this.rules.getList().getParent().setPreferredSize(new Dimension(217, 0));
        this.periodPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.periodPanel.addActionListener(e -> this.setData());
        JPanel pointPanel = new JPanel(new GridBagLayout());
        pointPanel.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0439\u043d\u0442\u044b \\ \u041f\u0440\u0430\u0432\u0438\u043b\u0430 "));
        pointPanel.add((Component)this.tabPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)pointPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.controlPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        leftPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return leftPanel;
    }

    public void setData() {
        String selectedPoints = this.points.getListValues();
        String selectedRules = this.rules.getListValues();
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAction("ClientItemList");
        request.setAttribute("type", "1");
        request.setAttribute("datefrom", this.periodPanel.getDateString1());
        request.setAttribute("dateto", this.periodPanel.getDateString2());
        Document doc = this.getDocument(request);
        ClientUtils.buildList((JList)this.points.getList(), (Node)XMLUtils.getNode((Document)doc, (String)"items"));
        if (this.points.getList().getModel().getSize() <= 0) {
            this.tabPanel.remove((Component)this.points);
            this.type = 2;
            if (this.jToggleDest.isSelected() || this.jToggleIncoming.isSelected()) {
                this.jToggleSession.setSelected(true);
            }
            this.jToggleDest.setEnabled(false);
            this.jToggleIncoming.setEnabled(false);
        } else {
            this.tabPanel.add((Component)this.points, "\u041f\u043e\u0439\u043d\u0442\u044b");
            this.points.setListValues(selectedPoints);
        }
        request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAction("ClientItemList");
        request.setAttribute("type", "2");
        request.setAttribute("datefrom", this.periodPanel.getDateString1());
        request.setAttribute("dateto", this.periodPanel.getDateString2());
        doc = this.getDocument(request);
        ClientUtils.buildList((JList)this.rules.getList(), (Node)XMLUtils.getNode((Document)doc, (String)"items"));
        if (this.rules.getList().getModel().getSize() <= 0) {
            this.tabPanel.remove((Component)this.rules);
        } else {
            this.tabPanel.add((Component)this.rules, "\u041f\u0440\u0430\u0432\u0438\u043b\u0430");
            this.rules.setListValues(selectedRules);
        }
        if (this.tabPanel.getTabCount() > 0) {
            this.tabPanel.setSelectedIndex(0);
        }
        this.tabChanged();
    }

    private void getData() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "xml");
        this.setDocument(this.getDocument(request));
    }

    private Request getRequest() {
        String items;
        if (this.jToggleCost.isSelected()) {
            this.show_mode = 1;
            this.cardLayout.show(this.tablePanel, "amounts");
        } else if (this.jToggleSession.isSelected()) {
            this.show_mode = 0;
            if (this.type == 1) {
                this.cardLayout.show(this.tablePanel, "sessions");
            } else {
                this.cardLayout.show(this.tablePanel, "sessions_rule");
            }
        } else if (this.jToggleDest.isSelected()) {
            this.show_mode = 2;
            this.cardLayout.show(this.tablePanel, "dirs");
        } else if (this.jToggleService.isSelected()) {
            this.show_mode = 3;
            this.cardLayout.show(this.tablePanel, "services");
        } else if (this.jToggleServiceSessions.isSelected()) {
            this.show_mode = 4;
            this.cardLayout.show(this.tablePanel, "service_sessions");
        } else if (this.jToggleIncoming.isSelected()) {
            this.show_mode = 5;
            this.cardLayout.show(this.tablePanel, "session_incoming");
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        switch (this.show_mode) {
            case 0: {
                request.setAction("ReportSession");
                break;
            }
            case 1: {
                request.setAction("ReportAmount");
                break;
            }
            case 2: {
                request.setAction("ReportDirect");
                break;
            }
            case 3: {
                request.setAction("ReportService");
                break;
            }
            case 4: {
                request.setAction("ReportServiceSession");
                break;
            }
            case 5: {
                request.setAction("ReportSessionIncoming");
            }
        }
        request.setAttribute("dest", this.destId);
        request.setAttribute("sid", this.serviceId);
        request.setAttribute("date1", this.periodPanel.getDateString1());
        request.setAttribute("date2", this.periodPanel.getDateString2());
        if (this.noFreeCombo.isSelected()) {
            request.setAttribute("nofree", "1");
        }
        if (this.type == 1) {
            request.setAttribute("type", "1");
            items = this.points.getListValues();
            if (items == null || items.length() <= 0) {
                items = this.points.getAllListValues();
            }
        } else {
            request.setAttribute("type", "2");
            items = this.rules.getListValues();
            if (items == null || items.length() <= 0) {
                items = this.rules.getAllListValues();
            }
        }
        if (this.itemId != null) {
            request.setAttribute("items", this.itemId);
        } else {
            request.setAttribute("items", items);
        }
        return request;
    }

    public void setDocument(Document doc) {
        Element tableElement = XMLUtils.getElement((Document)doc, (String)"table");
        this.time_sum.setText(tableElement.getAttribute("total_time"));
        this.time_sum_round.setText(tableElement.getAttribute("total_time_round"));
        this.money_sum.setText(tableElement.getAttribute("total_cost"));
        this.sessions_count.setText(tableElement.getAttribute("total_number"));
        this.pagePanel.setPageInfo(tableElement);
        if (ClientUtils.checkStatus((Document)doc)) {
            if (this.show_mode == 0) {
                if (this.type == 1) {
                    this.tableSession.updateData((Node)tableElement);
                } else {
                    this.table0Rule.updateData((Node)tableElement);
                }
            } else if (this.show_mode == 1) {
                this.tableCost.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            } else if (this.show_mode == 2) {
                this.tableDest.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            } else if (this.show_mode == 3) {
                this.tableService.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            } else if (this.show_mode == 4) {
                this.tableServiceSessions.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            } else if (this.show_mode == 5) {
                this.tableSessionIncoming.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            }
        }
    }

    private String getHtml() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "html");
        request.setAttribute("show_all", "1");
        String result = "<html>\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u0440\u0438\u0448\u0435\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430</html>";
        try {
            result = TransferManager.getString((Request)request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    void pageCounter_propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName != null && propertyName.startsWith("to")) {
            this.getData();
        }
    }

    void bGControlPanel_12_actionPerformed(ActionEvent e) {
        this.serviceId = null;
        this.destId = null;
        this.itemId = null;
        this.dataLogPanel.setVisible(false);
        String actionCommand = e.getActionCommand();
        if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
            new HtmlPrinter(this.getHtml(), 800, 300);
        } else if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
            String email;
            String zip = null;
            String output = null;
            if (this.show_mode == 4) {
                if (e.getSource() == this.emailCsvZipitem) {
                    zip = "1";
                    output = "csv";
                } else if (e.getSource() == this.emailHtmlZipitem) {
                    zip = "1";
                    output = "html";
                } else {
                    this.popup.show(this.controlPanel.getButton(BGButtonPanel.EMAIL_M), 0, this.controlPanel.getButton(BGButtonPanel.EMAIL_M).getHeight() - 1);
                    return;
                }
            }
            if ((email = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 EMail", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3)) != null) {
                Request request = this.getRequest();
                request.setAttribute("email", email);
                request.setAttribute("show_all", "1");
                request.setAttribute("contentType", "html");
                request.setAttribute("output", output);
                request.setAttribute("zip", zip);
                InputStream input = this.getInputStream(request);
                if (input != null) {
                    try {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        input.close();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
            BGFileChooser fc = new BGFileChooser((Component)((Object)this));
            FileFilter[] ff = fc.getChoosableFileFilters();
            if (ff != null) {
                for (int i = 0; i < ff.length; ++i) {
                    fc.removeChoosableFileFilter(ff[i]);
                }
            }
            BGFileFilter htmlFilter = new BGFileFilter("html|html", "HTML");
            BGFileFilter csvFilter = new BGFileFilter("csv", "CSV");
            BGFileFilter htmlZipFilter = new BGFileFilter("zip", "HTML/ZIP");
            BGFileFilter csvZipFilter = new BGFileFilter("zip", "CSV/ZIP");
            fc.addChoosableFileFilter((FileFilter)htmlFilter);
            fc.addChoosableFileFilter((FileFilter)csvFilter);
            if (this.show_mode == 0 || this.show_mode == 4) {
                fc.addChoosableFileFilter((FileFilter)htmlZipFilter);
                fc.addChoosableFileFilter((FileFilter)csvZipFilter);
            }
            fc.setFileFilter(fc.getChoosableFileFilters()[0]);
            if (fc.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                try {
                    if (csvFilter.equals(fc.getFileFilter())) {
                        Request request = this.getRequest();
                        request.setAttribute("contentType", "html");
                        request.setAttribute("output", "csv");
                        request.setAttribute("show_all", "1");
                        InputStream is = this.getInputStream(request);
                        ClientUtils.saveBinaryFile((InputStream)is, (File)fc.getSelectedFile(), (String)".csv");
                        is.close();
                    } else if (htmlZipFilter.equals(fc.getFileFilter())) {
                        Request request = this.getRequest();
                        request.setAttribute("contentType", "html");
                        request.setAttribute("show_all", "1");
                        request.setAttribute("zip", "1");
                        InputStream is = this.getInputStream(request);
                        ClientUtils.saveBinaryFile((InputStream)is, (File)fc.getSelectedFile(), (String)".zip");
                        is.close();
                    } else if (csvZipFilter.equals(fc.getFileFilter())) {
                        Request request = this.getRequest();
                        request.setAttribute("contentType", "html");
                        request.setAttribute("show_all", "1");
                        request.setAttribute("output", "csv");
                        request.setAttribute("zip", "1");
                        InputStream is = this.getInputStream(request);
                        ClientUtils.saveBinaryFile((InputStream)is, (File)fc.getSelectedFile(), (String)".zip");
                        is.close();
                    } else if (htmlFilter.equals(fc.getFileFilter())) {
                        Request request = this.getRequest();
                        request.setAttribute("contentType", "html");
                        request.setAttribute("show_all", "1");
                        InputStream is = this.getInputStream(request);
                        ClientUtils.saveBinaryFile((InputStream)is, (File)fc.getSelectedFile(), (String)".html");
                        is.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } else if (BGButtonPanel.DO_M.getActionCommand().equals(actionCommand)) {
            this.pagePanel.init();
            this.getData();
        }
    }

    private void showSessionsForDest() {
        int row = this.tableDest.getSelectedRow();
        if (row >= 0) {
            this.destId = this.tableDest.getColumnValueString(row, "dest_id");
            this.itemId = this.tableDest.getColumnValueString(row, "item_id");
            this.jToggleSession.setSelected(true);
            this.getData();
        }
    }

    private void showSessionsForService() {
        int row = this.tableService.getSelectedRow();
        if (row >= 0) {
            this.serviceId = this.tableService.getColumnValueString(row, "sid");
            this.itemId = this.tableService.getColumnValueString(row, "item_id");
            this.jToggleSession.setSelected(true);
            this.getData();
        }
    }

    private void showDataLog(String cdrId, String hour) {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("DataLog");
        req.setAttribute("id", cdrId);
        req.setAttribute("hour", hour);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.dataLogTable.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            this.dataLogPanel.setVisible(true);
        }
    }

    private void tabChanged() {
        if (this.tabPanel.getSelectedComponent() == this.rules) {
            this.type = 2;
            if (this.jToggleDest.isSelected() || this.jToggleIncoming.isSelected()) {
                this.jToggleSession.setSelected(true);
            }
            this.jToggleDest.setEnabled(false);
            this.jToggleIncoming.setEnabled(false);
        } else if (this.tabPanel.getSelectedComponent() == this.points) {
            this.type = 1;
            this.jToggleDest.setEnabled(true);
            this.jToggleIncoming.setEnabled(true);
        }
    }
}

