/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.tariff;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class StatusAcceptTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"flag_green");
    private BGUComboBox<IdTitle> modeBox = new BGUComboBox();
    private int mode = -1;
    private BGUComboBox<IdTitle> statusBox = new BGUComboBox();
    private int status = -1;
    private JLabel view;
    private JPanel editor;
    private List<IdTitle> contractStatusList;
    private List<IdTitle> accountStatusList;
    private ContractStatusService contractStatusService = null;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.modeBox.addItem((Object)new IdTitle(0, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        this.modeBox.addItem((Object)new IdTitle(1, "\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u0430"));
        this.modeBox.setSelectedIndex(0);
        try {
            this.contractStatusList = new ArrayList<IdTitle>();
            this.contractStatusList.add(new IdTitle(-1, "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e"));
            this.contractStatusList.addAll(this.getContractStatusService().getStatusList(false).stream().map(i -> i).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.statusBox.setData(this.contractStatusList);
        this.statusBox.setSelectedIndex(0);
        this.accountStatusList = new ArrayList<IdTitle>();
        this.accountStatusList.add(new IdTitle(-1, "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e"));
        this.accountStatusList.add(new IdTitle(1, "\u0412\u043a\u043b\u044e\u0447\u0435\u043d"));
        this.accountStatusList.add(new IdTitle(0, "\u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d"));
        this.accountStatusList.add(new IdTitle(-1, "\u0423\u0434\u0430\u043b\u0435\u043d"));
        this.modeBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                int modeId = this.getModeId();
                if (modeId == 0) {
                    this.statusBox.setData(this.contractStatusList);
                } else {
                    this.statusBox.setData(this.accountStatusList);
                }
            }
        });
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.editor.add(new JLabel("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435:"));
            this.editor.add((Component)this.modeBox);
            this.editor.add((Component)this.statusBox);
        }
        Dimension d = this.editor.getPreferredSize();
        d.width += 50;
        this.editor.setPreferredSize(d);
        this.editor.setMaximumSize(d);
        return this.editor;
    }

    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        this.modeBox.setSelectedItem((Object)this.mode);
        this.statusBox.setSelectedItem((Object)this.status);
        StringBuilder sb = new StringBuilder();
        sb.append("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 ");
        int modeId = this.getModeId();
        if (modeId == 0) {
            sb.append("\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:");
        } else {
            sb.append("\u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430:");
        }
        IdTitle status = this.getStatus();
        sb.append(status.getTitle());
        this.view.setText(sb.toString());
        return this.view;
    }

    protected void loadData() {
        this.extractData();
        this.modeBox.setSelectedItem((Object)this.mode);
        this.statusBox.setSelectedItem((Object)this.status);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("status", String.valueOf(this.getStatus().getId()));
        data.put("mode", String.valueOf(this.getModeId()));
        this.setDataInHash(data);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.mode = Utils.parseInt((String)((String)data.get("mode")), (int)0);
        this.status = Utils.parseInt((String)((String)data.get("status")), (int)-1);
    }

    public void loadFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("status", el.getAttribute("status"));
        data.put("mode", el.getAttribute("mode"));
        this.setDataInHash(data);
        this.saveData();
    }

    public void serializeToXML(Element el) {
        this.extractData();
        el.setAttribute("status", String.valueOf(this.status));
        el.setAttribute("mode", String.valueOf(this.mode));
    }

    private int getModeId() {
        return ((IdTitle)this.modeBox.getSelectedItem()).getId();
    }

    private IdTitle getStatus() {
        return (IdTitle)this.statusBox.getSelectedItem();
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            ClientContext context = new ClientContext("kernel", 0, 0, "setup");
            this.contractStatusService = (ContractStatusService)context.getPort(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }
}

