/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.YoomoneyEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="YooKassa", urlPatterns={"/yookassa/*", "/yakassa/*"})
public class ModuleExecutorApi
extends CommonExecutor {
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            moduleId = ModuleExecutorApi.getModuleId((HttpServletRequest)httpServletRequest);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            context = new ServerContext(this.setup, moduleId, 0);
            parentContext = ThreadContext.push((ThreadContext)context);
            try {
                contentType = httpServletRequest.getContentType();
                if (contentType != null && contentType.toLowerCase().startsWith("application/json")) {
                    encoding = httpServletRequest.getCharacterEncoding();
                    inputStream = httpServletRequest.getInputStream();
                    bytes = Utils.readByBlock((InputStream)inputStream);
                    jsonText = new String(bytes, encoding == null ? "utf-8" : encoding);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043e\u0442 Yoomoney: " + jsonText);
                    }
                    if ((idempotenceKey = httpServletRequest.getHeader("Idempotence-Key")) != null) {
                        con = Setup.getSetup().getDBConnectionFromPool();
                        try {
                            transactionManager = new TransactionManager(con, moduleId);
                            result = transactionManager.doPaymentRequest(jsonText, idempotenceKey);
                            httpServletResponse.setContentType("application/json; charset=utf-8");
                            outputStream = httpServletResponse.getOutputStream();
                            outputStream.write(result.getBytes("utf-8"));
                            outputStream.flush();
                            outputStream.close();
                            jsonObject = new JSONObject(result);
                            contractId = Utils.parseInt((String)String.valueOf(jsonObject.optQuery("/metadata/contractId")), (int)0);
                            objectId = String.valueOf(jsonObject.optQuery("/id"));
                            transaction = transactionManager.getTransactionByYoomoneyId(objectId);
                            if (transaction != null) ** GOTO lbl82
                            transactionManager.update((Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setAutopayment(Boolean.valueOf(String.valueOf(jsonObject.optQuery("/metadata/autopayment"))).booleanValue())).setStatus(String.valueOf(jsonObject.optQuery("/status")))).setSum(new BigDecimal(String.valueOf(jsonObject.optQuery("/amount/value"))))).setYoomoneyId(objectId).setPaymentType(String.valueOf(jsonObject.optQuery("/payment_method/type"))).setRawRequest(jsonText).build());
                        }
                        finally {
                            if (con != null) {
                                con.close();
                            }
                        }
                    } else {
                        jsonObject = new JSONObject(jsonText);
                        type = jsonObject.optString("type");
                        if ("notification".equals(type)) {
                            event = jsonObject.optString("event");
                            ykPaymentEvent = YoomoneyEvent.getYoomoneyPaymentEventByEvent(event);
                            switch (1.$SwitchMap$ru$bitel$bgbilling$modules$yoomoney$server$bean$YoomoneyEvent[ykPaymentEvent.ordinal()]) {
                                case 1: {
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectJson = jsonObject.optJSONObject("object");
                                    contractId = Utils.parseInt((String)String.valueOf(objectJson.optQuery("/metadata/contractId")), (int)0);
                                    objectId = String.valueOf(objectJson.optQuery("/id"));
                                    status = String.valueOf(objectJson.optQuery("/status"));
                                    sum = new BigDecimal(String.valueOf(objectJson.optQuery("/amount/value")));
                                    capturedAt = objectJson.optQuery("/captured_at");
                                    if (capturedAt == null) {
                                        capturedAt = objectJson.optQuery("/created_at");
                                    }
                                    con = Setup.getSetup().getDBConnectionFromPool();
                                    try {
                                        transactionManager = new TransactionManager(con, moduleId);
                                        transaction = transactionManager.getTransactionByYoomoneyId(objectId);
                                        if (transaction == null) {
                                            transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setStatus(status)).setSum(sum)).setYoomoneyId(objectId).setPaymentType(String.valueOf(objectJson.optQuery("/payment_method/type"))).setRawRequest(objectJson.toString()).setAutopayment(Boolean.valueOf(String.valueOf(objectJson.optQuery("/metadata/autopayment"))).booleanValue())).build();
                                            if (capturedAt != null) {
                                                try {
                                                    transaction.setTransactionDate((java.util.Date)new Date(dateFormat.parse(String.valueOf(capturedAt)).getTime() / 1000L * 1000L));
                                                }
                                                catch (Exception ex) {
                                                    this.getLogger().info("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 yoomoneyId=" + transaction.getYoomoneyId() + " \n\u0417\u0430\u043f\u0440\u043e\u0441 \u043e\u0442 Yoomoney: " + jsonText, (Throwable)ex);
                                                }
                                            }
                                            transactionManager.update(transaction);
                                        }
                                        transactionManager.doTransaction(objectId, status, sum, objectJson);
                                        break;
                                    }
                                    finally {
                                        if (con != null) {
                                            con.close();
                                        }
                                    }
                                }
                                default: {
                                    this.getLogger().error("unknown event = " + event);
                                    httpServletResponse.sendError(400, "Parse error");
                                }
                            }
                        } else {
                            this.getLogger().error("type = " + type + " (type != notification)");
                            httpServletResponse.sendError(400, "Parse error");
                        }
                    }
                } else {
                    this.getLogger().error("contentType != \"application/json\"");
                    httpServletResponse.sendError(400, "Parse error");
                }
                context.commit();
            }
            finally {
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            ex.printStackTrace();
            httpServletResponse.sendError(400, ex.getMessage());
        }
    }
}

