/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.mail.MailDocsSenderForAll;
import ru.bitel.common.Preferences;

public class BillDocsSenderForAll
extends RunTask {
    private final int moduleId;
    private final List<Integer> billCodes;
    private final List<Integer> invoiceCodes;
    private final int userId;

    public BillDocsSenderForAll(DocumentSendParameters senderTaskParameters) {
        this.moduleId = senderTaskParameters.getModuleId();
        this.billCodes = senderTaskParameters.getBillIds();
        this.invoiceCodes = senderTaskParameters.getInvoiceIds();
        this.userId = senderTaskParameters.getUserId();
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Bill. \u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0441 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u043e\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    public void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            BillManager billManager = new BillManager(con, this.moduleId);
            InvoiceManager invoiceManager = new InvoiceManager(con, this.moduleId);
            Map<Integer, List<Integer>> billMap = this.sortDocByContract(billManager, this.billCodes);
            Map<Integer, List<Integer>> invoiceMap = this.sortDocByContract(invoiceManager, this.invoiceCodes);
            ArrayList<Integer> sendCids = new ArrayList<Integer>();
            for (int contractId : billMap.keySet()) {
                this.sendMessage(con, contractId, billMap.get(contractId), invoiceMap.get(contractId));
                sendCids.add(contractId);
            }
            for (int contractId : invoiceMap.keySet()) {
                if (sendCids.contains(contractId)) continue;
                this.sendMessage(con, contractId, billMap.get(contractId), invoiceMap.get(contractId));
            }
        }
        catch (Exception ex) {
            this.getLogger().error("error bill docs sender for all task", (Throwable)ex);
        }
    }

    private void sendMessage(Connection con, int contactId, List<Integer> bills, List<Integer> invoices) {
        try {
            this.getLogger().debug("send message for contract #{}", (Object)contactId);
            EmailMaster emailMaster = new EmailMaster(this.setup, con, this.moduleId, this.userId);
            MailData mailData = new MailDocsSenderForAll().setModuleId(this.moduleId).setContractId(contactId);
            emailMaster.addMessage(mailData, "text");
            int index = 1;
            if (bills != null) {
                for (Integer id : bills) {
                    emailMaster.setDocumentId(DocumentSendParameters.SendingDataType.BILL, id);
                    emailMaster.addAttach(mailData, "file" + index++);
                }
            }
            if (invoices != null) {
                for (Integer id : invoices) {
                    emailMaster.setDocumentId(DocumentSendParameters.SendingDataType.INVOICE, id);
                    emailMaster.addAttach(mailData, "file" + index++);
                }
            }
            emailMaster.setContractId(contactId);
            mailData.setRecipients(emailMaster.getEmail()).setSubject(emailMaster.getSubject());
            new MailMsg((Preferences)this.setup).sendMessage(mailData);
        }
        catch (Exception e) {
            this.getLogger().error("send for contract #" + contactId + " error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Map<Integer, List<Integer>> sortDocByContract(AbstractManager manager, List<Integer> docIds) {
        HashMap<Integer, List<Integer>> res = new HashMap<Integer, List<Integer>>();
        if (docIds == null || docIds.isEmpty()) {
            return res;
        }
        for (int docId : docIds) {
            try {
                BillDoc docInfo = manager.getBillDocInfo(docId);
                if (docInfo != null) {
                    int contractId = docInfo.getContractId();
                    if (contractId > 0) {
                        res.computeIfAbsent(contractId, k -> new ArrayList()).add(docId);
                        continue;
                    }
                    this.getLogger().error("!!! contractId<1 !!! docId={}, docInfo={}", (Object)docId, (Object)docInfo);
                    continue;
                }
                this.getLogger().error("sortDocByContract: docInfo=null for docId=" + docId);
            }
            catch (Exception ex) {
                this.getLogger().error("docId={} [{}]", (Object)docId, (Object)ex.getMessage());
            }
        }
        return res;
    }
}

