/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import ru.bitel.bgbilling.modules.ipn.server.DlinkGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Profile;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class IPProfile
extends Profile {
    private String OID;
    private String OID_MASK_STATE;
    public static final int MASK_STATE_OTHER = 1;
    public static final int MASK_STATE_DST = 2;
    public static final int MASK_STATE_SRC = 3;
    public static final int MASK_STATE_ALL = 4;
    private String OID_SRC_MASK;
    private String OID_DST_MASK;
    private String OID_PROTO;
    public static final int PROTO_NONE = 1;
    public static final int PROTO_UDP = 5;
    private String OID_UDP_PORT_MASK_TYPE;
    public static final int UDP_PORT_MASK_OTHER = 1;
    public static final int UDP_PORT_MASK_DST = 2;
    private String OID_UDP_DST_PORT_MASK;
    private String OID_MANAGE;
    public static final int MANAGE_CREATE = 4;
    public static final int MANAGE_DELETE = 6;
    public static final String ZERO_IP_MASK = "00 00 00 00";
    private int maskState;
    private String srcMask;
    private String dstMask;
    private int udpPortMaskType;
    private String udpDstPortMask;
    private int protocol;

    public static final String getOid(int model) {
        String OID = null;
        switch (model) {
            case 1: {
                OID = "1.3.6.1.4.1.171.12.9.1.2.1";
                break;
            }
            case 2: {
                OID = "1.3.6.1.4.1.171.12.9.2.2.1";
            }
        }
        return OID;
    }

    public IPProfile(int model) {
        this.OID_MASK_STATE = this.OID + ".3";
        this.OID_SRC_MASK = this.OID + ".4";
        this.OID_DST_MASK = this.OID + ".5";
        this.OID_PROTO = this.OID + ".7";
        this.OID_UDP_PORT_MASK_TYPE = this.OID + ".11";
        this.OID_UDP_DST_PORT_MASK = this.OID + ".13";
        this.OID_MANAGE = this.OID + ".19";
        this.maskState = 1;
        this.OID = IPProfile.getOid(model);
        this.OID_MASK_STATE = this.OID + ".3";
        this.OID_SRC_MASK = this.OID + ".4";
        this.OID_DST_MASK = this.OID + ".5";
        this.OID_PROTO = this.OID + ".7";
        this.OID_UDP_PORT_MASK_TYPE = this.OID + ".11";
        this.OID_UDP_DST_PORT_MASK = this.OID + ".13";
        this.OID_MANAGE = this.OID + ".19";
    }

    public IPProfile(int model, int id, int maskState, String srcMask, String dstMask, int udpPortMaskType, String udpDstPortMask, int protocol) {
        this(model);
        this.id = id;
        this.maskState = maskState;
        this.srcMask = srcMask;
        this.dstMask = dstMask;
        this.udpPortMaskType = udpPortMaskType;
        this.udpDstPortMask = udpDstPortMask;
        this.protocol = protocol;
    }

    public String getDstMask() {
        return this.dstMask;
    }

    public int getMaskState() {
        return this.maskState;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public String getSrcMask() {
        return this.srcMask;
    }

    public String getUdpDstPortMask() {
        return this.udpDstPortMask;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("IPProfile maskState: ");
        result.append(this.maskState);
        result.append("; src_mask: ");
        result.append(this.srcMask);
        result.append("; dst_mask: ");
        result.append(this.dstMask);
        result.append("; proto: ");
        result.append(this.protocol);
        return result.toString();
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        if (oid.startsWith(this.OID_MASK_STATE)) {
            this.maskState = this.getInt(var);
        } else if (oid.startsWith(this.OID_SRC_MASK)) {
            this.srcMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_DST_MASK)) {
            this.dstMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_UDP_DST_PORT_MASK)) {
            this.udpDstPortMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_PROTO)) {
            this.protocol = this.getInt(var);
        }
    }

    @Override
    public void create(DlinkGateWorker gateWorker) throws Exception {
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        String oid = null;
        oid = this.OID_MASK_STATE + "." + this.id;
        pairs.add(new Object[]{oid, new AsnInteger(this.maskState)});
        if (this.maskState != 1) {
            oid = this.OID_SRC_MASK + "." + this.id;
            pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.srcMask), 64)});
        }
        if (this.maskState != 1) {
            oid = this.OID_DST_MASK + "." + this.id;
            pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.dstMask), 64)});
        }
        if (this.protocol == 5) {
            oid = this.OID_PROTO + "." + this.id;
            pairs.add(new Object[]{oid, new AsnInteger(this.protocol)});
        }
        if (this.udpPortMaskType == 2) {
            oid = this.OID_UDP_PORT_MASK_TYPE + "." + this.id;
            pairs.add(new Object[]{oid, new AsnInteger(this.udpPortMaskType)});
            oid = this.OID_UDP_DST_PORT_MASK + "." + this.id;
            pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.udpDstPortMask))});
        }
        oid = this.OID_MANAGE + "." + this.id;
        pairs.add(new Object[]{oid, new AsnInteger(4)});
        gateWorker.sendSetPdu(pairs);
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof IPProfile;
        if (result) {
            IPProfile cmp = (IPProfile)obj;
            result = result && cmp.getSrcMask().equals(this.srcMask);
            result = result && cmp.getDstMask().equals(this.dstMask);
            result = result && cmp.getMaskState() == this.maskState;
            result = result && cmp.getProtocol() == this.protocol;
            result = result && cmp.getUdpDstPortMask().equals(this.udpDstPortMask);
        }
        return result;
    }

    @Override
    public void delete(DlinkGateWorker gateWorker) throws Exception {
        String oid = this.OID_MANAGE + "." + this.id;
        gateWorker.sendSetPdu(oid, (AsnObject)new AsnInteger(6));
    }
}

