/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.uniteller.common.bean.Transaction;
import ru.bitel.bgbilling.modules.uniteller.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.uniteller.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="Uniteller", urlPatterns={"/uniteller/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block30: {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                String orderId = request.getParameter("Order_ID");
                String status = request.getParameter("Status");
                String signature = request.getParameter("Signature");
                String password = moduleSetup.get("uniteller.password", "");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Order_ID = " + orderId);
                    this.getLogger().debug("Status = " + status);
                }
                HashMap dataMap = new HashMap();
                List callbackFields = Utils.toList((String)moduleSetup.get("uniteller.callback.fields", "AcquirerID ApprovalCode BillNumber Card_IDP CardNumber Customer_IDP PaymentType Total"), (String)" ");
                if (this.getLogger().isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer("callbackFields = ");
                    callbackFields.forEach(i -> buffer.append((String)i).append(" "));
                    this.getLogger().debug(buffer.toString());
                }
                callbackFields.forEach(i -> {
                    String value = request.getParameter(i);
                    dataMap.put(i, value != null ? value : "");
                });
                if (this.getLogger().isDebugEnabled()) {
                    callbackFields.forEach(i -> this.getLogger().debug(i + " = " + (String)dataMap.get(i)));
                }
                if (orderId != null && status != null && signature != null) {
                    StringBuffer data = new StringBuffer(orderId + status);
                    callbackFields.forEach(i -> data.append((String)dataMap.get(i)));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("data = " + data);
                    }
                    data.append(password);
                    String calcSignature = Utils.getDigest((String)data.toString(), (String)"ASCII").toUpperCase();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Signature = " + signature);
                        this.getLogger().debug("calcSignature = " + calcSignature);
                    }
                    if (signature.equals(calcSignature)) {
                        PaymentDao paymentDao = new PaymentDao(con);
                        TransactionManager transactionManager = new TransactionManager(con, moduleId);
                        Transaction transaction = transactionManager.getTransactionByTransactionId(orderId);
                        if (transaction == null) {
                            String message = "Not found transaction for ID = " + orderId;
                            this.getLogger().error(message);
                            this.sendError(response, message);
                            return;
                        }
                        Payment payment = null;
                        HashSet statusOk = new HashSet();
                        Utils.toList((String)moduleSetup.get("uniteller.payment.status.ok", "paid")).forEach(e -> statusOk.add(e.toLowerCase()));
                        if (TransactionStatus.CANCELED.getCode().equals(status)) {
                            transaction.setStatus(TransactionStatus.CANCELED.getCode());
                            if (transaction.getPaymentId() > 0) {
                                payment = (Payment)paymentDao.get(transaction.getPaymentId());
                                if (payment != null) {
                                    paymentDao.delete(payment.getId());
                                }
                                transaction.setPaymentId(-1);
                            }
                        } else if (statusOk.contains(status.toLowerCase()) && transaction.getPaymentId() < 1) {
                            transaction.setStatus(TransactionStatus.OK.getCode());
                            Date paymentDate = transaction.getTransactionDate();
                            if (paymentDate == null) {
                                paymentDate = new Date();
                                transaction.setTransactionDate(paymentDate);
                            }
                            payment = Payment.builder().setDate(paymentDate).setTypeId(moduleSetup.getInt("uniteller.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("uniteller.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 Uniteller [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", orderId)).build();
                            paymentDao.update((Object)payment);
                            transaction.setPaymentId(payment.getId());
                        } else if ("Not Authorized".equalsIgnoreCase(status)) {
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                        }
                        this.checkReceiptSignature(request, password);
                        this.autopayment(transaction, con, moduleId);
                        String parameters = transaction.getParameters();
                        transaction.setParameters((String)(Utils.isBlankString((String)parameters) ? "" : parameters + "\n") + Utils.toString(dataMap, (String)"\n"));
                        transactionManager.update(transaction);
                        if (payment == null) break block30;
                        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                            balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                        }
                        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                        break block30;
                    }
                    String message = "signature != calcSignature [signature = " + signature + "; calcSignature = " + calcSignature + "]";
                    this.getLogger().error(message);
                    this.sendError(response, "Check signature error!");
                    break block30;
                }
                String message = "orderId == null || status == null || signature == null";
                this.getLogger().error("orderId == null || status == null || signature == null");
                this.sendError(response, "orderId == null || status == null || signature == null");
            }
            catch (Exception ex) {
                this.logError(ex);
                this.sendError(response, ex.getMessage());
            }
        }
    }

    private void sendError(HttpServletResponse response, String message) {
        try {
            response.sendError(500, message);
        }
        catch (IOException ex) {
            this.logError(ex);
        }
    }

    private void autopayment(Transaction transaction, Connection con, int moduleId) throws Exception {
        if (transaction.getParameters() != null) {
            AutopaymentManager autopaymentManager;
            Autopayment autopayment;
            int autopaymentId = Utils.parseInt((String)((String)Utils.stringToPairsHash((String)transaction.getParameters()).get("autopaymentId")), (int)0);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Parameters = " + transaction.getParameters());
                this.getLogger().debug("autopaymentId = " + autopaymentId);
                this.getLogger().debug("transaction.getStatus() = " + transaction.getStatus());
            }
            if ((autopayment = (autopaymentManager = new AutopaymentManager(con, moduleId)).getAutopayment(autopaymentId)) != null) {
                if (transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
                    autopayment.setAccessToken(String.valueOf(transaction.getTransactionId()));
                    autopayment.getPeriod().setLocalDateTimeFrom(LocalDateTime.now());
                } else {
                    autopayment.setAccessToken(null);
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                }
                autopaymentManager.update(autopayment);
            }
        }
    }

    private void checkReceiptSignature(HttpServletRequest request, String password) throws UnsupportedEncodingException {
        String status = request.getParameter("Status");
        String orderId = request.getParameter("Order_ID");
        String receipt = request.getParameter("Receipt");
        String receiptSignature = request.getParameter("ReceiptSignature");
        if (receipt != null && receiptSignature != null) {
            String receiptString = new String(Base64.getDecoder().decode(receipt), "UTF-8");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Receipt = " + receiptString);
                this.getLogger().debug("ReceiptSignature = " + receiptSignature);
            }
            if (receiptSignature.equals(Utils.getDigest((String)(orderId + status + receipt + password), (String)"ASCII", (String)"SHA-256").toUpperCase())) {
                this.getLogger().debug("Check ReceiptSignature => OK");
            }
        }
    }
}

