/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.common.bean.enums.BGGeneratorType;
import ru.bitel.bgbilling.kernel.generator.server.bean.BGGeneratorDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ConverterContractPatternName
extends AbstractBGConverter {
    private static final String CONVERTER_DB_KEY = "contract.pattern.name.converter.run";

    @Override
    public void runConverter(Connection connection) {
        boolean needConvert = Utils.maskBlank(ServerUtils.getSetupValue((Connection)connection, (String)CONVERTER_DB_KEY), "0").equals("0");
        if (needConvert) {
            String querySelect = "SELECT id, name_pattern, name_pattern_id FROM `contract_pattern`";
            String queryUpdate = "UPDATE `contract_pattern` SET name_pattern_id=? WHERE id=?";
            try (Statement st = connection.createStatement();
                 PreparedStatement ps = connection.prepareStatement(queryUpdate);){
                BGGeneratorDao generatorDao = new BGGeneratorDao(connection);
                List<BGGenerator> generators = generatorDao.list(BGGeneratorType.CONTRACT);
                try (ResultSet rs = st.executeQuery(querySelect);){
                    while (rs.next()) {
                        String patternName = rs.getString("name_pattern");
                        int patternNameId = rs.getInt("name_pattern_id");
                        if (!Utils.notBlankString(patternName) || patternNameId != 0) continue;
                        BGGenerator generator = generators.stream().filter(a -> a.getPattern().equals(patternName)).findFirst().orElse(new BGGenerator());
                        if (generator.getId() == 0) {
                            generator.setTitle(patternName);
                            generator.setPattern(patternName);
                            generatorDao.update(generator);
                            generators.add(generator);
                        }
                        ps.setInt(1, generator.getId());
                        ps.setInt(2, rs.getInt("id"));
                        ps.executeUpdate();
                    }
                }
                ServerUtils.setSetupValue((Connection)connection, (String)CONVERTER_DB_KEY, (String)"1");
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }
}

