/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGControlPanelDateWithTime;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;

public class BGControlPanelPeriodWithTime
extends JPanel {
    protected BGControlPanelDateWithTime dateFrom = new BGControlPanelDateWithTime();
    protected BGControlPanelDateWithTime dateTo = new BGControlPanelDateWithTime();

    public BGControlPanelPeriodWithTime() {
        int gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dateFrom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getSetPeriodButton(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.dateTo, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dateFrom.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date1", e.getOldValue(), e.getNewValue());
            }
        });
        this.dateTo.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date2", e.getOldValue(), e.getNewValue());
            }
        });
    }

    private JButton getSetPeriodButton() {
        JButton button = new JButton("-");
        button.setMargin(new Insets(3, 3, 3, 3));
        button.addActionListener(e -> {
            ActionListener actionListener = a -> {
                String command = a.getActionCommand();
                if ("prev".equals(command)) {
                    this.doPrevNext(-1);
                    return;
                }
                if ("next".equals(command)) {
                    this.doPrevNext(1);
                    return;
                }
                String mode = command.substring(0, 1);
                LocalDateTime time = LocalDateTime.parse(command.substring("M".equals(mode) ? 3 : 1), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                switch (mode) {
                    case "h": {
                        this.setDateFrom(time);
                        time = time.plusHours(1L).minusMinutes(1L);
                        this.setDateTo(time);
                        break;
                    }
                    case "d": {
                        this.setDateFrom(time);
                        time = time.plusDays(1L).minusMinutes(1L);
                        this.setDateTo(time);
                        break;
                    }
                    case "w": {
                        this.setDateFrom(time);
                        time = time.plusWeeks(1L).minusMinutes(1L);
                        this.setDateTo(time);
                        break;
                    }
                    case "m": {
                        this.setDateFrom(time);
                        time = time.plusMonths(1L).minusMinutes(1L);
                        this.setDateTo(time);
                        break;
                    }
                    case "M": {
                        this.setDateFrom(time);
                        time = time.plusMinutes(Utils.parseInt(command.substring(1, 3)) - 1);
                        this.setDateTo(time);
                        break;
                    }
                }
            };
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItemPrev = new JMenuItem("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439");
            menuItemPrev.setActionCommand("prev");
            menuItemPrev.addActionListener(actionListener);
            popupMenu.add(menuItemPrev);
            JMenuItem menuItemNext = new JMenuItem("\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
            menuItemNext.setActionCommand("next");
            menuItemNext.addActionListener(actionListener);
            popupMenu.add(menuItemNext);
            popupMenu.add(new JSeparator());
            popupMenu.add(this.getMinuteMenu(actionListener));
            popupMenu.add(this.getHourMenu(actionListener));
            popupMenu.add(this.getDayMenu(actionListener));
            popupMenu.add(this.getWeekMenu(actionListener));
            popupMenu.add(this.getMonthMenu(actionListener));
            popupMenu.show(this, button.getX(), button.getY() + button.getHeight());
        });
        return button;
    }

    private void doPrevNext(int direct) {
        LocalDateTime from = this.getDateFrom();
        LocalDateTime to = this.getDateTo();
        if (from == null || to == null) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434");
            return;
        }
        if (from.getYear() == to.getYear() && from.getMonthValue() == 1 && to.getMonthValue() == 12 && from.getDayOfMonth() == 1 && to.getDayOfMonth() == 31 && from.getHour() == 0 && to.getHour() == 23 && from.getMinute() == 0 && to.getMinute() == 59) {
            this.setDateFrom(direct == 1 ? from.plusYears(1L) : from.minusYears(1L));
            this.setDateTo(direct == 1 ? to.plusYears(1L) : to.minusYears(1L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == 1 && to.getDayOfMonth() == to.toLocalDate().lengthOfMonth() && from.getHour() == 0 && to.getHour() == 23 && from.getMinute() == 0 && to.getMinute() == 59) {
            this.setDateFrom(direct == 1 ? from.plusMonths(1L) : from.minusMonths(1L));
            this.setDateTo(direct == 1 ? from.plusMonths(2L).minusMinutes(1L) : from.minusMinutes(1L));
        } else if (from.getDayOfWeek().getValue() == 1 && from.plusDays(7L).minusMinutes(1L).compareTo(to) == 0) {
            this.setDateFrom(direct == 1 ? from.plusDays(7L) : from.minusDays(7L));
            this.setDateTo(direct == 1 ? to.plusDays(7L) : to.minusDays(7L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == 0 && to.getHour() == 23 && from.getMinute() == 0 && to.getMinute() == 59) {
            this.setDateFrom(direct == 1 ? from.plusDays(1L) : from.minusDays(1L));
            this.setDateTo(direct == 1 ? to.plusDays(1L) : to.minusDays(1L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && from.getMinute() == 0 && to.getMinute() == 59) {
            this.setDateFrom(direct == 1 ? from.plusHours(1L) : from.minusHours(1L));
            this.setDateTo(direct == 1 ? to.plusHours(1L) : to.minusHours(1L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && from.getMinute() == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(1L) : from.minusMinutes(1L));
            this.setDateTo(direct == 1 ? to.plusMinutes(1L) : to.minusMinutes(1L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && 3 * (from.getMinute() / 3) == from.getMinute() && from.getMinute() + 2 == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(3L) : from.minusMinutes(3L));
            this.setDateTo(direct == 1 ? to.plusMinutes(3L) : to.minusMinutes(3L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && 5 * (from.getMinute() / 5) == from.getMinute() && from.getMinute() + 4 == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(5L) : from.minusMinutes(5L));
            this.setDateTo(direct == 1 ? to.plusMinutes(5L) : to.minusMinutes(5L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && 10 * (from.getMinute() / 10) == from.getMinute() && from.getMinute() + 9 == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(10L) : from.minusMinutes(10L));
            this.setDateTo(direct == 1 ? to.plusMinutes(10L) : to.minusMinutes(10L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && 15 * (from.getMinute() / 15) == from.getMinute() && from.getMinute() + 14 == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(15L) : from.minusMinutes(15L));
            this.setDateTo(direct == 1 ? to.plusMinutes(15L) : to.minusMinutes(15L));
        } else if (from.getYear() == to.getYear() && from.getMonthValue() == to.getMonthValue() && from.getDayOfMonth() == to.getDayOfMonth() && from.getHour() == to.getHour() && 30 * (from.getMinute() / 30) == from.getMinute() && from.getMinute() + 29 == to.getMinute()) {
            this.setDateFrom(direct == 1 ? from.plusMinutes(30L) : from.minusMinutes(30L));
            this.setDateTo(direct == 1 ? to.plusMinutes(30L) : to.minusMinutes(30L));
        }
    }

    private JMenuItem getJMenuItem(String title, String prefix, LocalDateTime time, ActionListener actionListener) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setActionCommand(prefix + time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    private JMenu getMinuteMenu(ActionListener actionListener) {
        JMenu menu = new JMenu("\u043c\u0438\u043d\u0443\u0442\u044b");
        LocalDateTime time = LocalDateTime.now().withMinute(0).truncatedTo(ChronoUnit.MINUTES);
        menu.add(this.getJMenuItem("\u0442\u0435\u043a\u0443\u0449\u0430\u044f", "M01", time, actionListener));
        menu.add(new JSeparator());
        time = this.getDateFrom() != null ? this.getDateFrom() : time;
        menu.add(this.getJMenuItem("1 \u043c\u0438\u043d\u0443\u0442\u0430", "M01", time, actionListener));
        menu.add(this.getJMenuItem("3 \u043c\u0438\u043d\u0443\u0442\u044b", "M03", time.withMinute(3 * (time.getMinute() / 3)), actionListener));
        menu.add(this.getJMenuItem("5 \u043c\u0438\u043d\u0443\u0442", "M05", time.withMinute(5 * (time.getMinute() / 5)), actionListener));
        menu.add(this.getJMenuItem("10 \u043c\u0438\u043d\u0443\u0442", "M10", time.withMinute(10 * (time.getMinute() / 10)), actionListener));
        menu.add(this.getJMenuItem("15 \u043c\u0438\u043d\u0443\u0442", "M15", time.withMinute(15 * (time.getMinute() / 15)), actionListener));
        menu.add(this.getJMenuItem("30 \u043c\u0438\u043d\u0443\u0442", "M30", time.withMinute(30 * (time.getMinute() / 30)), actionListener));
        return menu;
    }

    private JMenu getHourMenu(ActionListener actionListener) {
        JMenu menu = new JMenu("\u0447\u0430\u0441");
        LocalDateTime time = LocalDateTime.now().withMinute(0).truncatedTo(ChronoUnit.MINUTES);
        menu.add(this.getJMenuItem("\u0442\u0435\u043a\u0443\u0449\u0438\u0439", "h", time, actionListener));
        time = time.minusHours(1L);
        menu.add(this.getJMenuItem("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439", "h", time, actionListener));
        menu.add(new JSeparator());
        time = this.getDateFrom() != null ? this.getDateFrom().withMinute(0) : time;
        time = time.withHour(0);
        for (int h = 0; h < 24; ++h) {
            menu.add(this.getJMenuItem((h < 10 ? "0" : "") + h, "h", time, actionListener));
            time = time.plusHours(1L);
        }
        return menu;
    }

    private JMenu getDayMenu(ActionListener actionListener) {
        JMenu menu = new JMenu("\u0434\u0435\u043d\u044c");
        LocalDateTime time = LocalDateTime.now().withHour(0).truncatedTo(ChronoUnit.HOURS);
        menu.add(this.getJMenuItem("\u0442\u0435\u043a\u0443\u0449\u0438\u0439", "d", time, actionListener));
        time = time.minusDays(1L);
        menu.add(this.getJMenuItem("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439", "d", time, actionListener));
        menu.add(new JSeparator());
        time = this.getDateFrom() != null ? this.getDateFrom().withMinute(0).withHour(0) : time;
        time = time.withDayOfMonth(1);
        for (int d = 1; d < 32; ++d) {
            menu.add(this.getJMenuItem((d < 10 ? "0" : "") + d, "d", time, actionListener));
            time = time.plusDays(1L);
        }
        return menu;
    }

    private JMenu getWeekMenu(ActionListener actionListener) {
        JMenu menu = new JMenu("\u043d\u0435\u0434\u0435\u043b\u044f");
        LocalDateTime time = LocalDateTime.now().with(ChronoField.DAY_OF_WEEK, 1L).truncatedTo(ChronoUnit.DAYS);
        menu.add(this.getJMenuItem("\u0442\u0435\u043a\u0443\u0449\u0430\u044f", "w", time, actionListener));
        time = time.minusWeeks(1L);
        menu.add(this.getJMenuItem("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f", "w", time, actionListener));
        return menu;
    }

    private JMenu getMonthMenu(ActionListener actionListener) {
        JMenu menu = new JMenu("\u043c\u0435\u0441\u044f\u0446");
        LocalDateTime time = LocalDateTime.now().withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
        menu.add(this.getJMenuItem("\u0442\u0435\u043a\u0443\u0449\u0438\u0439", "m", time, actionListener));
        time = time.minusMonths(1L);
        menu.add(this.getJMenuItem("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439", "m", time, actionListener));
        menu.add(new JSeparator());
        time = this.getDateFrom() != null ? this.getDateFrom().withMinute(0).withHour(0).withDayOfMonth(1) : time;
        time = time.withMonth(1);
        for (int m = 1; m < 13; ++m) {
            menu.add(this.getJMenuItem((m < 10 ? "0" : "") + m, "m", time, actionListener));
            time = time.plusMonths(1L);
        }
        return menu;
    }

    public PeriodWithTime getPeriod() {
        PeriodWithTime period = new PeriodWithTime();
        period.setLocalDateTimeFrom(this.getDateFrom());
        period.setLocalDateTimeTo(this.getDateTo());
        return period;
    }

    public void setPeriod(PeriodWithTime period) {
        if (period != null) {
            this.setDateFrom(period.getLocalDateTimeFrom());
            this.setDateTo(period.getLocalDateTimeTo());
        } else {
            this.setDateFrom(null);
            this.setDateTo(null);
        }
    }

    public void setDateFrom(LocalDateTime date) {
        LocalDateTime oldValue = this.dateFrom.getLocalDateTime();
        this.dateFrom.setLocalDateTime(date);
        this.firePropertyChange("dateFrom", oldValue, date);
    }

    public void setDateTo(LocalDateTime date) {
        LocalDateTime oldValue = this.dateTo.getLocalDateTime();
        this.dateTo.setLocalDateTime(date);
        this.firePropertyChange("dateTo", oldValue, date);
    }

    public LocalDateTime getDateFrom() {
        return this.dateFrom.getLocalDateTime();
    }

    public LocalDateTime getDateTo() {
        return this.dateTo.getLocalDateTime();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }
}

