/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.table.common.enums.BGUTableCellRenderer;

public class BGUTableColumn {
    private String title;
    private int minWidth = -1;
    private int prefWidth = -1;
    private int maxWidth = -1;
    private String name;
    private String className;
    private boolean sortable = false;
    private boolean editable = false;
    private BGUTableCellRenderer tableCellRenderer = BGUTableCellRenderer.TEXT_LEFT;

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    @XmlAttribute
    public int getMinWidth() {
        return this.minWidth;
    }

    @XmlAttribute
    public int getPrefWidth() {
        return this.prefWidth;
    }

    @XmlAttribute
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public String getClassName() {
        return this.className;
    }

    @XmlAttribute
    public boolean isSortable() {
        return this.sortable;
    }

    @XmlAttribute
    public boolean isEditable() {
        return this.editable;
    }

    @XmlAttribute
    public BGUTableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public BGUTableColumn setTitle(String title) {
        this.title = title;
        return this;
    }

    public BGUTableColumn setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public BGUTableColumn setPrefWidth(int prefWidth) {
        this.prefWidth = prefWidth;
        return this;
    }

    public BGUTableColumn setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public BGUTableColumn setWidth(int width) {
        this.minWidth = width;
        this.prefWidth = width;
        this.maxWidth = width;
        return this;
    }

    public BGUTableColumn setName(String name) {
        this.name = name;
        return this;
    }

    public BGUTableColumn setClassName(String className) {
        this.className = className;
        return this;
    }

    public BGUTableColumn setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public BGUTableColumn setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public BGUTableColumn setTableCellRenderer(BGUTableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
        return this;
    }

    public static BGUTableColumn buildColumnId() {
        return BGUTableColumn.builder().setTitle("ID").setWidth(80, 80, 80).setName("id").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.INTEGER).build();
    }

    public static BGUTableColumn buildColumnRadioLeft(String name) {
        return BGUTableColumn.buildColumnRadio(name, BGUTableCellRenderer.RADIO_LEFT);
    }

    public static BGUTableColumn buildColumnRadioCenter(String name) {
        return BGUTableColumn.buildColumnRadio(name, BGUTableCellRenderer.RADIO_CENTER);
    }

    public static BGUTableColumn buildColumnRadio(String name, BGUTableCellRenderer renderer) {
        return BGUTableColumn.builder().setTitle("V").setWidth(50, 50, 50).setName(name).setSortable(true).setTableCellRenderer(renderer).build();
    }

    public static BGUTableColumn buildColumnPeriod() {
        return BGUTableColumn.builder().setTitle("\u041f\u0435\u0440\u0438\u043e\u0434").setWidth(180, 180, 180).setName("period").setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER).build();
    }

    public static BGUTableColumn buildColumnTextLeft(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(100, 200, 300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_LEFT).build();
    }

    public static BGUTableColumn buildColumnTextCenter(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(100, 200, 300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER).build();
    }

    public static BGUTableColumn buildColumnTextRight(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(100, 200, 300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_RIGHT).build();
    }

    public static BGUTableColumn buildColumnComment() {
        return BGUTableColumn.builder().setTitle("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439").setWidth(100, 100, -1).setName("comment").setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_LEFT).build();
    }

    public static BGUTableColumn buildColumnDate(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(120, 120, 120).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE).build();
    }

    public static BGUTableColumn buildColumnDecimal(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(150, 150, 150).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DECIMAL).build();
    }

    public static BGUTableColumn buildColumnDateTime(String title, String name) {
        return BGUTableColumn.builder().setTitle(title).setWidth(180, 180, 180).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE_TIME).build();
    }

    public static BGUTableColumn buildColumnBoolean(String title, String name, int width) {
        return BGUTableColumn.builder().setTitle(title).setWidth(width, width, width).setName(name).setClassName(Boolean.TYPE.toString()).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.BOOLEAN).build();
    }

    public static BGUTableColumn buildColumnUserName() {
        return BGUTableColumn.builder().setTitle("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c").setWidth(150, 200, 300).setName("userName").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER).build();
    }

    public static BGUTableColumn buildColumnLastUpdate() {
        return BGUTableColumn.builder().setTitle("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u043f\u0440\u0430\u0432\u043a\u0438").setWidth(180, 180, 180).setName("lastUpdate").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE_TIME).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BGUTableColumn column = new BGUTableColumn();

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.column.title = title;
            return this;
        }

        public Builder setWidth(int minWidth, int prefWidth, int maxWidth) {
            this.column.minWidth = minWidth;
            this.column.prefWidth = prefWidth;
            this.column.maxWidth = maxWidth;
            return this;
        }

        public Builder setMinWidth(int minWidth) {
            this.column.minWidth = minWidth;
            return this;
        }

        public Builder setPrefWidth(int prefWidth) {
            this.column.prefWidth = prefWidth;
            return this;
        }

        public Builder setMaxWidth(int maxWidth) {
            this.column.maxWidth = maxWidth;
            return this;
        }

        public Builder setName(String name) {
            this.column.name = name;
            return this;
        }

        public Builder setClassName(String className) {
            this.column.className = className;
            return this;
        }

        public Builder setSortable(boolean sortable) {
            this.column.sortable = sortable;
            return this;
        }

        public Builder setEditable(boolean editable) {
            this.column.editable = editable;
            return this;
        }

        public Builder setTableCellRenderer(BGUTableCellRenderer tableCellRenderer) {
            this.column.tableCellRenderer = tableCellRenderer;
            return this;
        }

        public BGUTableColumn build() {
            try {
                BGUTableColumn bGUTableColumn = this.column;
                return bGUTableColumn;
            }
            finally {
                this.column = null;
            }
        }
    }
}

