/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.voiceip;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.voice.calc.ItemZoneCostCache;
import bitel.billing.server.tariff.voice.calc.ItemZoneTrafficCache;
import bitel.billing.server.tariff.voice.calc.ZoneDestFinder;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.server.CostMapCache;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.server.bean.VoiceTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSession;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceIpSessionRealtime
extends VoiceIpSession {
    private int maxSessionTime = 0;

    public void setMaxSessionTime(int maxSessionTime) {
        this.maxSessionTime = maxSessionTime;
    }

    public int getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public void createSession(Connection con) {
        String query = null;
        try {
            query = "INSERT INTO " + this.logSessionTableName + "( lid, nas_id, type, h323_id, session_start, session_time, dest_code, min_cost, session_cost, oper_id, oper_session_cost, sid, from_number, to_number, lr, cid, dc, round_session_time, oper_round_session_time, zone, fake_cost ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
            try (PreparedStatement ps = con.prepareStatement(query, 1);){
                int index = 1;
                ps.setInt(index++, this.getLogin().getId());
                ps.setInt(index++, this.getNasId());
                ps.setInt(index++, this.getCallType());
                ps.setString(index++, this.getH323ID());
                ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)this.getStartTime()));
                ps.setInt(index++, this.getSessionTime());
                ps.setInt(index++, this.getDestCode());
                ps.setFloat(index++, this.getMinuteCost());
                ps.setBigDecimal(index++, this.getSessionCost());
                ps.setInt(index++, this.getOperatorId());
                ps.setBigDecimal(index++, this.getOperSessionCost());
                ps.setInt(index++, this.getServiceId());
                ps.setString(index++, this.getFromNumber() != null ? this.getFromNumber() : "-");
                ps.setString(index++, this.getToNumber() != null ? this.getToNumber() : "-");
                ps.setInt(index++, this.getRequestLogRecordId());
                ps.setInt(index++, this.getContract().getId());
                ps.setString(index++, this.getDisconnectCause());
                ps.setInt(index++, this.getRoundSessionTime());
                ps.setInt(index++, this.getOperRoundSessionTime());
                ps.setInt(index++, this.getZoneCode());
                ps.setBigDecimal(index++, this.getFakeCost());
                ItemZoneTrafficCache itemZoneTrafficCache = this.getItemZoneTrafficCache();
                ItemZoneCostCache itemZoneCostCache = this.getItemZoneCostCache();
                ps.executeUpdate();
                itemZoneTrafficCache.addZoneTraffic(Integer.valueOf(this.login.getId()), Integer.valueOf(this.getZoneCode()), this.getRoundSessionTime(), this.getCallType());
                itemZoneCostCache.addZoneCost(Integer.valueOf(this.login.getId()), Integer.valueOf(this.getZoneCode()), this.getFakeCost(), this.getCallType());
                this.setLogRecordId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int checkRest(Connection con, int maxTime) {
        List treeList;
        int errorCode = 0;
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("VoiceIpSessionRealtime checkRest time => " + TimeUtils.format((Calendar)this.getStartTime(), (String)"HH:mm:ss") + "; phone => " + this.getOpponentStation() + "; serviceID => " + this.getServiceId() + "; callType => " + this.getCallType() + "; maxTime => " + maxTime);
        }
        if ((treeList = this.getContract().getTts().getTreeList(this.getStartTime().getTime())).size() > 0) {
            CostMapCache costMapCache;
            boolean priceFound = false;
            boolean destFound = true;
            ZoneDestFinder zdf = ZoneDestFinder.getZoneFinder((Connection)con, (int)this.mid);
            try {
                costMapCache = CostMapCache.getInstance((Connection)con, (int)this.mid);
            }
            catch (BGException ex) {
                costMapCache = null;
                this.logError(ex);
            }
            for (TariffModuleTree tree : treeList) {
                TariffRequest tariffRequest = this.initZonesRange(tree);
                tariffRequest.setRequestParam("time", (Object)this.getStartTime());
                tariffRequest.setRequestParam("phone", (Object)this.getOpponentStation());
                tariffRequest.setRequestParam("sid", (Object)this.getServiceId());
                tariffRequest.setRequestParam("call_type", (Object)this.getCallType());
                tariffRequest.setRequestParam("zdf", (Object)zdf);
                tariffRequest.setRequestParam("costMapCache", (Object)costMapCache);
                tree.processRequest(tariffRequest);
                Integer destCode = (Integer)tariffRequest.getResponseParam("dest");
                Float minCostParam = (Float)tariffRequest.getResponseParam("min_cost");
                BigDecimal minCost = minCostParam != null ? new BigDecimal(minCostParam.floatValue()).setScale(2, RoundingMode.HALF_UP) : null;
                VoiceTariffConfig config = (VoiceTariffConfig)tariffRequest.getResponseParam("config");
                Integer zone = (Integer)tariffRequest.getResponseParam("zone");
                if (tariffRequest.wasAccepted() && destCode != null && minCost != null) {
                    destFound = true;
                    this.setDestCode(destCode);
                    this.setMinuteCost(minCost.floatValue());
                    if (zone != null) {
                        this.setZoneCode(zone);
                    }
                    if (minCost != null && destCode != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.addLogDebug("destCode => " + destCode + "; minuteCost => " + minCost.toString());
                        }
                        Contract contract = this.getContract();
                        if (minCost.compareTo(BigDecimal.ZERO) < 0) {
                            minCost = BigDecimal.ZERO.setScale(2);
                        }
                        int time = 0;
                        BigDecimal tariff = minCost.divide(new BigDecimal(60), 5, RoundingMode.HALF_UP);
                        if (minCost.compareTo(BigDecimal.ZERO) < 1) {
                            time = maxTime;
                        } else {
                            BalanceUtils bu = new BalanceUtils(con);
                            BigDecimal summa = bu.getBalance(this.getStartTime().getTime(), contract.getId()).subtract(contract.getBalanceLimit(), MathContext.DECIMAL64);
                            if (this.getLogger().isDebugEnabled()) {
                                this.addLogDebug("balance => " + summa.toString());
                            }
                            if ((time = summa.divide(tariff, 0, RoundingMode.HALF_UP).intValue()) > maxTime) {
                                time = maxTime;
                            }
                            bu.close();
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            BigDecimal summa = tariff.multiply(new BigDecimal(time));
                            this.addLogDebug("time => " + time + "; summa => " + summa.toString());
                        }
                        if (config != null && config.isUseForAuth()) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.addLogDebug("Use config " + config.toString());
                            }
                            int quantum = config.getRoundQuantum(time);
                            time = time / quantum * quantum;
                            if (this.getLogger().isDebugEnabled()) {
                                this.addLogDebug("quantum=" + quantum + "; time after=" + time);
                            }
                        }
                        if (time == 0) {
                            errorCode = 15;
                        }
                        priceFound = true;
                        this.setMaxSessionTime(time);
                    }
                } else {
                    if (tariffRequest.wasAccepted() && minCost != null && destCode == null) {
                        destFound = false;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.addLogDebug(tariffRequest.toString());
                    }
                }
                if (tariffRequest.getResponseParam("prefix_deny") != null) {
                    priceFound = true;
                    errorCode = 32;
                }
                if (!priceFound) continue;
                break;
            }
            if (!priceFound) {
                errorCode = !destFound ? 40 : 11;
            }
        } else {
            errorCode = 3;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("errorCode => " + errorCode);
        }
        return errorCode;
    }

    public Set<Integer> getServices() {
        HashSet<Integer> result = new HashSet<Integer>();
        result.add(this.getServiceId());
        return result;
    }
}

