/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;

@Deprecated
public class SessionCountManager
extends BGLogger
implements Runnable {
    private final Access access;
    private final int batchSize;
    private Iterator<Map.Entry<Integer, List<InetConnectionRuntime>>> iterator;

    public SessionCountManager(Access access, int batchSize) {
        this.access = access;
        this.batchSize = batchSize;
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void runImpl() throws BGException {
        this.getLogger().debug("Run SessionCountManager...");
        InetConnectionManager connectionManager = this.access.connectionManager;
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = connectionManager.inetServEntrySet().iterator();
        }
        long millis = System.currentTimeMillis();
        EventProcessor ep = EventProcessor.getInstance();
        InetServRuntimeMap inetServRuntimeMap = this.access.inetServRuntimeMap;
        Set singlesignonRealmSet = this.access.singlesignonRealmSet;
        HashSet<String> killRealmSet = new HashSet<String>();
        int size = this.batchSize;
        for (int count = 0; count < size && this.iterator.hasNext(); ++count) {
            killRealmSet.clear();
            this.process(ep, inetServRuntimeMap, connectionManager, millis, singlesignonRealmSet, killRealmSet);
        }
    }

    private void process(EventProcessor ep, InetServRuntimeMap inetServRuntimeMap, InetConnectionManager connectionManager, long millis, Set<String> singlesignonRealmSet, Set<String> killRealmSet) throws BGException {
        Map.Entry<Integer, List<InetConnectionRuntime>> entry = this.iterator.next();
        Integer inetServId = entry.getKey();
        List<InetConnectionRuntime> connectionList = entry.getValue();
        InetServRuntime inetServRuntime = inetServRuntimeMap.get(inetServId);
        if (inetServRuntime == null) {
            this.getLogger().warn("inetServRuntime:" + inetServId + " is null");
            return;
        }
        if (inetServRuntime.getInetServ().getParentId() > 0 && InetUtils.getSessionCountLimit(inetServRuntime.inetServTypeRef.get().inetServType, inetServRuntime.getInetServ()) > 0) {
            return;
        }
        List<InetServRuntime> childrenInetServList = inetServRuntimeMap.listChildren(inetServRuntime.inetServId);
        connectionList = connectionManager.getAllConnections(connectionList, childrenInetServList, null);
        InetServ inetServ = inetServRuntime.getInetServ();
        InetServTypeRuntime inetServTypeRuntime = inetServRuntime.inetServTypeRef.get();
        int sessionCountLimit = InetUtils.getSessionCountLimit(inetServTypeRuntime.inetServType, inetServ);
        if (sessionCountLimit <= 0 && singlesignonRealmSet == null) {
            return;
        }
        int sessionCount = 0;
        for (int i = connectionList.size() - 1; i >= 0; --i) {
            String realm;
            InetConnectionRuntime connectionRuntime = connectionList.get(i);
            InetConnection connection = connectionRuntime.connection;
            if (connection.getType() != 0 || connection.getConnectionStatus() != 1 || connection.getDeviceState() != InetServState.STATE_ENABLE.getCode() || connection.getParentConnectionId() > 0L || (sessionCountLimit <= 0 || ++sessionCount <= sessionCountLimit) && (singlesignonRealmSet == null || !singlesignonRealmSet.contains(realm = InetUtils.getRealm(connection.getUsername())) || killRealmSet.add(realm)) || millis < connectionRuntime.nextCloseMillis) continue;
            this.log(connectionList);
            this.getLogger().info("Session count " + sessionCount + ">" + sessionCountLimit + ". Send connection state modify event.");
            ep.publish((Event)new InetSaStateModifyEvent(this.access.moduleId, 0, connection, InetServState.STATE_DISABLE.getCode(), AccessCode.TOO_MANY_SESSIONS_ERROR.getCode()));
            InetDeviceRuntime deviceRuntime = this.access.deviceMap.get(connection.getDeviceId());
            long delaySeconds = deviceRuntime != null ? deviceRuntime.connectionSuspendTimeout + 20L : 600L;
            connectionRuntime.nextCloseMillis = millis + TimeUnit.MILLISECONDS.convert(delaySeconds, TimeUnit.SECONDS);
        }
    }

    private void log(List<InetConnectionRuntime> connectionList) {
        for (InetConnectionRuntime connection : connectionList) {
            this.getLogger().info(connection.toString());
        }
    }
}

