/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.SourceSelector;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.Id;

public class IPNSnmpWorker
extends SnmpWorker {
    private SourceSelector ss;

    public IPNSnmpWorker(NetFlowSetup setup, SourceSelector ss, IPHourlyDataLogger dataLogger) {
        super((Setup)setup, setup.getModuleId(), dataLogger);
        this.ss = ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, List<Long>> getIfacesForSource() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            Map<Integer, List<Iface>> map = new IfaceManager(con, this.moduleId).getSourceIfacesMap();
            HashMap result = new HashMap(map.size());
            for (Map.Entry<Integer, List<Iface>> e : map.entrySet()) {
                ArrayList<Long> ifaces = new ArrayList<Long>(e.getValue().size());
                for (Iface iface : e.getValue()) {
                    if (iface.getNumber() == -1) continue;
                    ifaces.add(Long.valueOf(iface.getNumber()));
                }
                Collections.sort(ifaces);
                result.put(e.getKey(), ifaces);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    protected void runImpl0() {
        this.getLogger().debug("Start collecting data using SNMP...");
        Map<Integer, List<Long>> sourceIfaceMap = this.getIfacesForSource();
        for (Source source : this.ss.getSourceList()) {
            this.processSource((Id)source, source.getHostOrDir(), 161, source.getPswd(), (ParameterMap)new Preferences(source.getConfig(), "\r\n"), sourceIfaceMap.get(source.getId()));
        }
    }
}

