/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.PPPoERule;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.common.Utils;

public class PPPoEUtils {
    private static final Pattern getRealmFromConfPat = Pattern.compile("^\\s*realm=(\\w+)\\s*$", 8);
    private static final Pattern getAttributesFromConfPat = Pattern.compile("^\\s*attributes=(.+)\\s*$", 8);
    private static final Pattern patternCS = Pattern.compile(";");
    private static final Pattern patternC = Pattern.compile(",");
    private static final Pattern patternT = Pattern.compile("\t");
    private static final Pattern patternTT = Pattern.compile("\t\t");

    public static String getRealm(String ruleTypeConfig) {
        Matcher m = getRealmFromConfPat.matcher(ruleTypeConfig);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }

    public static String getAttributes(String ruleTypeConfig) {
        Matcher m = getAttributesFromConfPat.matcher(ruleTypeConfig);
        if (m.find()) {
            return m.group(1).trim();
        }
        return "";
    }

    public static PPPoELogin parseRule(String data) {
        ArrayList<PPPoERule> result = new ArrayList<PPPoERule>();
        String pswd = null;
        String login = null;
        if (data.trim().length() != 0) {
            String[] rules = patternTT.split(data);
            if (rules.length > 1) {
                String[] temp = patternT.split(rules[0]);
                login = temp[0];
                pswd = temp[1];
            }
            for (int i = 1; i < rules.length; ++i) {
                PPPoERule pRule = new PPPoERule();
                String[] ruleAttr = patternCS.split(rules[i]);
                pRule.setRuleTypeId(Utils.parseInt((String)ruleAttr[0]));
                pRule.setVrfId(Utils.parseInt((String)ruleAttr[1]));
                pRule.setIp(ruleAttr[2]);
                if (ruleAttr.length > 3) {
                    pRule.setNets(ruleAttr[3]);
                } else {
                    pRule.setNets("");
                }
                result.add(pRule);
            }
        }
        return new PPPoELogin(login, pswd, result);
    }

    public static String rulesToString(List<PPPoERule> ruleList) {
        StringBuilder result = new StringBuilder();
        for (PPPoERule rule : ruleList) {
            result.append(rule.getRuleTypeId());
            result.append(";");
            result.append(rule.getIp());
            result.append(";");
            result.append(rule.getNets());
            result.append("\t\t");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public static HashMap<Integer, String[]> getRuleTypes(Map<Integer, RuleType> ruleTypeMap) {
        HashMap<Integer, String[]> result = new HashMap<Integer, String[]>();
        for (RuleType ruleType : ruleTypeMap.values()) {
            String[] type = new String[]{PPPoEUtils.getRealm(ruleType.getData()), PPPoEUtils.getAttributes(ruleType.getData())};
            result.put(ruleType.getId(), type);
        }
        return result;
    }

    public static String generateRule(String nasId, GateType gateType, String data, HashMap<Integer, String[]> ruleTypes) {
        StringBuilder result = new StringBuilder(512);
        result.append("set ");
        if (data.trim().length() != 0) {
            String[] rules = patternTT.split(data);
            if (rules.length > 1) {
                result.append(nasId);
                result.append('\t');
                result.append(rules[0]);
            }
            for (int i = 1; i < rules.length; ++i) {
                String vrf;
                result.append("\t\t");
                String[] ruleAttr = patternCS.split(rules[i]);
                String[] ruleType = ruleTypes.get(Utils.parseInt((String)ruleAttr[0]));
                if (ruleType == null) continue;
                result.append(ruleType[0]);
                result.append('\t');
                result.append("Framed-IP-Address=");
                result.append(ruleAttr[2]);
                if (gateType.getConfigOption("framed.netmask") != null) {
                    result.append(";");
                    result.append("Framed-IP-Netmask=" + gateType.getConfigOption("framed.netmask"));
                }
                if (!Utils.isEmptyString((String)(vrf = ruleAttr[1])) && !vrf.equals("-1")) {
                    result.append(';');
                    result.append("cisco-avpair=lcp:interface-config=ip vrf forwarding " + gateType.getConfigOption("vrf." + vrf));
                }
                if (ruleAttr.length > 3) {
                    result.append(';');
                    for (String net : patternC.split(ruleAttr[3])) {
                        result.append("cisco-avpair=ip:route=");
                        result.append(net);
                        result.append(' ');
                        result.append(ruleAttr[2]);
                        result.append(';');
                    }
                }
                result.append(ruleType[1]);
            }
        }
        return result.toString();
    }

    public static class PPPoELogin {
        public final String login;
        public final String pswd;
        public final List<PPPoERule> ruleList;

        public PPPoELogin(String login, String pswd, List<PPPoERule> rules) {
            this.login = login;
            this.pswd = pswd;
            this.ruleList = rules;
        }
    }
}

