/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.OnContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.server.bean.BGGeneratorDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionWrapContract
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        java.util.Date dateOpen = this.getDateParameter("date");
        int patternId = this.getIntParameter("pattern_id", -1);
        boolean subName = this.getBooleanParameter("sub_name", false);
        if (this.cid <= 0 || dateOpen == null || patternId < 0) {
            throw new BGIllegalArgumentException();
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            java.util.Date dateClose;
            String error;
            Contract contract = (Contract)contractDao.get(this.cid);
            if (contract == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            if (contract.getDateTo() != null) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u0434\u0430\u0442\u043e\u0439");
            }
            Object contractName = "\u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d " + contract.getTitle();
            String namePattern = null;
            if (patternId > 0) {
                int namePatternId = Optional.ofNullable(new ContractPatternDao(this.con).getPattern(patternId)).map(a -> a.getNamePatternId()).orElse(0);
                if (namePatternId == 0) {
                    throw new BGMessageException("\u0428\u0430\u0431\u043b\u043e\u043d \u0441 \u043a\u043e\u0434\u043e\u043c " + patternId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
                namePattern = namePatternId > 0 ? ((BGGenerator)new BGGeneratorDao(this.con).get(namePatternId)).getPattern() : "";
                String nameFromPattern = new ContractPatternDao(this.con).getContractTitle(namePattern, dateOpen);
                if (Utils.notBlankString((String)nameFromPattern)) {
                    contractName = nameFromPattern;
                }
            }
            if (Utils.notBlankString((String)(error = this.checkContract(this.cid, dateOpen, dateClose = TimeUtils.getPrevDay((java.util.Date)dateOpen))))) {
                throw new BGException(error);
            }
            this.con.commit();
            List<Contract> subContracts = contractDao.getSubContracts(this.cid, -1);
            for (Object subContract : subContracts) {
                error = this.checkContract(subContract.getId(), dateOpen, dateClose);
                if (!Utils.notBlankString((String)error)) continue;
                throw new BGMessageException("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + subContract.getTitle() + " " + error);
            }
            int newCid = this.contractCopy(this.cid, (String)contractName, dateOpen, dateClose, contract.getSuperCid());
            if (contract.getSuperCid() > 0) {
                contractDao.updateSuperContractDependSubList(contract.getSuperCid());
            } else {
                for (Contract subContract : subContracts) {
                    String nameFromPattern;
                    if (subContract.getDateTo() != null) continue;
                    Object subContractName = "\u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d " + subContract.getTitle();
                    if (subName && namePattern != null && Utils.notBlankString((String)(nameFromPattern = new ContractPatternDao(this.con).getContractTitle(namePattern, dateOpen)))) {
                        subContractName = nameFromPattern;
                    }
                    java.util.Date curDateOpen = TimeUtils.dateBefore((java.util.Date)dateOpen, (java.util.Date)subContract.getDateFrom()) ? subContract.getDateFrom() : dateOpen;
                    java.util.Date curDateClose = TimeUtils.dateBefore((java.util.Date)dateClose, (java.util.Date)subContract.getDateFrom()) ? subContract.getDateFrom() : dateClose;
                    int newSubCid = this.contractCopy(subContract.getId(), (String)subContractName, curDateOpen, curDateClose, newCid);
                    OnContractWrapEvent event = new OnContractWrapEvent(subContract.getId(), newSubCid, curDateOpen);
                    EventProcessor.getInstance().request(event);
                    HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
                    TableCopier copier = new TableCopier(this.con);
                    ContractWrapEvent wrapEvent = new ContractWrapEvent(this.userId, subContract.getId(), newSubCid, curDateClose, curDateOpen, false);
                    valuesPairs.put("cid", new ColumnValue(true, newSubCid));
                    this.simpleTableCopy(copier, "contract_script", wrapEvent, null, "cid=" + subContract.getId(), valuesPairs, true);
                }
                contractDao.updateSuperContractDependSubList(newCid);
            }
            OnContractWrapEvent event = new OnContractWrapEvent(this.cid, newCid, dateOpen);
            EventProcessor.getInstance().request(event);
            HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
            TableCopier copier = new TableCopier(this.con);
            ContractWrapEvent wrapEvent = new ContractWrapEvent(this.userId, this.cid, newCid, dateClose, dateOpen, false);
            valuesPairs.put("cid", new ColumnValue(true, newCid));
            this.simpleTableCopy(copier, "contract_script", wrapEvent, null, "cid=" + this.cid, valuesPairs, true);
            Element contractEl = this.createElement(this.rootNode, "contract");
            contractEl.setAttribute("id", String.valueOf(newCid));
        }
    }

    private int contractCopy(int contractId, String contractName, java.util.Date dateOpen, java.util.Date dateClose, int scid) throws Exception {
        TableCopier copier = new TableCopier(this.con);
        String where = null;
        HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
        String date2Filter = " AND (date2 IS NULL OR date2>'" + TimeUtils.formatSQLDate((java.util.Date)dateClose) + "')";
        valuesPairs.put("date1", new ColumnValue(true, dateOpen));
        valuesPairs.put("date2", new ColumnValue(false, "NULL"));
        valuesPairs.put("title", new ColumnValue(true, contractName));
        valuesPairs.put("scid", new ColumnValue(true, scid));
        valuesPairs.put("sub_list", new ColumnValue(false, "''"));
        int newCid = copier.copyRecord("contract", "id=" + contractId, valuesPairs);
        copier.updateColumn("contract", "date2", TimeUtils.formatSQLDate((java.util.Date)dateClose), " id=" + contractId);
        where = "cid=" + contractId;
        valuesPairs.clear();
        valuesPairs.put("cid", new ColumnValue(true, newCid));
        copier.copyRecord("contract_module", where, valuesPairs);
        ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);
        contractParameterManager.copyContractParams(where, valuesPairs);
        where = "cid=" + contractId + date2Filter;
        valuesPairs.clear();
        valuesPairs.put("date1", new ColumnValue(true, dateOpen));
        valuesPairs.put("cid", new ColumnValue(true, newCid));
        ContractWrapEvent wrapEvent = new ContractWrapEvent(this.userId, contractId, newCid, dateClose, dateOpen, false);
        this.simpleTableWrap(copier, "contract_service", wrapEvent, null);
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
        for (ContractTariff contractTariff : contractTariffDao.list(contractId)) {
            Optional<java.util.Date> optional = Optional.ofNullable(contractTariff.getPeriod()).map(a -> a.getDateFrom());
            Optional<java.util.Date> dateTo = Optional.ofNullable(contractTariff.getPeriod()).map(a -> a.getDateTo());
            if (dateTo.filter(a -> a.before(dateClose)).isPresent()) continue;
            if (optional.filter(a -> dateClose.before((java.util.Date)a)).isPresent()) {
                contractTariffDao.moveContractTariff(contractTariff.getId(), newCid);
                contractTariffDao.clearContractTariffReplacedFromId(contractTariff.getId());
                continue;
            }
            ContractTariff newContractTariff = ContractTariff.from(contractTariff);
            contractTariff.getPeriod().setDateFrom(dateClose);
            contractTariffDao.update(contractTariff);
            newContractTariff.getPeriod().setDateFrom(TimeUtils.getNextDay((java.util.Date)dateClose));
            newContractTariff.setReplacedFromContractTariffId(0);
            contractTariffDao.update(contractTariff);
        }
        this.simpleTableWrap(copier, "contract_tariff_group", wrapEvent, null);
        this.simpleTableWrap(copier, "contract_status", wrapEvent, null);
        HashMap<Integer, Integer> treeIdMap = new HashMap<Integer, Integer>();
        this.personalTariffCopy(copier, wrapEvent, treeIdMap);
        for (Map.Entry entry : treeIdMap.entrySet()) {
            HashMap<Integer, Integer> mtreeIdMap = new HashMap<Integer, Integer>();
            Integer oldTreeId = (Integer)entry.getKey();
            Integer newTreeId = (Integer)entry.getValue();
            Map<String, ColumnValue> singletonMap = Collections.singletonMap("tree_id", new ColumnValue(true, newTreeId));
            this.simpleTableCopy(copier, "module_tariff_tree", wrapEvent, mtreeIdMap, "tree_id=" + oldTreeId, singletonMap, false);
            for (Map.Entry<Integer, Integer> entry2 : mtreeIdMap.entrySet()) {
                this.personalModuleTariffCopy(copier, wrapEvent, entry2);
            }
        }
        this.simpleTableWrap(copier, "object", wrapEvent, wrapEvent.getObjectMap());
        for (Map.Entry<Object, Object> entry : wrapEvent.getObjectMap().entrySet()) {
            int objectId = (Integer)entry.getKey();
            int newObjectId = (Integer)entry.getValue();
            where = "object_id=" + objectId;
            HashMap<String, ColumnValue> valuesPairsObjectCopy = new HashMap<String, ColumnValue>();
            valuesPairsObjectCopy.put("object_id", new ColumnValue(true, newObjectId));
            copier.copyRecord("object_param_value_address", where, valuesPairsObjectCopy);
            copier.copyRecord("object_param_value_date", where, valuesPairsObjectCopy);
            copier.copyRecord("object_param_value_list", where, valuesPairsObjectCopy);
            copier.copyRecord("object_param_value_text", where, valuesPairsObjectCopy);
        }
        valuesPairs.clear();
        valuesPairs.put("contract_id", new ColumnValue(true, newCid));
        copier.copyRecord("contract_label_link", "contract_id=" + contractId, valuesPairs);
        EventProcessor.getInstance().request(wrapEvent);
        return newCid;
    }

    private void simpleTableWrap(TableCopier copier, String tableName, ContractWrapEvent wrapEvent, Map<Integer, Integer> idMap) throws SQLException {
        this.simpleTableWrap(copier, tableName, wrapEvent, idMap, true);
    }

    private void simpleTableWrap(TableCopier copier, String tableName, ContractWrapEvent wrapEvent, Map<Integer, Integer> idMap, boolean closePeriod) throws SQLException {
        HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
        valuesPairs.put("date1", new ColumnValue(true, wrapEvent.getDateOpen()));
        valuesPairs.put("cid", new ColumnValue(true, wrapEvent.getToContractId()));
        String query = "SELECT id, date1, date2 FROM " + tableName + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, wrapEvent.getContractId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt(1);
                    Date date1 = rs.getDate(2);
                    Date date2 = rs.getDate(3);
                    if (date1 != null && TimeUtils.dateBefore((java.util.Date)wrapEvent.getDateClose(), (java.util.Date)date1)) {
                        copier.updateColumn(tableName, "cid", String.valueOf(wrapEvent.getToContractId()), "id=" + id);
                        continue;
                    }
                    if (!wrapEvent.checkNeedWrap(date2)) continue;
                    int newId = copier.copyRecord(tableName, "id=" + id, valuesPairs);
                    if (idMap != null) {
                        idMap.put(id, newId);
                    }
                    if (!closePeriod) continue;
                    copier.updateColumn(tableName, "date2", TimeUtils.formatSQLDate((java.util.Date)wrapEvent.getDateClose()), "id=" + id);
                }
            }
        }
    }

    private void simpleTableCopy(TableCopier copier, String tableName, ContractWrapEvent wrapEvent, Map<Integer, Integer> idMap, String where, Map<String, ColumnValue> valuesPairs, boolean closePeriod) throws SQLException {
        String query = "SELECT id FROM " + tableName + " WHERE " + where;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                int id = rs.getInt(1);
                int newId = copier.copyRecord(tableName, "id=" + id, valuesPairs);
                if (idMap != null) {
                    idMap.put(id, newId);
                }
                if (!closePeriod) continue;
                copier.updateColumn(tableName, "date2", TimeUtils.formatSQLDate((java.util.Date)wrapEvent.getDateClose()), "id=" + id);
            }
        }
    }

    private void copyTariffTreeNodes(TableCopier copier, String tableName, int mtree_id, Map<String, ColumnValue> valuesPairs) throws SQLException {
        String query = "SELECT id, parent_node FROM " + tableName + " WHERE mtree_id=" + String.valueOf(mtree_id) + " ORDER BY parent_node, id";
        PreparedStatement ps = this.con.prepareStatement(query);
        String queryParent = "select parent_node, mtree_id from " + tableName + " where id=?";
        PreparedStatement psSelectParent = this.con.prepareStatement(queryParent);
        HashMap<Integer, Integer> idMap = new HashMap<Integer, Integer>();
        try (ResultSet rs = ps.executeQuery(query);){
            while (rs.next()) {
                int id = rs.getInt(1);
                int parentNode = rs.getInt(2);
                if (idMap.get(id) != null) continue;
                this.copyTariffTreeNode(id, parentNode, mtree_id, idMap, copier, tableName, valuesPairs, psSelectParent);
            }
        }
        psSelectParent.close();
        ps.close();
    }

    private void personalTariffCopy(TableCopier copier, ContractWrapEvent wrapEvent, Map<Integer, Integer> idMap) throws Exception {
        HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
        valuesPairs.put("date1", new ColumnValue(true, wrapEvent.getDateOpen()));
        valuesPairs.put("cid", new ColumnValue(true, wrapEvent.getToContractId()));
        String query = "SELECT id, date1, date2, tree_id FROM contract_tree_link WHERE cid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, wrapEvent.getContractId());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            Date date1 = rs.getDate(2);
            Date date2 = rs.getDate(3);
            if (date1 != null && TimeUtils.dateBefore((java.util.Date)wrapEvent.getDateClose(), (java.util.Date)date1)) {
                copier.updateColumn("contract_tree_link", "cid", String.valueOf(wrapEvent.getToContractId()), "id=" + id);
                continue;
            }
            if (!wrapEvent.checkNeedWrap(date2)) continue;
            int treeId = new TariffTreeBuilder(this.con).createTree();
            valuesPairs.put("tree_id", new ColumnValue(true, treeId));
            copier.copyRecord("contract_tree_link", "id=" + id, valuesPairs);
            if (idMap == null) continue;
            idMap.put(rs.getInt(4), treeId);
        }
        rs.close();
        ps.close();
    }

    private void personalModuleTariffCopy(TableCopier copier, ContractWrapEvent wrapEvent, Map.Entry<Integer, Integer> moduleTreeIdEntry) throws SQLException {
        HashMap<String, ColumnValue> values = new HashMap<String, ColumnValue>();
        values.put("mtree_id", new ColumnValue(true, moduleTreeIdEntry.getValue()));
        this.copyTariffTreeNodes(copier, "mtree_node", moduleTreeIdEntry.getKey(), values);
    }

    private String checkContract(int contractId, java.util.Date dateOpen, java.util.Date dateClose) throws BGException {
        ContractWrapEvent checkEvent = new ContractWrapEvent(this.userId, contractId, 0, dateClose, dateOpen, true);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        return checkEvent.getError();
    }

    private int copyTariffTreeNode(int id, int parent_node, int mtree_id, Map<Integer, Integer> idMap, TableCopier copier, String tableName, Map<String, ColumnValue> valuesPairs, PreparedStatement psSelectParent) throws SQLException {
        HashMap<String, ColumnValue> localValuesPairs = new HashMap<String, ColumnValue>();
        localValuesPairs.put("mtree_id", valuesPairs.get("mtree_id"));
        if (0 != parent_node) {
            Integer newParentNode = idMap.get(parent_node);
            if (null == newParentNode) {
                psSelectParent.setInt(1, parent_node);
                try (ResultSet rs = psSelectParent.executeQuery();){
                    if (rs.next()) {
                        int parent_parent_node = rs.getInt(1);
                        int parent_mtree_id = rs.getInt(2);
                        if (parent_mtree_id == mtree_id) {
                            newParentNode = this.copyTariffTreeNode(parent_node, parent_parent_node, mtree_id, idMap, copier, tableName, valuesPairs, psSelectParent);
                        }
                    }
                }
            }
            if (null != newParentNode) {
                localValuesPairs.put("parent_node", new ColumnValue(true, newParentNode));
            }
        }
        int newId = copier.copyRecord(tableName, "id=" + id, localValuesPairs);
        idMap.put(id, newId);
        return newId;
    }
}

