/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.WebActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionGetPackage
extends WebActionBase {
    private SearchResult<PackageContract> searchResult = null;
    private SearchResult<Package> searchResult1 = null;

    public void doAction() throws Exception {
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        this.searchResult = new SearchResult();
        this.searchResult.setPage(this.getPage());
        packageManager.findPackageContractList(this.searchResult, this.cid);
        this.searchResult1 = new SearchResult();
        this.searchResult1.setPage(new Page(1, 0));
        packageManager.findPackageList(this.searchResult1, Boolean.TRUE);
        this.setData();
    }

    protected void setDataForXslt() throws BGException {
        Element packageElement = this.createElement(this.rootNode, "packages");
        Element tableElement = this.createElement(packageElement, "tablePackageContract");
        for (PackageContract pkg : this.searchResult.getList()) {
            Element row = this.createElement(tableElement, "row");
            row.setAttribute("id", String.valueOf(pkg.getId()));
            row.setAttribute("active", String.valueOf(pkg.isActivePackage(null)));
            row.setAttribute("period", TimeUtils.formatPeriod((Date)pkg.getDateFrom(), (Date)pkg.getDateTo()));
            row.setAttribute("summa", pkg.getSumma().toPlainString());
            row.setAttribute("count", String.valueOf(pkg.getCount()) + " [" + String.valueOf(pkg.getCountUse()) + "]");
            row.setAttribute("user", String.valueOf(pkg.getUserId() > 0));
        }
        tableElement = this.createElement(packageElement, "tablePackage");
        for (PackageContract pkg : this.searchResult1.getList()) {
            GregorianCalendar now = new GregorianCalendar();
            StringBuilder period = new StringBuilder();
            Element row = this.createElement(tableElement, "row");
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            period.append("-");
            ((Calendar)now).add(5, pkg.getPeriod());
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            row.setAttribute("id", String.valueOf(pkg.getId()));
            row.setAttribute("title", String.valueOf(pkg.getTitle()));
            row.setAttribute("formatPeriod", period.toString());
            row.setAttribute("period", String.valueOf(pkg.getPeriod()));
            row.setAttribute("summa", pkg.getSumma().toPlainString());
            row.setAttribute("count", String.valueOf(pkg.getCount()));
        }
    }

    protected void setDataToRequest() throws BGException {
        HashMap<Integer, Boolean> activePackageMap = new HashMap<Integer, Boolean>();
        for (PackageContract pkg : this.searchResult.getList()) {
            activePackageMap.put(pkg.getId(), pkg.isActivePackage(null));
        }
        this.dataMap.put("activePackageMap", activePackageMap);
        this.dataMap.put("contractPackageList", this.searchResult.getList());
        HashMap<Integer, String> periodPackageMap = new HashMap<Integer, String>();
        for (Package pkg : this.searchResult1.getList()) {
            GregorianCalendar now = new GregorianCalendar();
            StringBuilder period = new StringBuilder();
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            period.append("-");
            ((Calendar)now).add(5, pkg.getPeriod());
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            periodPackageMap.put(pkg.getId(), period.toString());
        }
        this.dataMap.put("periodPackageMap", periodPackageMap);
        this.dataMap.put("packageList", this.searchResult1.getList());
    }
}

