/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class EntityTariffsPropertiesPanel
extends ServicePanel {
    private Boolean edit = null;
    private ContractTariffTableModel tariffTableModel = new ContractTariffTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tariffTableModel));
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> serviceCombo = new BGComboBox();
    private BGControlPanelPeriodNoB servicePeriod = new BGControlPanelPeriodNoB();
    private IntTextField colTf = new IntTextField();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private Set<String> deleted = new HashSet<String>();
    private JCheckBox showUsedOnlyFlag = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
    private JCheckBox useFilterFlag = new JCheckBox("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
    private List<IdTitle> tariffItems = new ArrayList<IdTitle>();

    public EntityTariffsPropertiesPanel() {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        EntityTariffsPropertiesPanel thiz = this;
        this.toolBar.setDefaultButtons(e -> thiz.actionPerformed(e));
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.showUsedOnlyFlag.setSelected(true);
        this.useFilterFlag.setSelected(true);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.add((Component)this.showUsedOnlyFlag, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.useFilterFlag, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        ActionListener al = e -> this.getPlans();
        this.showUsedOnlyFlag.addActionListener(al);
        this.useFilterFlag.addActionListener(al);
        this.editor.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.add((Component)checkBoxPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.serviceCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u041f\u043e\u0437.:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.colTf, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.servicePeriod, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && EntityTariffsPropertiesPanel.this.tariffTableModel.getSelectedRow() != null) {
                    EntityTariffsPropertiesPanel.this.edit = true;
                    EntityTariffsPropertiesPanel.this.startEdit();
                }
            }
        });
        this.colTf.setMinValue(1L);
        this.colTf.setMaxValue(1000L);
    }

    public void setData() {
        try {
            this.tariffItems = ((TariffService)this.getContext().getWebService(TariffService.class)).tariffPlanTitles();
            List contractTariffs = ((ContractTariffService)this.getContext().getWebService(ContractTariffService.class, 0)).contractTariffList(this.getContractId(), null, this.getModuleId(), Utils.parseInt((String)this.id));
            this.tariffTableModel.setData(contractTariffs);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        ContractTariff contractTariff = (ContractTariff)this.tariffTableModel.getSelectedRow();
        if (contractTariff != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            if (contractTariff.getId() > 0) {
                this.deleted.add(String.valueOf(contractTariff.getId()));
            }
            for (int index = 0; index < this.tariffTableModel.getRows().size(); ++index) {
                ContractTariff a = (ContractTariff)this.tariffTableModel.getRows().get(index);
                if (a != contractTariff) continue;
                this.tariffTableModel.getRows().remove(index);
                this.tariffTableModel.fireTableDataChanged();
                break;
            }
            this.editor.setVisible(false);
        }
    }

    public void editItem() {
        ContractTariff contractTariff = (ContractTariff)this.tariffTableModel.getSelectedRow();
        if (contractTariff != null) {
            this.edit = true;
            this.startEdit();
        }
    }

    public void newItem() {
        this.edit = false;
        this.startEdit();
    }

    private void getPlans() {
        Request req = new Request().setModule("contract").setAction("ContractTariffPlan").setAttribute("id", (Object)this.tariffTableModel.optSelectedRow().map(a -> a.getId()).orElse(0)).setAttribute("showUsed", this.showUsedOnlyFlag.isSelected() ? 1 : 0).setAttribute("useFilter", this.useFilterFlag.isSelected() ? 1 : 0).setContractId(this.getContractId()).setAttribute("mid", this.getModuleId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                ClientUtils.buildComboBox(this.serviceCombo, (Node)XMLUtils.selectElement((Node)doc, (String)"//tariffPlans"), (String)"");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void startEdit() {
        this.getPlans();
        this.serviceCombo.setEnabled(this.edit == false);
        if (!this.edit.booleanValue()) {
            if (this.serviceCombo.getItemCount() > 0) {
                this.serviceCombo.setSelectedIndex(0);
            }
            this.servicePeriod.setLocalDateFrom(LocalDate.now());
            this.colTf.setText("0");
        } else {
            ContractTariff contractTariff = (ContractTariff)this.tariffTableModel.getSelectedRow();
            this.colTf.setText(String.valueOf(contractTariff.getPosition()));
            this.servicePeriod.setLocalDateFrom(contractTariff.getPeriod().getLocalDateFrom());
            this.servicePeriod.setLocalDateTo(contractTariff.getPeriod().getLocalDateTo());
            ClientUtils.setComboBoxSelection(this.serviceCombo, (Object)String.valueOf(contractTariff.getTariffPlanId()));
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            ComboBoxItem item = (ComboBoxItem)this.serviceCombo.getSelectedItem();
            if (item == null || ((String)item.getObject()).equals("0")) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444");
                return;
            }
            String pos = this.colTf.getText();
            if (Utils.isBlankString((String)pos)) {
                pos = "0";
            }
            ContractTariff contractTariff = (ContractTariff)this.tariffTableModel.getSelectedRow();
            if (!this.edit.booleanValue()) {
                contractTariff = new ContractTariff();
                contractTariff.setContractId(this.getContractId());
                contractTariff.setEntityModuleId(this.getModuleId());
                contractTariff.setEntityId(Utils.parseInt((String)this.id));
                this.tariffTableModel.addRow(contractTariff);
            }
            contractTariff.setTariffPlanId(Utils.parseInt((String)item.getObject().toString()));
            contractTariff.setPosition(Utils.parseInt((String)pos));
            contractTariff.setPeriod(this.servicePeriod.getPeriod());
            this.tariffTableModel.fireTableDataChanged();
            this.editor.setVisible(false);
        } else {
            this.editor.setVisible(false);
        }
        this.edit = null;
    }

    public boolean updateData() {
        for (String id : this.deleted) {
            try {
                ((ContractTariffService)this.getContext().getWebService(ContractTariffService.class, 0)).contractTariffDelete(Utils.parseInt((String)id));
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.deleted.clear();
        for (ContractTariff contractTariff : this.tariffTableModel.getRows()) {
            try {
                ((ContractTariffService)this.getContext().getWebService(ContractTariffService.class, 0)).contractTariffUpdate(contractTariff);
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return true;
    }

    class ContractTariffTableModel
    extends BGTableModel<ContractTariff> {
        public ContractTariffTableModel() {
            super(ContractTariffTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437.", 50, 50, 50, "position", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", 180, 180, 180, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(ContractTariff val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                return EntityTariffsPropertiesPanel.this.tariffItems.stream().filter(a -> a.getId() == val.getTariffPlanId()).findFirst().map(a -> a.getTitle()).orElse("??? [ID#" + val.getTariffPlanId() + "]");
            }
            return super.getValueAt((Object)val, column);
        }
    }
}

