/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessToken;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class EnazaAccessTokenDao
extends AbstractDao<EnazaAccessToken> {
    public EnazaAccessTokenDao(Connection con, int moduleId) {
        super(con, moduleId, "enaza_access_token");
    }

    public EnazaAccessToken getEnazaAccessTokenByAccessToken(String accessToken) throws SQLException {
        return (EnazaAccessToken)((Object)this.get("access_token=?", new Object[]{accessToken}));
    }

    public EnazaAccessToken getEnazaAccessTokenByCode(String code) throws SQLException {
        return (EnazaAccessToken)((Object)this.get("code=? AND code_expire>now()", new Object[]{code}));
    }

    public EnazaAccessToken getEnazaAccessTokenByContractId(int contractId) throws SQLException {
        return (EnazaAccessToken)((Object)this.get("contract_id=?", new Object[]{contractId}));
    }

    protected EnazaAccessToken getFromRS(ResultSet rs) throws SQLException {
        EnazaAccessToken enazaAccessToken = new EnazaAccessToken();
        enazaAccessToken.setId(rs.getInt("id"));
        enazaAccessToken.setContractId(rs.getInt("contract_id"));
        enazaAccessToken.setCode(rs.getString("code"));
        enazaAccessToken.setCodeExpire(rs.getTimestamp("code_expire"));
        enazaAccessToken.setAccessToken(rs.getString("access_token"));
        enazaAccessToken.setAccessTokenCreate(rs.getTimestamp("access_token_create"));
        return enazaAccessToken;
    }

    protected void updateImpl(EnazaAccessToken enazaAccessToken) throws SQLException {
        Objects.requireNonNull(enazaAccessToken);
        boolean update = enazaAccessToken.getId() > 0;
        String querySet = " SET contract_id=?, code=?, code_expire=?, access_token=?, access_token_create=?";
        StringBuilder query = new StringBuilder(update ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(querySet).append(update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int index = 1;
            ps.setInt(index++, enazaAccessToken.getContractId());
            ps.setString(index++, enazaAccessToken.getCode());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)enazaAccessToken.getCodeExpire()));
            ps.setString(index++, enazaAccessToken.getAccessToken());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)enazaAccessToken.getAccessTokenCreate()));
            if (update) {
                ps.setInt(index++, enazaAccessToken.getId());
            }
            ps.executeUpdate();
            if (!update) {
                enazaAccessToken.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

