/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.radius.Antispam;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandler;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.network.ip.IpAddressSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.card.common.event.CardActivateRequestEvent;
import ru.bitel.bgbilling.modules.card.common.event.CardGetRequestEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServOptionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpData;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandler;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandlerOldMode;
import ru.bitel.bgbilling.modules.inet.server.radius.AuthSessionKey;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasList;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusSessionParams;
import ru.bitel.bgbilling.modules.inet.server.radius.IpResourceEntry;
import ru.bitel.bgbilling.modules.inet.server.radius.RadiusAccessRequestEvent;
import ru.bitel.bgbilling.modules.inet.server.radius.RadiusAccessRequestHandler;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.ThreadContext;

public class InetRadiusProcessor
extends RadiusProcessor<InetNasConnection, InetNas, InetRadiusSessionParams>
implements EventListener<InetAccountingEvent>,
ExtendedLifecycle,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    public static final String REALM_DEFAULT = "default";
    public static final String REALM_DISABLE = "disable";
    public static final RadiusPacket.RadiusPacketOption<Short> DEVICE_STATE = new RadiusPacket.RadiusPacketOption("deviceState");
    public static final RadiusPacket.RadiusPacketOption<String> PARENT_ACCT_SESSION_ID = new RadiusPacket.RadiusPacketOption("parentAcctSessionId");
    public static final RadiusPacket.RadiusPacketOption<String> SERVICE_NAME = new RadiusPacket.RadiusPacketOption("serviceName");
    public static final RadiusPacket.RadiusPacketOption<String> IDENTIFIER = new RadiusPacket.RadiusPacketOption("identifier");
    public static final RadiusPacket.RadiusPacketOption<String> MAC_ADDRESS = new RadiusPacket.RadiusPacketOption("macAddress");
    public static final RadiusPacket.RadiusPacketOption<byte[]> MAC_ADDRESS_BYTES = new RadiusPacket.RadiusPacketOption("macAddressBytes");
    public static final RadiusPacket.RadiusPacketOption<Integer> ACCESS_CODE = new RadiusPacket.RadiusPacketOption("accessCode");
    public static final RadiusPacket.RadiusPacketOption<Object> AGENT_REMOTE_ID = new RadiusPacket.RadiusPacketOption("agentRemoteId");
    public static final RadiusPacket.RadiusPacketOption<Object> AGENT_CIRCUIT_ID = new RadiusPacket.RadiusPacketOption("agentCircuitId");
    public static final RadiusPacket.RadiusPacketOption<Object> VLAN_ID = new RadiusPacket.RadiusPacketOption("vlanId");
    public static final RadiusPacket.RadiusPacketOption<Object> INTERFACE_ID = new RadiusPacket.RadiusPacketOption("interfaceId");
    public static final RadiusPacket.RadiusPacketOption<Object> AGENT_SVLAN = new RadiusPacket.RadiusPacketOption("agentSvlan");
    protected final Access access;
    protected final Accounting accounting;
    protected final int applicationId;
    private final TimeoutMap<AuthSessionKey, Integer> processedNasIdMap = new TimeoutMap("prcssdAgntDvcIdMap-worker");
    private static final Pattern patternRouteNet1 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+");
    private static final Pattern patternRouteNet2 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*/\\s*(\\d+)");

    protected final int getModuleId() {
        return this.moduleId;
    }

    @ConstructorProperties(value={"setup", "access", "accounting"})
    public InetRadiusProcessor(Setup setup, Access access, Accounting accounting) throws BGException {
        super(setup, "inet", SetupParam.getModuleId((ParameterMap)setup), (NasList)new InetNasList(access, accounting), false, false);
        this.applicationId = access != null ? access.applicationId : accounting.applicationId;
        RadiusUtils.logEnable = false;
        ConnectionLogEntry.coordEnable = true;
        this.access = access;
        this.accounting = accounting;
    }

    public void init() throws Exception {
        try {
            if (!this.nasList.nases().iterator().hasNext()) {
                this.reloadNasList();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        EventProcessor.getInstance().addListener((EventListener)new EventListener<Event>(){

            public void notify(Event e, EventListenerContext ctx) throws BGException {
                InetRadiusProcessor.this.reloadNasList();
                InetRadiusProcessor.this.afterNasListReload();
            }
        }, InetReloadLocalEvent.class, this.moduleId, null);
    }

    public void start() throws Exception {
        if (this.accounting != null) {
            EventProcessor.getInstance().addListener((EventListener)this, InetAccountingEvent.class, this.moduleId, null);
        }
    }

    public void stop() throws Exception {
        this.processedNasIdMap.shutdown();
    }

    public void destroy() throws Exception {
    }

    protected void reloadConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadNasList() {
        BGNestedContext.push((String)"radius-processor");
        try {
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
            if (moduleSetup != null) {
                this.forwardAfterPreprocess = moduleSetup.getBoolean("radius.forward.after.preprocess", this.setup.getBoolean("radius.forward.after.preprocess", false));
                this.forwardAfterProcess = moduleSetup.getBoolean("radius.forward.after.process", this.setup.getBoolean("radius.forward.after.process", false));
            } else {
                this.forwardAfterPreprocess = this.setup.getBoolean("radius.forward.after.preprocess", false);
                this.forwardAfterProcess = this.setup.getBoolean("radius.forward.after.process", false);
            }
            ServerContext context = new ServerContext(this.setup, this.moduleId, 0);
            ThreadContext parentContext = ThreadContext.push((ThreadContext)context);
            try {
                logger.info("Reloading NAS list");
                this.nasList.load((DefaultServerSetup)this.setup, (RadiusProcessor)this, context.getConnection(), this.moduleId);
                context.commit();
            }
            catch (BGException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            }
        }
        finally {
            BGNestedContext.pop();
        }
    }

    protected RadiusSession<InetNas, InetRadiusSessionParams> newRadiusSession(Connection con, InetNas nas, RadiusPacket request, RadiusSession.State state) {
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        if (userNameAttribute == null) {
            userNameAttribute = new RadiusAttribute.RadiusAttributeString(-1, 1, "");
            request.setAttribute((RadiusAttribute)userNameAttribute);
            logger.warn("Attribute User-Name not found!");
        }
        String username = (String)userNameAttribute.getValue();
        String[] usernameAndRealm = nas.getUsernameAndRealm(username);
        username = usernameAndRealm[0];
        String realm = usernameAndRealm[1];
        String enteredRealm = usernameAndRealm[2];
        userNameAttribute = userNameAttribute.clone();
        if (request.getAttribute(-1, 79) != null) {
            return new EAPSession(username, userNameAttribute, (Object)new InetRadiusSessionParams(realm, enteredRealm));
        }
        return new RadiusSession(state != null ? state.state : null, username, userNameAttribute, (Object)new InetRadiusSessionParams(realm, enteredRealm));
    }

    protected void preprocessAccessRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        if (nas.getProtocolHandler() != null) {
            try {
                nas.getProtocolHandler().preprocessAccessRequest(request, response, connectionSet);
                logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void preprocessAccountingRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        if (nas.getProtocolHandler() != null) {
            try {
                nas.getProtocolHandler().preprocessAccountingRequest(request, response, connectionSet);
                logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void accessRequestImpl(RadiusListenerWorker<InetNas> req, InetNas nas, RadiusPacket request, RadiusPacket response, Date date, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, int logRecordId, ConnectionSet connectionSet) {
        super.accessRequestImpl(req, (Nas)nas, request, response, date, radiusSession, logRecordId, connectionSet);
        byte result = response.getCode();
        if (result == 2 || result == 3) {
            if (logger.isDebugEnabled()) {
                logger.debug("radiusSession.login = {}", radiusSession.login);
            }
            if (radiusSession.login != null) {
                RadiusAccessRequestHandler accessRequestHandler = nas.getAccessRequestHandler();
                if (accessRequestHandler != null) {
                    try {
                        accessRequestHandler.afterAuthorization(req.getConext(), req, radiusSession, request, response);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    RadiusAccessRequestEvent event = new RadiusAccessRequestEvent(this.access.moduleId, nas, req.getAgentDeviceId(), radiusSession, request, response, req.getIpAddressSet().getResourceId());
                    if (logger.isDebugEnabled()) {
                        logger.debug("request RadiusAccessRequestEvent = {}", (Object)event.toString());
                    }
                    EventProcessor.getInstance().request((QueueEvent)event);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (response.getCode() == 2) {
                try {
                    EventProcessor.getInstance().request((QueueEvent)new AuthAcceptEvent(nas.getId(), req.getAgentDeviceId(), (InetServ)radiusSession.login, request, response, req.getIpAddressSet().getResourceId(), req.getCircuitId()));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else if (response.getCode() == 3) {
                nas.addRejectRadiusAttributes(response);
            }
            if (nas.getProtocolHandler() != null) {
                try {
                    logger.info("RESPONSE_BEFORE_POSTPROCESS:\n" + response);
                    nas.getProtocolHandler().postprocessAccessRequest(request, response, connectionSet);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected int authentication(RadiusListenerWorker<?> req, InetNas nas, RadiusSession<InetNas, InetRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) {
        RadiusAccessRequestHandler accessRequestHandler = nas.getAccessRequestHandler();
        if (accessRequestHandler != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("REQUEST_BEFORE_BEFOREAUTHENTICATION:\n" + request);
                }
                accessRequestHandler.beforeAuthentication(req.getConext(), req, session, request, response);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            int returnCode = this.authenticationImpl(req, nas, session, request, response, connectionSet, logRecordId);
            if (returnCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                session.errorCode = returnCode;
            }
            if (session.errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeString(-1, 18, String.valueOf(session.errorCode)));
            }
            logger.info("Return code=" + returnCode);
            return returnCode;
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return AccessCode.SYSTEM_ERROR.getCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authenticationImpl(RadiusListenerWorker<?> req, InetNas nas, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws BGException {
        InetServ serv;
        InetServRuntime servRuntime;
        Date time = new Date();
        Contract contract = null;
        ServSearchResult servSearchResult = null;
        if (nas.isConnectionAccessRequest()) {
            servSearchResult = this.connectionAccessRequest(req, nas, request);
        }
        if (servSearchResult == null) {
            servSearchResult = this.findServRuntime(this.access, req, nas, radiusSession.userName, request, time);
        }
        if (servSearchResult == null) {
            Connection con = connectionSet.getConnection();
            int accessCode = this.tryCreateFromCard(nas, radiusSession, request, response, connectionSet, con, time);
            if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                servRuntime = (InetServRuntime)radiusSession.login;
                serv = servRuntime.getInetServ();
                radiusSession.login = serv;
                contract = radiusSession.contract;
                servSearchResult = new ServSearchResult(0, servRuntime, servRuntime);
            } else {
                if (accessCode != AccessCode.INVALID_ACCOUNT.getCode() || !nas.isDisableRealmAccessCode(accessCode)) {
                    return accessCode;
                }
                int disableServId = nas.getDisableServId(request);
                if (disableServId <= 0) {
                    return accessCode;
                }
                servRuntime = this.access.getInetServRuntimeMap().get(disableServId);
                if (servRuntime == null) {
                    logger.warn("radius.disable.servId=" + disableServId + " but servRuntime not found for this rootDeviceId");
                    return accessCode;
                }
                logger.debug("Use disable.inetServ.");
                radiusSession.errorCode = accessCode;
                serv = servRuntime.getInetServ();
                radiusSession.login = serv;
                try {
                    radiusSession.contract = contract = servRuntime.contractRuntime.toContract(connectionSet, time.getTime());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                servSearchResult = new ServSearchResult(0, servRuntime, servRuntime);
            }
        } else {
            servRuntime = servSearchResult.parentServRuntime;
            InetServ inetServ = serv = servSearchResult.servRuntime != null ? servSearchResult.servRuntime.getInetServ() : servSearchResult.parentServRuntime.getInetServ();
            if (servSearchResult.servRuntime == null) {
                logger.info("inetServ[id=" + serv.getId() + "] sub serv with MAC-address/IP-address/Identifier not found.");
                if (!nas.isDisableRealmAccessCode(AccessCode.MAC_DENY.getCode())) {
                    return AccessCode.MAC_DENY.getCode();
                }
                radiusSession.errorCode = AccessCode.MAC_DENY.getCode();
            }
            radiusSession.login = serv;
            try {
                radiusSession.contract = contract = servRuntime.contractRuntime.toContract(connectionSet, time.getTime());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            if (nas.isPasswordVerification(servRuntime.inetServTypeRef.get())) {
                if (!radiusSession.checkPassword((Nas)nas, (RadiusAttributeSet)request, (RadiusAttributeSet)response, serv.getPassword(), nas.getSecret(), request.getAuthenticator())) {
                    logger.info("[username=" + radiusSession.userName + "] Login password error.");
                    if (!nas.isDisableRealmAccessCode(AccessCode.INVALID_PIN.getCode())) {
                        return AccessCode.INVALID_PIN.getCode();
                    }
                    logger.debug("AccessCode is " + AccessCode.INVALID_PIN.getCode() + ". Set to disable realm (rejectToAccept)");
                    radiusSession.errorCode = AccessCode.INVALID_PIN.getCode();
                    serv = servRuntime.getInetServ();
                    radiusSession.login = serv;
                    try {
                        radiusSession.contract = contract = servRuntime.contractRuntime.toContract(connectionSet, time.getTime());
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    servSearchResult = new ServSearchResult(0, servRuntime, servRuntime);
                }
            } else {
                logger.debug("Password verification disabled.");
            }
            if (radiusSession.errorCode == AccessCode.MAC_DENY.getCode()) {
                serv = servRuntime.getInetServ();
                servSearchResult = new ServSearchResult(0, servRuntime, servRuntime, AccessCode.MAC_DENY.getCode());
            }
        }
        logger.info("[username=" + radiusSession.userName + "] Authenticated as inetServId:" + serv.getId());
        req.setContractId(serv.getContractId());
        req.setAccountId(serv.getId());
        servRuntime.tryLockEx(nas.getRadiusAccessServLockTimeout(), TimeUnit.SECONDS);
        try {
            int ex = this.authorization(req, nas, radiusSession, request, response, connectionSet, logRecordId, (ContractManager)null, contract, (Object)servSearchResult, radiusSession.userName);
            servRuntime.unlock();
            return ex;
        }
        catch (Throwable throwable) {
            try {
                servRuntime.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private ServSearchResult connectionAccessRequest(RadiusListenerWorker<?> req, InetNas nas, RadiusPacket request) {
        String acctSessionId = request.getStringAttribute(-1, 44, null);
        if (acctSessionId == null) {
            return null;
        }
        InetConnection inetConnection = this.access.connectionManager.getByDeviceAcctSessionId(nas.getId(), acctSessionId);
        if (inetConnection == null) {
            return null;
        }
        InetServRuntime inetServRuntime = this.access.inetServRuntimeMap.get(inetConnection.getServId());
        if (inetServRuntime == null) {
            logger.warn("Connection found for Access-Request, but servRuntime is not found");
            return null;
        }
        logger.info("Found active connection by Acct-Session-Id: " + inetConnection.getId());
        req.connectionId = inetConnection.getId();
        IpAddressSet ipAddressSet = req.getIpAddressSet();
        ipAddressSet.setAddress(inetConnection.getInetAddressBytes());
        ipAddressSet.setResourceId(inetConnection.getIpResourceId());
        ipAddressSet.setPrefixResourceId(inetConnection.getPrefixResourceId());
        ipAddressSet.setPrefix(inetConnection.getPrefix());
        ipAddressSet.setPrefixLength(inetConnection.getPrefixLength());
        ipAddressSet.setDelegatedPrefixResourceId(inetConnection.getDelegatedPrefixResourceId());
        ipAddressSet.setDelegatedPrefix(inetConnection.getDelegatedPrefix());
        ipAddressSet.setDelegatedPrefixLength(inetConnection.getDelegatedPrefixLength());
        return new ServSearchResult(0, inetServRuntime.getRootInetServRuntime(this.access), inetServRuntime);
    }

    private int tryCreateFromCard(InetNas nas, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Connection con, Date time) throws BGException {
        int cardModuleId = nas.getCardModuleId();
        if (cardModuleId <= 0) {
            logger.info("[username=" + radiusSession.userName + "] InetServ not found.");
            return AccessCode.INVALID_ACCOUNT.getCode();
        }
        if (!nas.isCardCode(radiusSession.userName)) {
            logger.info("[username=" + radiusSession.userName + "] InetServ not found (and is not card).");
            return AccessCode.INVALID_ACCOUNT.getCode();
        }
        logger.info("[username=" + radiusSession.userName + "] InetServ not found. Try find in cards...");
        EventProcessor ep = EventProcessor.getInstance();
        CardGetRequestEvent cardGet = (CardGetRequestEvent)ep.request((Event)new CardGetRequestEvent(cardModuleId, radiusSession.userName), 5000L);
        if (cardGet == null) {
            logger.error("Answer for CardGetRequestEvent not recieved for 5 sec.");
            return AccessCode.SYSTEM_ERROR.getCode();
        }
        int accessCode = CardActivateRequestEvent.statusToAccessCode((int)cardGet.getStatus());
        if (accessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            logger.info("Card accessCode: " + accessCode);
            return accessCode;
        }
        if (cardGet.getCardId() <= 0L || cardGet.getPinCode() == null) {
            logger.info("[username=" + radiusSession.userName + "] Card with number=" + radiusSession.userName + " not found.");
            return AccessCode.INVALID_ACCOUNT.getCode();
        }
        if (!nas.canActivateCard(cardGet.getActivateServiceId())) {
            logger.debug("Cant't activate card at this NAS");
            return AccessCode.NAS_DENY.getCode();
        }
        if (!radiusSession.checkPassword((Nas)nas, (RadiusAttributeSet)request, (RadiusAttributeSet)response, cardGet.getPinCode(), nas.getSecret(), request.getAuthenticator())) {
            logger.info("[username=" + radiusSession.userName + "] Card PIN error.");
            return AccessCode.INVALID_PIN.getCode();
        }
        CardActivateRequestEvent cardActivate = (CardActivateRequestEvent)ep.request((Event)new CardActivateRequestEvent(cardModuleId, nas.getActivateServiceIds(), cardGet.getCardId(), radiusSession.userName, nas.getId(), this.moduleId), 10000L);
        if (cardActivate == null) {
            logger.error("Answer for CardActivateRequestEvent not recieved for 10 sec.");
            return AccessCode.SYSTEM_ERROR.getCode();
        }
        accessCode = CardActivateRequestEvent.statusToAccessCode((int)cardActivate.getStatus());
        if (accessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            logger.info("Card activate accessCode: " + accessCode);
            return accessCode;
        }
        InetServRuntime servRuntime = this.access.inetServRuntimeMap.getByUsername(radiusSession.userName, time, nas.isUsernameIgnoreCase());
        if (servRuntime == null) {
            try (InetServDao inetServDao = new InetServDao(con, this.moduleId);
                 InetServOptionDao inetServOptionDao = new InetServOptionDao(con, this.moduleId);){
                List<InetServ> list = inetServDao.list(radiusSession.userName, time, time);
                if (list.size() == 0) {
                    logger.info("Created InetServ not found.");
                    int n = AccessCode.SYSTEM_ERROR.getCode();
                    return n;
                }
                InetServ inetServ = list.get(0);
                servRuntime = this.access.inetServRuntimeMap.addRuntime(connectionSet, inetServ, inetServOptionDao.list(inetServ.getId()));
            }
        }
        if (servRuntime != null) {
            ConvergenceBalanceManager.getInstance().updateBalance(connectionSet, servRuntime.getInetServ().getContractId(), System.currentTimeMillis());
        }
        radiusSession.login = servRuntime;
        radiusSession.contract = servRuntime.contractRuntime.toContract(connectionSet, time.getTime());
        return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
    }

    protected int authorization(RadiusListenerWorker<?> req, InetNas inetNas, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId, ContractManager __cm, Contract __contract, Object _login, String username) {
        ServSearchResult servSearchResult = (ServSearchResult)_login;
        InetServRuntime parentServRuntime = servSearchResult.parentServRuntime;
        InetServRuntime servRuntime = servSearchResult.servRuntime != null ? servSearchResult.servRuntime : parentServRuntime;
        InetServ parentServ = parentServRuntime.getInetServ();
        try {
            boolean authorizationFailed;
            int error;
            AuthSessionKey authSessionKey;
            Integer processedNasId;
            InetServIpData inetServIpData = new InetServIpData();
            inetServIpData.setUsername(username);
            inetServIpData.setInetNas(inetNas);
            inetServIpData.setRadiusListenerWorker(req);
            inetServIpData.setInetServ(servRuntime.getInetServ());
            inetServIpData.setConnectionManager(this.access.connectionManager);
            inetServIpData.setInetServTypeRuntime(parentServRuntime.inetServTypeRef.get());
            if (inetServIpData.getInetServTypeRuntime() == null) {
                logger.error("Can't find InetServType with id=" + parentServ.getTypeId());
                return AccessCode.SYSTEM_ERROR.getCode();
            }
            if (REALM_DEFAULT.equals(((InetRadiusSessionParams)radiusSession.sessionParams).enteredRealm) || !inetNas.isRealmAllowed(inetServIpData.getInetServTypeRuntime(), ((InetRadiusSessionParams)radiusSession.sessionParams).realm)) {
                logger.debug("Realm '" + ((InetRadiusSessionParams)radiusSession.sessionParams).enteredRealm + "' now allowed.");
                return AccessCode.REALM_DENY.getCode();
            }
            String callingStationId = request.getStringAttribute(-1, 31, "");
            InetDeviceRuntime agentDeviceRuntime = inetNas.getAgentDeviceRuntime(this.access, req, request);
            String identifier = (String)request.getOption(IDENTIFIER);
            inetServIpData.setAgentDeviceId(agentDeviceRuntime != null ? agentDeviceRuntime.inetDeviceId : 0);
            byte[] macAddress = MACParser.parseMacAddress((String)((String)request.getOption(MAC_ADDRESS)));
            if (macAddress == null) {
                macAddress = (byte[])request.getOption(MAC_ADDRESS_BYTES);
            }
            if (inetNas.getParallelAccessRequestSkipTimeout() > 0L && (processedNasId = (Integer)this.processedNasIdMap.putIfAbsent((Object)(authSessionKey = new AuthSessionKey(inetServIpData.getInetServ().getId(), 0, username, macAddress, callingStationId, identifier, ((InetRadiusSessionParams)radiusSession.sessionParams).realm)), (Object)inetNas.getId(), System.currentTimeMillis() + inetNas.getParallelAccessRequestSkipTimeout())) != null && processedNasId.intValue() != inetNas.getId()) {
                logger.debug("Request skipped - already processed from other NAS");
                return AccessCode.REQUEST_SKIPPED.getCode();
            }
            if ((radiusSession.errorCode == AccessCode.INVALID_ACCOUNT.getCode() || radiusSession.errorCode == AccessCode.INVALID_PIN.getCode() || radiusSession.errorCode == AccessCode.MAC_DENY.getCode()) && parentServ != null) {
                error = radiusSession.errorCode;
                inetServIpData.setOptionSet(null);
            } else {
                Boolean sessionCount;
                if (logger.isDebugEnabled()) {
                    logger.debug("Identifier from request: " + identifier);
                    logger.debug("MAC-address from request: " + Utils.bytesToHexString((byte[])macAddress));
                }
                if (!this.checkDeviceLink(inetNas, parentServRuntime, parentServ, inetServIpData.getInetServTypeRuntime(), inetServIpData.getAgentDeviceId())) {
                    return AccessCode.NAS_DENY.getCode();
                }
                if (!this.checkFramedIpAddress(req, inetNas, parentServRuntime, radiusSession, request)) {
                    logger.info("Framed-IP-Address from request not found in inetServ");
                    return AccessCode.IP_ADDRESS_DENY.getCode();
                }
                int setIdentifier = inetNas.getSetIdentifier(inetServIpData.getInetServTypeRuntime());
                int setMacAddress = inetNas.getSetMacAddress(inetServIpData.getInetServTypeRuntime());
                String enteredUsername = (String)radiusSession.userNameAttribute.getValue();
                AuthResult authResult = this.access.authorization(parentServRuntime, servRuntime, false, inetNas.getId(), inetServIpData.getAgentDeviceId(), ((InetRadiusSessionParams)radiusSession.sessionParams).realm, identifier, setIdentifier, macAddress, setMacAddress, inetNas.getCheckDuplicateSession(inetServIpData.getInetServTypeRuntime()), inetNas.getCheckDuplicateSessionType(inetServIpData.getInetServTypeRuntime()), callingStationId, enteredUsername, true, BigDecimal.ZERO, true);
                if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && req.connectionId == 0L && Boolean.FALSE.equals(sessionCount = this.access.checkSessionCount(connectionSet, parentServRuntime, servRuntime, req.getConnectionType(), inetNas.getCheckDuplicateSession(inetServIpData.getInetServTypeRuntime()), inetNas.getCheckDuplicateSessionType(inetServIpData.getInetServTypeRuntime()), enteredUsername, ((InetRadiusSessionParams)radiusSession.sessionParams).realm, callingStationId, true))) {
                    logger.info("Too many sessions.");
                    authResult = new AuthResult(AccessCode.TOO_MANY_SESSIONS_ERROR.getCode());
                }
                error = radiusSession.errorCode = authResult.accessCode;
                inetServIpData.setOptionSet(authResult.optionSet);
            }
            if (servSearchResult.accessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                error = radiusSession.errorCode = servSearchResult.accessCode;
            }
            inetServIpData.setIpRealm(((InetRadiusSessionParams)radiusSession.sessionParams).realm);
            if (error != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                authorizationFailed = true;
                if (inetNas.isDisableRealmAccessCode(error)) {
                    logger.debug("AccessCode is " + error + ". Set to disable realm (rejectToAccept)");
                    error = AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
                    ((InetRadiusSessionParams)radiusSession.sessionParams).realm = REALM_DISABLE;
                    if (inetNas.getRadiusDisableMode() != 2) {
                        inetServIpData.setIpRealm(REALM_DISABLE);
                    }
                }
            } else {
                authorizationFailed = false;
            }
            if (error != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                return error;
            }
            inetServIpData.setChildrenServRuntimes(this.access.inetServRuntimeMap.listChildren(servRuntime.inetServId, req.millis));
            inetServIpData.setFromRealmOnly(authorizationFailed && inetNas.getRadiusDisableMode() == 0);
            InetServType inetServType = inetServIpData.getInetServTypeRuntime().getInetServType();
            boolean ipResult = false;
            if (inetServType.getAddressType().getCode() > 0 || inetServType.getData() == null) {
                ipResult = new InetServIpHandlerOldMode().setRadiusIp(inetServIpData, request, response);
            } else {
                JSONObject jsonData = new JSONObject(inetServType.getData());
                ipResult = this.setRadiusIP(new InetServTypeIPMode(jsonData.optJSONObject("ipv4")), inetServIpData, request, response);
                boolean bl = ipResult = ipResult && this.setRadiusIP(new InetServTypeIPMode(jsonData.optJSONObject("ipv6")), inetServIpData, request, response);
            }
            if (!ipResult) {
                logger.error("Can't reserve ip address!");
                return AccessCode.FREE_IP_ADDRESS_NOT_FOUND.getCode();
            }
            inetNas.addRadiusAttributes(req.getConext(), req, inetServIpData.getInetServTypeRuntime(), servRuntime, radiusSession, response, inetServIpData.getOptionSet(), null);
            if (inetNas.getConnectionStartFromAccessMode() == 1 && req.connectionId == 0L) {
                try {
                    this.insertAccessAccept(req, radiusSession, connectionSet, inetNas, inetServIpData.getAgentDeviceId(), request, servRuntime, username, callingStationId, authorizationFailed, inetServIpData.getOptionSet());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return error;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return AccessCode.SYSTEM_ERROR.getCode();
        }
    }

    private boolean setRadiusIP(InetServTypeIPMode ipMode, InetServIpData inetServIpData, RadiusPacket request, RadiusPacket response) {
        String ipHandlerClassName = ipMode.getIpHandlerClassName();
        if (Utils.notBlankString((String)ipHandlerClassName)) {
            try {
                InetServIpHandler inetServIpHandler = (InetServIpHandler)DynamicClassManager.getInstance().newInstance(InetServIpHandler.class, ipHandlerClassName);
                return inetServIpHandler.setRadiusIp(inetServIpData, request, response);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return false;
            }
        }
        return true;
    }

    private boolean checkDeviceLink(InetNas nas, InetServRuntime parentServRuntime, InetServ parentServ, InetServTypeRuntime inetServTypeRuntime, int agentDeviceId) {
        int servDeviceLink = nas.getServDeviceLink(inetServTypeRuntime);
        switch (servDeviceLink) {
            case 1: {
                int servDeviceId = parentServRuntime.getInetServ().getDeviceId();
                if (servDeviceId == nas.getId() || servDeviceId == agentDeviceId) break;
                logger.info("inetServ[id=" + parentServ.getId() + "] not on its device.");
                return false;
            }
            case 2: {
                int servDeviceId = parentServRuntime.getInetServ().getDeviceId();
                if (servDeviceId == nas.getId() || servDeviceId == agentDeviceId || nas.getDescendantIds().contains(servDeviceId)) break;
                logger.info("inetServ[id=" + parentServ.getId() + "] not on its device.");
                return false;
            }
        }
        return true;
    }

    private boolean checkFramedIpAddress(RadiusListenerWorker<?> req, InetNas nas, InetServRuntime parentServRuntime, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, RadiusPacket request) {
        if (!nas.isAddressFromRequestCheck()) {
            return true;
        }
        if (req.connectionId > 0L && req.getIpAddressSet().getAddress() != null) {
            return true;
        }
        byte[] inetAddressBytes = request.getByteAttribute(-1, 8, null);
        if (inetAddressBytes == null) {
            return true;
        }
        if (parentServRuntime.ipInRange(inetAddressBytes)) {
            req.getIpAddressSet().setResourceId(parentServRuntime.getInetServ().getIpResourceId());
            return true;
        }
        String realm = ((InetRadiusSessionParams)radiusSession.sessionParams).realm;
        boolean defaultRealm = REALM_DEFAULT.equals(realm) || REALM_DISABLE.equals(realm);
        List<InetServRuntime> childrenServRuntimes = this.access.getInetServRuntimeMap().listChildren(parentServRuntime.inetServId, System.currentTimeMillis());
        if (childrenServRuntimes == null || childrenServRuntimes.size() == 0) {
            return false;
        }
        int size = childrenServRuntimes.size();
        for (int i = 0; i < size; ++i) {
            InetServRuntime childServRuntime = childrenServRuntimes.get(i);
            InetServTypeRuntime childServTypeRuntime = childServRuntime.inetServTypeRef.get();
            if (childServTypeRuntime.radiusNoAddress || childServTypeRuntime.radiusFramedRoute || inetAddressBytes.length == 4 && childServTypeRuntime.radiusDelegetedPrefix) continue;
            InetServ childServ = childServRuntime.getInetServ();
            String login = childServ.getLogin();
            if ((!defaultRealm || !Utils.isBlankString((String)login)) && !realm.equals(login) || childServ.getMacAddressListBytes() != null && childServ.getMacAddressListBytes().length != 0 || !childServRuntime.ipInRange(inetAddressBytes)) continue;
            req.getIpAddressSet().setResourceId(childServRuntime.getInetServ().getIpResourceId());
            return true;
        }
        return false;
    }

    private void insertAccessAccept(RadiusListenerWorker<?> req, RadiusSession<InetNas, InetRadiusSessionParams> radiusSession, ConnectionSet connectionSet, InetNas nas, int agentDeviceId, RadiusPacket request, InetServRuntime servRuntime, String username, String callingStationId, boolean authorizationFailed, Set<Integer> optionSet) throws BGException {
        if (req.connectionId > 0L) {
            return;
        }
        String acctSessionId = request.getStringAttribute(-1, 44, null);
        int nasPort = RadiusUtils.getNasPort((RadiusPacket)request);
        if (nasPort != 0 || req.getIpAddressSet().getAddress() != null || Utils.notBlankString((String)acctSessionId)) {
            Short deviceState;
            String calledStationId = request.getStringAttribute(-1, 30, "");
            InetConnection connection = new InetConnection();
            connection.setAcctSessionId(acctSessionId);
            connection.setCalledStationId(calledStationId);
            connection.setCallingStationId(callingStationId);
            connection.setDeviceId(nas.getId());
            connection.setDevicePort(nasPort);
            connection.setAgentDeviceId(agentDeviceId);
            connection.setCircuitId(req.getCircuitId());
            connection.setConnectionStart(new Date());
            connection.setContractId(servRuntime.contractRuntime.contractId);
            connection.setServId(servRuntime.inetServId.intValue());
            connection.setUsername(username);
            IpAddressSet ipAddressSet = req.getIpAddressSet();
            connection.setInetAddressBytes(ipAddressSet.getAddress());
            connection.setIpResourceId(ipAddressSet.getResourceId());
            connection.setPrefixResourceId(ipAddressSet.getPrefixResourceId());
            connection.setPrefix(ipAddressSet.getPrefix());
            connection.setPrefixLength(ipAddressSet.getPrefixLength());
            connection.setDelegatedPrefixResourceId(ipAddressSet.getDelegatedPrefixResourceId());
            connection.setDelegatedPrefix(ipAddressSet.getDelegatedPrefix());
            connection.setDelegatedPrefixLength(ipAddressSet.getDelegatedPrefixLength());
            connection.setConnectionStatus(0);
            InetConnection.setType((InetConnection)connection, (int)req.getConnectionType(), (boolean)true);
            if (authorizationFailed) {
                InetConnection.setType((InetConnection)connection, (int)32, (boolean)true);
            }
            if ((deviceState = (Short)request.getOption(DEVICE_STATE)) != null) {
                connection.setDeviceState(deviceState.shortValue());
            } else {
                connection.setDeviceState(authorizationFailed ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode());
            }
            connection.setDeviceOptions(optionSet);
            connection.setAccessCode(radiusSession.errorCode);
            connectionSet.commit();
            try (InetConnectionDao connectionDao = new InetConnectionDao(connectionSet.getConnection(), this.access.moduleId);){
                logger.info("Write new waiting connection to DB");
                connectionDao.insert(connection);
                logger.info("New connection id=" + connection.getId());
            }
            connectionSet.commit();
            if (req != null) {
                req.connectionId = connection.getId();
            }
        }
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Radius:\n");
        sb.append("  accounting-requests per minute start: ");
        sb.append(this.accountingStartCounter.getCount());
        sb.append("; stop: ");
        sb.append(this.accountingStopCounter.getCount());
        sb.append("; update: ");
        sb.append(this.accountingUpdateCounter.getCount());
        sb.append("\n  access-requests per minute accept: ");
        sb.append(this.authenticationAcceptCounter.getCount());
        sb.append("; reject: ");
        sb.append(this.authenticationRejectCounter.getCount());
        sb.append("\n  ignore per minute access-request: ");
        sb.append(this.authenticationIgnoreCount.getCount());
        sb.append("; accounting: ");
        sb.append(this.accountingIgnoreCount.getCount());
        sb.append("; accounting-update: ");
        sb.append(this.accountingUpdateIgnoreCount.getCount());
        if (Antispam.getAntispam() != null) {
            sb.append("\nAntispam ban count: ");
            sb.append(Antispam.getAntispam().getBanCount());
            sb.append("; used per minute: ");
            sb.append(this.antispamIgnoreCount.getCount());
        }
        return sb.toString();
    }

    public String getCommandsHelp() {
        return Antispam.getAntispam() != null ? "banlist - show antispam ban list\n" : "";
    }

    public String executeCommand(String cmd, String param) {
        if ("status".equals(cmd)) {
            return this.getStatus();
        }
        Antispam antispam = Antispam.getAntispam();
        if (antispam != null) {
            if ("banList".equals(cmd) || "banlist".equals(cmd)) {
                StringBuilder sb = new StringBuilder();
                for (String key : antispam.getBanList()) {
                    if (sb.length() != 0) {
                        sb.append("\n");
                    }
                    sb.append(key);
                }
                return sb.toString();
            }
            if ("banRemove".equals(cmd)) {
                return String.valueOf(antispam.removeBan(param));
            }
        }
        return null;
    }

    protected ServSearchResult findServRuntime(InetApplication application, RadiusListenerWorker<?> req, InetNas nas, String userName, RadiusPacket request, Date time) {
        return nas.findServRuntime(application, req, userName, request, time);
    }

    private InetNasConnection getNasConnectionIfExist(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, RadiusPacket request, String username, String realm, String acctSessionId, int statusType, boolean needUpdateIpAddress, InetServRuntime[] servRuntimeRef) throws Exception {
        InetNasConnection nasCon = nas.getConnection(acctSessionId);
        if (nasCon == null) {
            return null;
        }
        logger.info("Session " + acctSessionId + " found.");
        InetConnectionCallRuntime connectionCallRuntime = nasCon.getSession();
        if (req != null && connectionCallRuntime != null) {
            req.setContractId(connectionCallRuntime.inetServRuntime.contractRuntime.contractId);
            req.setAccountId(connectionCallRuntime.inetServRuntime.inetServId.intValue());
        }
        if (servRuntimeRef != null) {
            assert (servRuntimeRef[0] == null);
            try {
                connectionCallRuntime.inetServRuntime.tryLockEx(13L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                throw new BGException((Throwable)ex);
            }
            servRuntimeRef[0] = connectionCallRuntime.inetServRuntime;
        }
        if (statusType != 1) {
            Short deviceState;
            if (needUpdateIpAddress) {
                this.updateConnectionIpAddressAndNets(req, connectionSet, nas, connectionCallRuntime, username, null, request);
            }
            if ((deviceState = (Short)request.getOption(DEVICE_STATE)) != null) {
                if (connectionCallRuntime.setDeviceState(this.accounting, connectionSet, deviceState) && req != null) {
                    req.setConnectionModified(true);
                }
            } else {
                this.checkRadiusConnectionServiceTimeout(connectionSet, nas, connectionCallRuntime);
            }
        }
        return nasCon;
    }

    private void checkRadiusConnectionServiceTimeout(ConnectionSet connectionSet, InetNas nas, InetConnectionCallRuntime connectionCallRuntime) throws BGException {
        if (connectionCallRuntime.isServiceSession() || connectionCallRuntime.getServiceConnections() != null || connectionCallRuntime.kill || nas.getRadiusConnectionServiceTimeout() <= 0L) {
            return;
        }
        long millis = System.currentTimeMillis();
        long radiusConnectionServiceTimeout = nas.getRadiusConnectionServiceTimeout() * 1000L;
        if (connectionCallRuntime.connectionStartTime + radiusConnectionServiceTimeout < millis && connectionCallRuntime.connectionStartTime + Math.max(TimeUnit.MINUTES.toMillis(16L), Math.min(3L * connectionCallRuntime.getCloseTimeout(nas.getDeviceRuntime()), 3L * radiusConnectionServiceTimeout)) > millis && ThreadLocalRandom.current().nextInt(3) != 0) {
            logger.info("Session without service sessions. Set inetOptions to empty");
            connectionCallRuntime.setDeviceOptions(this.accounting, connectionSet, Collections.emptySet());
        }
    }

    private static int getIpResourceId(InetNas nas, InetServ inetServ, InetConnection connection, String realm, byte[] address, IpResourceEntry.AddressType addressType) throws Exception {
        if (address == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getIpResourceId: address == null");
            }
            return 0;
        }
        if (inetServ.getAddressFrom() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("inetServ.getAddressFrom() = " + inetServ.getAddressFrom());
            }
            if (inetServ.getAddressTo() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("inetServ.getAddressTo() = " + inetServ.getAddressTo());
                }
                if (IpAddress.equals((byte[])inetServ.getAddressFrom(), (byte[])address)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("IpAddress.equals( inetServ.getAddressFrom(), address )");
                    }
                    return inetServ.getIpResourceId();
                }
            } else if (IpRange.inRange((byte[])address, (byte[])address, (byte[])inetServ.getAddressFrom(), (byte[])inetServ.getAddressTo())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("IpRange.inRange( address, address, inetServ.getAddressFrom(), inetServ.getAddressTo() )");
                }
                return inetServ.getIpResourceId();
            }
        }
        Set optionSet = inetServ.getDeviceOptions();
        Set connectionOptionSet = connection.getDeviceOptions();
        if (connectionOptionSet != null && connectionOptionSet.size() > 0) {
            optionSet = connectionOptionSet;
        }
        return nas.getIpResourceId(connection.getAgentDeviceId(), realm, address, connection.getConnectionStart(), optionSet, addressType);
    }

    private void updateConnectionIpAddressAndNets(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, InetConnectionCallRuntime connectionRuntime, String username, byte[] inetAddressBytes, RadiusPacket request) throws Exception {
        if (connectionRuntime.isServiceSession()) {
            return;
        }
        InetConnection connection = connectionRuntime.connection;
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        boolean ipAddressUpdated = this.updateConnectionIpAddress(req, connectionSet, nas, connectionRuntime, connection, username, inetAddressBytes, request);
        boolean ipNetsUpdated = this.updateConnectionIpNets(req, connectionSet, nas, connectionRuntime, connection, username, inetAddressBytes, request);
        if (!ipAddressUpdated && !ipNetsUpdated) {
            return;
        }
        try (InetConnectionDao inetConnectionDao = new InetConnectionDao(connectionSet.getConnection(), this.moduleId);){
            if (ipAddressUpdated) {
                ipAddressUpdated = inetConnectionDao.updateInetAddress(connection.getDeviceId(), connection.getId(), connection.getInetAddressBytes(), connection.getIpResourceId());
            }
            if (ipNetsUpdated) {
                inetConnectionDao.updateIpNets(connection.getId(), connection.getRouteList());
            }
        }
        this.accounting.registerInetAddress(connection.getDeviceId(), connectionRuntime);
        if (ipAddressUpdated) {
            this.accounting.ipResourceSubscribe(connectionSet.getConnection(), connectionRuntime.inetServRuntime, connection);
        } else {
            logger.debug("IP-address already set for connection");
        }
    }

    private boolean updateConnectionIpAddress(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, InetConnectionCallRuntime connectionRuntime, InetConnection connection, String username, byte[] inetAddressBytes, RadiusPacket request) throws Exception {
        if (connection.getInetAddressBytes() != null) {
            return false;
        }
        if (inetAddressBytes == null) {
            if (request == null) {
                return false;
            }
            inetAddressBytes = request.getByteAttribute(-1, 8, null);
            if (inetAddressBytes == null) {
                inetAddressBytes = request.getByteAttribute(2352, 132, null);
            }
            if (inetAddressBytes == null) {
                return false;
            }
        }
        logger.debug("Set ip address from update packet");
        if (req != null) {
            req.setConnectionModified(true);
        }
        connection.setInetAddressBytes(inetAddressBytes);
        String[] usernameAndRealm = nas.getUsernameAndRealm(username);
        String realm = usernameAndRealm[1];
        int ipResourceId = InetRadiusProcessor.getIpResourceId(nas, connectionRuntime.inetServRuntime.getInetServ(), connection, realm, connection.getInetAddressBytes(), IpResourceEntry.AddressType.Default);
        logger.debug("ipResourceId=" + ipResourceId);
        connection.setIpResourceId(ipResourceId);
        return true;
    }

    private boolean updateConnectionIpNets(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, InetConnectionCallRuntime connectionRuntime, InetConnection connection, String username, byte[] inetAddressBytes, RadiusPacket request) throws BGException {
        if (connection.getRouteList() != null && connection.getRouteList().size() > 0) {
            return false;
        }
        if (request == null) {
            return false;
        }
        List<IpNet> routeNets = this.routeNets(connectionRuntime.inetServRuntime, request);
        if (routeNets.size() == 0) {
            return false;
        }
        connection.setRouteList(routeNets);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetNasConnection getNasConnection(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, RadiusPacket request, Date time) throws Exception {
        InetServRuntime[] servRuntimeRef = new InetServRuntime[1];
        InetNasConnection result = null;
        try {
            result = this.getNasConnection(req, connectionSet, nas, request, time, servRuntimeRef);
        }
        finally {
            InetServRuntime servRuntime;
            if (result == null && (servRuntime = servRuntimeRef[0]) != null) {
                servRuntime.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetNasConnection getNasConnection(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, RadiusPacket request, Date time, InetServRuntime[] servRuntimeRef) throws Exception {
        InetServRuntime servRuntime;
        InetNasConnection parentConnection;
        String acctSessionId = request.getStringAttribute(-1, 44, null);
        if (acctSessionId == null) {
            logger.error("Attribute Acct_Session_Id not found in packet!");
            return null;
        }
        int nasPort = RadiusUtils.getNasPort((RadiusPacket)request);
        int statusType = request.getIntAttribute(-1, 40, Integer.valueOf(0));
        if (statusType == 0) {
            logger.error("Status type of packet incorrect!");
            return null;
        }
        String username = request.getStringAttribute(-1, 1, "");
        String[] usernameAndRealm = nas.getUsernameAndRealm(username);
        String realm = usernameAndRealm[1];
        assert (servRuntimeRef != null);
        InetNasConnection nasCon = this.getNasConnectionIfExist(req, connectionSet, nas, request, username, realm, acctSessionId, statusType, true, servRuntimeRef);
        if (nasCon != null) {
            return nasCon;
        }
        String parentAcctSessionId = (String)request.getOption(PARENT_ACCT_SESSION_ID);
        if (Utils.notEmptyString((String)parentAcctSessionId)) {
            parentConnection = nas.getConnection(parentAcctSessionId);
            if (parentConnection == null) {
                nas.readLock().lock();
                try {
                    parentConnection = nas.getConnection(parentAcctSessionId);
                    if (parentConnection == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Option parentAcctSessionId is set but connection not found with acctSessionId=" + parentAcctSessionId + ". Add to start with parent map.");
                        }
                        nas.startWithParentAdd(time, parentAcctSessionId, request);
                        InetNasConnection inetNasConnection = null;
                        return inetNasConnection;
                    }
                }
                finally {
                    nas.readLock().unlock();
                }
            }
            servRuntime = parentConnection.getSession().inetServRuntime;
        } else {
            InetServRuntime foundServRuntime;
            parentConnection = null;
            ServSearchResult servSearchResult = this.findServRuntime(this.accounting, req, nas, usernameAndRealm[0], request, time);
            if (servSearchResult == null) {
                foundServRuntime = null;
                int disableServId = nas.getDisableServId(request);
                if (disableServId > 0) {
                    foundServRuntime = this.accounting.getInetServRuntimeMap().get(disableServId);
                    if (foundServRuntime != null) {
                        logger.info("InetServ not found for username=" + username + ". Use radius.disable.servId=" + disableServId);
                    } else {
                        logger.warn("radius.disable.servId=" + disableServId + " but servRuntime not found for this rootDeviceId");
                    }
                }
            } else {
                foundServRuntime = servSearchResult.servRuntime != null ? servSearchResult.servRuntime : servSearchResult.parentServRuntime;
            }
            servRuntime = foundServRuntime;
        }
        if (req != null && servRuntime != null) {
            req.setContractId(servRuntime.contractRuntime.contractId);
            req.setAccountId(servRuntime.inetServId.intValue());
        }
        return this.getNasConnectionFromServ(req, connectionSet, nas, request, time, servRuntimeRef, servRuntime, username, realm, nasPort, acctSessionId, statusType, parentConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetNasConnection getNasConnectionFromServ(RadiusListenerWorker<?> req, ConnectionSet connectionSet, InetNas nas, RadiusPacket request, Date time, InetServRuntime[] servRuntimeRef, InetServRuntime servRuntime, String username, String realm, int nasPort, String acctSessionId, int statusType, InetNasConnection parentConnection) throws Exception {
        Map<Integer, AccountingTrafficAmount> counterTraffics;
        InetConnection existConnection;
        InetConnectionCallRuntime parentConnectionRuntime;
        if (servRuntime == null) {
            logger.error("InetServ not found for username=" + username);
            return null;
        }
        try {
            servRuntime.tryLockEx(13L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new BGException((Throwable)ex);
        }
        servRuntimeRef[0] = servRuntime;
        InetNasConnection nasCon = this.getNasConnectionIfExist(req, connectionSet, nas, request, username, realm, acctSessionId, statusType, true, null);
        if (nasCon != null) {
            return nasCon;
        }
        if (nas.isRecentlyStopped(acctSessionId)) {
            logger.warn("Duplicate radius packet (session already stopped by accounting-stop packet).");
            return null;
        }
        if (req != null && parentConnection == null) {
            req.setConnectionModified(true);
        }
        if (statusType != 1 && statusType != 2 && statusType != 3) {
            logger.error("Status type of packet incorrect for init NasConnection!");
            return null;
        }
        RadiusAttribute sessionTimeAttribute = request.getAttribute(-1, 46);
        if (statusType != 1) {
            if (sessionTimeAttribute == null) {
                logger.info("AcctSessionTime not found for [statusType=" + statusType + "], halt create NasConnection");
                return null;
            }
            logger.warn("Creating NasConnection from accounting packet [statusType=" + statusType + "]");
        } else {
            logger.info("Creating NasConnection from radius accounting packet");
        }
        long sessionTime = sessionTimeAttribute != null ? (long)((Integer)sessionTimeAttribute.getValue()).intValue() : 0L;
        byte[] inetAddressBytes = request.getByteAttribute(-1, 8, null);
        if (inetAddressBytes == null) {
            inetAddressBytes = request.getByteAttribute(2352, 132, null);
        }
        RadiusAttribute prefixAttribute = request.getAttribute(-1, 97);
        RadiusAttribute delegatedPrefixAttribute = request.getAttribute(-1, 123);
        IpAddress inetAddress = inetAddressBytes != null ? new IpAddress(inetAddressBytes) : null;
        IpNet prefix = prefixAttribute != null ? (IpNet)prefixAttribute.getValue() : null;
        IpNet delegatedPrefix = delegatedPrefixAttribute != null ? (IpNet)delegatedPrefixAttribute.getValue() : null;
        List<IpNet> routeNets = this.routeNets(servRuntime, request);
        String calledStationId = request.getStringAttribute(-1, 30, "");
        String callingStationId = request.getStringAttribute(-1, 31, "");
        long inputOctets = request.getIntAttribute(-1, 52, Integer.valueOf(0)).intValue();
        inputOctets = (inputOctets << 32) + (long)request.getIntAttribute(-1, 42, Integer.valueOf(0)).intValue();
        long outputOctets = request.getIntAttribute(-1, 53, Integer.valueOf(0)).intValue();
        outputOctets = (outputOctets << 32) + (long)request.getIntAttribute(-1, 43, Integer.valueOf(0)).intValue();
        InetConnection connection = new InetConnection();
        connection.setAcctSessionId(acctSessionId);
        connection.setCalledStationId(calledStationId);
        connection.setCallingStationId(callingStationId);
        connection.setDeviceId(nas.getId());
        connection.setDevicePort(nasPort);
        connection.setServId(servRuntime.inetServId.intValue());
        InetConnection.setType((InetConnection)connection, (int)(req != null ? req.getConnectionType() : 512), (boolean)true);
        if (parentConnection != null) {
            parentConnectionRuntime = parentConnection.getSession();
            String serviceName = (String)request.getOption(SERVICE_NAME);
            connection.setUsername(serviceName);
            connection.setAgentDeviceId(parentConnectionRuntime.connection.getAgentDeviceId());
        } else {
            parentConnectionRuntime = null;
            connection.setUsername(username);
            connection.setCircuitId(req.getCircuitId());
            if (inetAddress == null && prefix == null && statusType != 1 && !nas.isConnectionStartFromUpdateIgnoreFramedIpLack()) {
                logger.error("Session ip address in packet or parent connection not found!");
                return null;
            }
            if (inetAddress != null) {
                connection.setInetAddressBytes(inetAddress.address);
            }
            if (prefix != null) {
                connection.setPrefix(prefix.getSubnet());
                connection.setPrefixLength((short)prefix.getMask());
            }
            if (delegatedPrefix != null) {
                connection.setDelegatedPrefix(delegatedPrefix.getSubnet());
                connection.setDelegatedPrefixLength((short)delegatedPrefix.getMask());
            }
        }
        if (routeNets.size() > 0) {
            connection.setRouteList(routeNets);
        }
        Date connectionStart = statusType == 1 ? time : new Date(time.getTime() - sessionTime * 1000L);
        Object[] existConnectionRef = InetSessionDao.getCall(connectionSet.getConnection(), this.moduleId, connection, connectionStart, parentConnectionRuntime != null ? parentConnectionRuntime.connectionId : 0L, statusType == 1, nas.isAcctSessIdAlwaysPresent(), nas.isIpAlwaysPresent(), nas.isNasPortCorrect());
        if (existConnectionRef != null) {
            existConnection = (InetConnection)existConnectionRef[0];
            if (existConnection.getConnectionStatus() >= 3) {
                logger.warn("Connection found in DB and it already stopped");
                return null;
            }
        } else {
            existConnection = null;
        }
        if (existConnection != null) {
            InetDeviceRuntime agentDeviceRuntime;
            logger.info("Connection exist in DB");
            InetConnection oldConnecton = connection;
            connection = existConnection;
            InetSession session = (InetSession)existConnectionRef[1];
            if (connection.getConnectionStatus() >= 3 && statusType == 2) {
                return null;
            }
            if (session != null) {
                logger.info("Session exist in DB");
                nasCon = this.getNasConnectionIfExist(req, connectionSet, nas, request, username, realm, acctSessionId, statusType, false, null);
                if (nasCon != null) {
                    return nasCon;
                }
                Map<Integer, AccountingTrafficAmount> counterTraffics2 = InetSessionDao.getCountersFromDB(connectionSet.getConnection(), this.accounting.moduleId, servRuntime.getInetServTypeRuntime(), session.getId());
                return this.connectionCallStart(req, (ConnectionSet)connectionSet, (boolean)false, (InetServRuntime)servRuntime, (InetConnection)connection, (InetSession)session, (long)session.getId(), null, (InetNas)nas, (InetConnectionCallRuntime)parentConnectionRuntime, (String)username, (byte[])inetAddressBytes, (boolean)true, counterTraffics2).nasConnection;
            }
            connection.setAcctSessionId(oldConnecton.getAcctSessionId());
            connection.setUsername(oldConnecton.getUsername());
            if (oldConnecton.getInetAddressBytes() != null) {
                if (connection.getInetAddressBytes() == null || !IpAddress.equals((byte[])connection.getInetAddressBytes(), (byte[])oldConnecton.getInetAddressBytes())) {
                    connection.setIpResourceId(0);
                }
                connection.setInetAddressBytes(oldConnecton.getInetAddressBytes());
            }
            if (oldConnecton.getPrefix() != null) {
                if (connection.getPrefix() == null || !IpAddress.equals((byte[])connection.getPrefix(), (byte[])oldConnecton.getPrefix())) {
                    connection.setPrefixResourceId(0);
                }
                connection.setPrefix(oldConnecton.getPrefix());
                connection.setPrefixLength(oldConnecton.getPrefixLength());
            }
            if (oldConnecton.getDelegatedPrefix() != null) {
                if (connection.getDelegatedPrefix() == null || !IpAddress.equals((byte[])connection.getDelegatedPrefix(), (byte[])oldConnecton.getDelegatedPrefix())) {
                    connection.setDelegatedPrefixResourceId(0);
                }
                connection.setDelegatedPrefix(oldConnecton.getDelegatedPrefix());
                connection.setDelegatedPrefixLength(oldConnecton.getDelegatedPrefixLength());
            }
            if (Utils.notEmptyString((String)oldConnecton.getCallingStationId())) {
                connection.setCallingStationId(oldConnecton.getCallingStationId());
            }
            if (Utils.notEmptyString((String)oldConnecton.getCalledStationId())) {
                connection.setCalledStationId(oldConnecton.getCalledStationId());
            }
            if ((agentDeviceRuntime = nas.getAgentDeviceRuntime(this.accounting, req, request)) != null) {
                connection.setAgentDeviceId(agentDeviceRuntime.inetDeviceId.intValue());
            }
        } else {
            connection.setContractId(servRuntime.contractRuntime.contractId);
            connection.setServId(servRuntime.inetServId.intValue());
            if (statusType != 1) {
                InetConnection.setType((InetConnection)connection, (int)1, (boolean)true);
            }
            logger.info("Parent: " + parentConnectionRuntime);
            if (parentConnectionRuntime == null) {
                Short deviceState;
                InetDeviceRuntime agentDeviceRuntime = nas.getAgentDeviceRuntime(this.accounting, req, request);
                if (agentDeviceRuntime != null) {
                    connection.setAgentDeviceId(agentDeviceRuntime.inetDeviceId.intValue());
                }
                if ((deviceState = (Short)request.getOption(DEVICE_STATE)) != null) {
                    connection.setDeviceState(deviceState.shortValue());
                } else {
                    boolean unauthorized = nas.isUnauthorizedSession(servRuntime.inetServId, servRuntime, request, realm);
                    connection.setDeviceState(unauthorized ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode());
                }
            } else {
                Short deviceState = (Short)request.getOption(DEVICE_STATE);
                if (deviceState != null) {
                    parentConnectionRuntime.setDeviceState(this.accounting, connectionSet, deviceState);
                }
            }
        }
        assert (servRuntime.isHeldByCurrentThread());
        Date sessionStart = connectionStart;
        if (statusType != 1) {
            switch (nas.getConnectionStartFromUpdateMode()) {
                case 0: {
                    logger.warn("Update/Stop packet without start. Skip");
                    return null;
                }
                case 2: {
                    if (sessionTime < nas.getConnectionCloseTimeout()) {
                        if (parentConnectionRuntime != null && parentConnectionRuntime.sessionStart.compareTo(sessionStart) <= 0) {
                            logger.info("Start from update packet");
                            break;
                        }
                        logger.info("sessionStart before parent sessionStart");
                    }
                }
                default: {
                    if (statusType == 2) {
                        logger.warn("Stop packet without start or update. Skip");
                        return null;
                    }
                    logger.info("Start from update packet now");
                    sessionStart = time;
                }
            }
        }
        if (parentConnectionRuntime != null) {
            long millis = sessionStart.getTime();
            Long hour = InetUtils.getHour(millis);
            parentConnectionRuntime.trySplitSession(this.accounting, hour, millis);
        }
        connection.setConnectionStart(connectionStart);
        this.checkIpResourceId(nas, servRuntime, realm, connection);
        if (statusType != 1) {
            if (sessionStart != connectionStart) {
                logger.info("Start from update packet - get counter traffics from packet");
                counterTraffics = InetUtils.getCounterTraffics(servRuntime, parentConnectionRuntime, connection, request);
            } else {
                counterTraffics = null;
            }
        } else {
            counterTraffics = null;
        }
        InetConnectionCallRuntime connectionCallRuntime = this.connectionCallStart(req, connectionSet, true, servRuntime, connection, null, 0L, sessionStart, nas, parentConnectionRuntime, null, null, false, counterTraffics);
        if (statusType == 1 && parentConnectionRuntime == null) {
            connectionSet.commit();
            nas.writeLock().lock();
            try {
                nas.startWithParentProcess(connectionSet, acctSessionId);
            }
            finally {
                nas.writeLock().unlock();
            }
        }
        return connectionCallRuntime.nasConnection;
    }

    private void checkIpResourceId(InetNas nas, InetServRuntime servRuntime, String realm, InetConnection connection) throws Exception {
        int ipResourceId;
        if (connection.getIpResourceId() == 0) {
            ipResourceId = InetRadiusProcessor.getIpResourceId(nas, servRuntime.getInetServ(), connection, realm, connection.getInetAddressBytes(), IpResourceEntry.AddressType.Default);
            if (ipResourceId > 0 || connection.getInetAddressBytes() == null) {
                logger.debug("ipResourceId=" + ipResourceId);
            } else {
                logger.error("ipResourceId=" + ipResourceId + " for acctSessionId:" + connection.getAcctSessionId());
            }
            connection.setIpResourceId(ipResourceId);
        }
        if (connection.getPrefix() != null && connection.getPrefixResourceId() == 0) {
            ipResourceId = InetRadiusProcessor.getIpResourceId(nas, servRuntime.getInetServ(), connection, realm, connection.getPrefix(), IpResourceEntry.AddressType.IPv6Prefix);
            if (ipResourceId > 0 || connection.getInetAddressBytes() == null) {
                logger.debug("prefixResourceId=" + ipResourceId);
            } else {
                logger.error("prefixResourceId=" + ipResourceId + " for acctSessionId:" + connection.getAcctSessionId());
            }
            connection.setPrefixResourceId(ipResourceId);
        }
        if (connection.getDelegatedPrefix() != null && connection.getDelegatedPrefixResourceId() == 0) {
            ipResourceId = InetRadiusProcessor.getIpResourceId(nas, servRuntime.getInetServ(), connection, realm, connection.getDelegatedPrefix(), IpResourceEntry.AddressType.IPv6DelegatedPrefix);
            if (ipResourceId > 0 || connection.getInetAddressBytes() == null) {
                logger.debug("delegatedPrefixResourceId=" + ipResourceId);
            } else {
                logger.error("delegatedPrefixResourceId=" + ipResourceId + " for acctSessionId:" + connection.getAcctSessionId());
            }
            connection.setDelegatedPrefixResourceId(ipResourceId);
        }
    }

    private InetConnectionCallRuntime connectionCallStart(RadiusListenerWorker<?> req, ConnectionSet connectionSet, boolean system, InetServRuntime servRuntime, InetConnection connection, InetSession session, long sessionId, Date sessionStart, InetNas nas, InetConnectionCallRuntime parentConnection, String username, byte[] inetAddressBytes, boolean updateIpAddress, Map<Integer, AccountingTrafficAmount> counterTraffics) throws Exception {
        assert (nas.getId() == connection.getDeviceId());
        InetConnectionCallRuntime connectionRuntime = this.accounting.connectionCallStart(connectionSet, system, connection, session, sessionId, sessionStart, (NasList<InetNasConnection, InetNas>)this.nasList, servRuntime, parentConnection, counterTraffics);
        if (updateIpAddress) {
            this.updateConnectionIpAddressAndNets(req, connectionSet, nas, connectionRuntime, username, inetAddressBytes, null);
        }
        nas.setConnection(connectionRuntime.nasConnection, connectionSet.getConnection(), connectionSet.getSlaveConnection());
        return connectionRuntime;
    }

    protected void addToLog(Date date, RadiusPacket packet, int recordId) {
    }

    protected int insertToLog(Date date, RadiusPacket packet) {
        return 0;
    }

    private List<IpNet> routeNets(InetServRuntime inetServRuntime, RadiusPacket request) throws BGException {
        ArrayList<IpNet> result = new ArrayList<IpNet>(4);
        try {
            List routeAddrList = request.getAttributes(-1, 22);
            if (routeAddrList != null) {
                for (RadiusAttribute ra : routeAddrList) {
                    byte[] subnet;
                    String value = (String)ra.getValue();
                    Matcher m = patternRouteNet1.matcher(value);
                    if (m.find()) {
                        subnet = InetAddress.getByName(m.group(1)).getAddress();
                        byte[] mask = InetAddress.getByName(m.group(2)).getAddress();
                        result.add(new IpNet(subnet, IpNet.maskToInt((byte[])mask)));
                        continue;
                    }
                    m = patternRouteNet2.matcher(value);
                    if (!m.find()) continue;
                    subnet = InetAddress.getByName(m.group(1)).getAddress();
                    int mask = Utils.parseInt((String)m.group(2));
                    result.add(new IpNet(subnet, mask));
                }
            }
        }
        catch (UnknownHostException ex) {
            throw new BGException((Throwable)ex);
        }
        this.flowStaticSubnet(inetServRuntime, result);
        return result;
    }

    private void flowStaticSubnet(InetServRuntime inetServRuntime, List<IpNet> result) {
        InetServTypeRuntime inetServTypeRuntime = inetServRuntime.getInetServTypeRuntime();
        InetServType inetServType = inetServTypeRuntime.getInetServType();
        if (!inetServTypeRuntime.flowStaticSubnet) {
            return;
        }
        if (inetServType.getAddressType().getCode() > -1) {
            if (inetServType.getAddressType() != InetAddressType.NET) {
                return;
            }
            new InetServIpHandlerOldMode().flowStaticSubnet(inetServRuntime, result);
        } else {
            JSONObject jsonData = new JSONObject(inetServType.getData());
            this.flowStaticSubnet(new InetServTypeIPMode(jsonData.optJSONObject("ipv4")), jsonData.getInt("netMode"), inetServRuntime, result);
            this.flowStaticSubnet(new InetServTypeIPMode(jsonData.optJSONObject("ipv6")), jsonData.getInt("netMode"), inetServRuntime, result);
        }
    }

    private void flowStaticSubnet(InetServTypeIPMode ipMode, int netMode, InetServRuntime inetServRuntime, List<IpNet> result) {
        String ipHandlerClassName;
        if (netMode == 1 && Utils.notBlankString((String)(ipHandlerClassName = ipMode.getIpHandlerClassName()))) {
            try {
                ((InetServIpHandler)DynamicClassManager.getInstance().newInstance(InetServIpHandler.class, ipHandlerClassName)).flowStaticSubnet(inetServRuntime, result);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(InetAccountingEvent e, EventListenerContext ctx) throws Exception {
        InetConnection connection = e.getConnection();
        InetNas nas = (InetNas)this.nasList.get(connection.getDeviceId());
        if (nas == null) {
            return;
        }
        Connection con = ctx.getConnectionSet().getConnection();
        switch (e.getType()) {
            case 1: {
                InetServRuntime servRuntime = this.accounting.inetServRuntimeMap.get(connection.getServId());
                servRuntime.lock();
                try {
                    long sessionId = e.getSessionId();
                    InetConnectionCallRuntime connectionCallRuntime = this.connectionCallStart(null, ctx.getConnectionSet(), false, servRuntime, connection, null, sessionId, null, nas, null, null, null, false, e.getCounterTraffics());
                    Map<Integer, AccountingTrafficAmount> counterTraffics = e.getCounterTraffics();
                    if (counterTraffics == null || counterTraffics.size() <= 0) break;
                    for (Map.Entry<Integer, AccountingTrafficAmount> entry : counterTraffics.entrySet()) {
                        connectionCallRuntime.initCounterTraffic(entry.getKey(), entry.getValue().amount);
                    }
                    break;
                }
                finally {
                    servRuntime.unlock();
                }
            }
            case 2: {
                InetNasConnection nasCon = nas.getConnection(connection.getAcctSessionId());
                long time = e.getAccountingTime() != null ? e.getAccountingTime().getTime() : e.getTimestamp();
                nas.stopConnection(con, nasCon, 0L, false, time, false);
                break;
            }
        }
    }

    protected void postprocessAccountingRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        if (nas.getProtocolHandler() != null) {
            try {
                nas.getProtocolHandler().postprocessAccountingRequest(request, response, connectionSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void postprocessAccessRequest(InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
    }

    protected InetNas getNas(SocketAddress clientAddress, RadiusPacket packet) {
        InetNas result = (InetNas)super.getNas(clientAddress, packet);
        if (result == null) {
            return result;
        }
        try {
            ProtocolHandler protocolHandler = result.getProtocolHandler();
            if (protocolHandler == null) {
                return result;
            }
            String nasIdentifier = protocolHandler.overrideNasIdentifier(packet);
            if (nasIdentifier == null) {
                return result;
            }
            InetNas newResult = (InetNas)this.nasList.get(nasIdentifier);
            if (newResult != null) {
                logger.debug("nasIdentifier was overridden");
                return newResult;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static final class AuthAcceptEvent
    extends LocalEvent {
        private final int deviceId;
        private final int agentDeviceId;
        private final InetServ inetServ;
        private final RadiusPacket request;
        private final RadiusPacket response;
        private final int ipResourceId;
        private final Object circuitId;

        public AuthAcceptEvent(int deviceId, int agentDeviceId, InetServ inetServ, RadiusPacket request, RadiusPacket response, int ipResourceId, Object circuitId) {
            this.deviceId = deviceId;
            this.agentDeviceId = agentDeviceId;
            this.inetServ = inetServ;
            this.request = request;
            this.response = response;
            this.ipResourceId = ipResourceId;
            this.circuitId = circuitId;
        }

        public int getDeviceId() {
            return this.deviceId;
        }

        public int getAgentDeviceId() {
            return this.agentDeviceId;
        }

        public InetServ getInetServ() {
            return this.inetServ;
        }

        public RadiusPacket getRequest() {
            return this.request;
        }

        public RadiusPacket getResponse() {
            return this.response;
        }

        public int getIpResourceId() {
            return this.ipResourceId;
        }

        public Object getCircuitId() {
            return this.circuitId;
        }
    }
}

