/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.range;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeLoader;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeMetaData;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeSpec;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.TrafficRangeManager;
import ru.bitel.common.ParameterMap;

public class TrafficRangeTariffTreeNode
extends RangeTreeNode<InetTariffRequest, InetTariffWorkerContext, InetServiceCost> {
    private final int trafficRangeSpecId;

    public TrafficRangeTariffTreeNode(Connection con, int moduleId, int id, ParameterMap params) {
        super(id, params);
        int trafficRangeSpecId = params.getInt("trafficRangeSpecId", -100);
        if (trafficRangeSpecId > -100) {
            long amount;
            int type;
            TrafficRangeSpec trafficRangeSpec = null;
            try {
                Directory trafficRangeSpecDir = ServerDirectoryFactory.newUnmodifiableDirectory(TrafficRangeSpec.class, (Connection)con, (int)moduleId, (boolean)true);
                trafficRangeSpec = (TrafficRangeSpec)trafficRangeSpecDir.get(trafficRangeSpecId);
            }
            catch (BGException ex) {
                this.logError(ex);
            }
            if (trafficRangeSpec != null) {
                this.trafficRangeSpecId = trafficRangeSpecId;
                type = trafficRangeSpec.getMaxAmountType();
                amount = trafficRangeSpec.getMaxAmount();
                this.periodMode = trafficRangeSpec.getMode();
                this.proportionType = trafficRangeSpec.getType();
                this.tariffOptionId = trafficRangeSpec.getTariffOptionId();
                this.tariffOptionDeactivate = trafficRangeSpec.isTariffOptionDeactivate();
            } else {
                this.trafficRangeSpecId = 0;
                type = 0;
                amount = 0L;
                this.periodMode = 2;
                this.proportionType = 1;
                this.tariffOptionId = 0;
                this.tariffOptionDeactivate = false;
            }
            this.maxAmount = type >= 0 && amount >= 0L ? this.getServiceAmount(type, amount) : amount;
            this.labelId = 0;
        } else {
            this.trafficRangeSpecId = -1;
        }
    }

    public int getTrafficRangeSpecId() {
        return this.trafficRangeSpecId;
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        InetServiceCost cost = (InetServiceCost)req.serviceCost;
        this.getLogger().debug("TrafficRangeTariffTreeNode: trafficRangeSpecId={}; labelId={}; maxAmount={}; cost={}", new Object[]{this.trafficRangeSpecId, this.labelId, this.maxAmount, cost});
        if (cost == null || this.trafficRangeSpecId == 0) {
            return 0;
        }
        return super.execute(treeNodeId, parentTreeNodeId, (AbstractTariffRequest)req, holder, ctx, treeContext, (TariffWorkerContext)workerContext);
    }

    protected long addRangedTraffic(TariffContext tariffContext, InetTariffWorkerContext workerContext, InetTariffRequest req, int contractTariffOptionId, long treeNodeId, long maxAmount, long amount) throws BGException {
        long rangeId = this.trafficRangeSpecId > 0 ? (long)this.trafficRangeSpecId : treeNodeId;
        this.getLogger().debug("addRangedTraffic: rangeId={}; req.connectionRuntime={}", (Object)rangeId, (Object)req.connectionRuntime);
        if (req.connectionRuntime != null) {
            return ((TrafficRangeManager)tariffContext.rangedTrafficManager).addRangedTraffic(workerContext, req.connectionRuntime, contractTariffOptionId, rangeId, this.periodMode, 0, req.getTime(), maxAmount, amount, (TrafficRangeLoader)tariffContext.rangedTrafficManager, null, null);
        }
        return tariffContext.rangedTrafficManager.addRangedTraffic((TariffWorkerContext)workerContext, req.contractId, req.accountingPeriodId, contractTariffOptionId, rangeId, this.periodMode, 0, req.getTime(), maxAmount, amount, (TrafficRangeLoader)tariffContext.rangedTrafficManager, null, null);
    }

    public TariffTreeNodeMetaData getMetaData() {
        return super.getMetaData().setRange(true).setRangeTitle(String.valueOf(this.labelId > 0 ? this.labelId : this.id));
    }
}

