/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class MangoAccountProductDao
extends AbstractIdDao<MangoAccountProduct> {
    public MangoAccountProductDao(Connection con, int moduleId) {
        super(con, moduleId, "mango_account_product");
    }

    public List<MangoAccountProduct> getList(int accountId) throws SQLException {
        return this.list("accountId=?", "id", new Object[]{accountId});
    }

    protected MangoAccountProduct getFromRS(ResultSet rs) throws SQLException {
        MangoAccountProduct product = new MangoAccountProduct();
        product.setId(rs.getInt("id"));
        product.setAccountId(rs.getInt("accountId"));
        product.setPlanId(rs.getInt("planId"));
        product.setProductId(rs.getInt("productId"));
        product.setProductStatus(rs.getInt("productStatus"));
        product.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        product.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        return product;
    }

    protected void updateImpl(MangoAccountProduct mangoAccountProduct) throws SQLException {
        Objects.requireNonNull(mangoAccountProduct);
        int index = 1;
        if (mangoAccountProduct.getId() < 1) {
            String query = "INSERT INTO " + this.tableName + " SET accountId=?, planId=?, productId=?, productStatus=?, dateFrom=?, dateTo=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(index++, mangoAccountProduct.getAccountId());
                ps.setInt(index++, mangoAccountProduct.getPlanId());
                ps.setInt(index++, mangoAccountProduct.getProductId());
                ps.setInt(index++, mangoAccountProduct.getProductStatus());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoAccountProduct.getDateFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoAccountProduct.getDateTo()));
                ps.executeUpdate();
                mangoAccountProduct.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        String query = "UPDATE " + this.tableName + " SET productStatus=?, dateTo=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(index++, mangoAccountProduct.getProductStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)mangoAccountProduct.getDateTo()));
        }
    }
}

