/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client;

import bitel.billing.module.admin.resource.NumberResourceSelectPanel;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.phone.client.contract.AbstractIpListPanel;
import ru.bitel.bgbilling.modules.phone.common.service.IpPhoneService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGURadioList;
import ru.bitel.common.model.IdTitle;

public class PointEditor
extends ServicePanel {
    private BGTextField alias = new BGTextField();
    private JTextArea pointComment = new JTextArea();
    private CardLayout mainLayout = new CardLayout();
    private BGTextField pointPorts = new BGTextField();
    private BGTextField pointNumbers = new BGTextField();
    private BGURadioList<IdTitle> pointAts = new BGURadioList();
    private BGComboBox<ComboBoxItem> object_CB = new BGComboBox();
    private BGControlPanelPeriodNoB pointPeriod = new BGControlPanelPeriodNoB();
    private NumberResourceSelectPanel resourceSelectPanel = new NumberResourceSelectPanel();
    private AbstractIpListPanel ipnPanel = new AbstractIpListPanel();
    private JPanel rightPanel = new JPanel(new GridBagLayout());

    public PointEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(this.mainLayout);
        JPanel objectPanel = new JPanel(new GridBagLayout());
        objectPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0431\u044a\u0435\u043a\u0442 "));
        objectPanel.add((Component)this.object_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel editPanel = new JPanel(new GridBagLayout());
        JPanel pointEditorPanel = new JPanel(new GridBagLayout());
        editPanel.add((Component)pointEditorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel atsPanel = new JPanel(new GridBagLayout());
        atsPanel.add((Component)this.pointAts, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        atsPanel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a "));
        pointEditorPanel.add((Component)atsPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton takeNumber = new JButton("<<<");
        takeNumber.setToolTipText("\u0412\u0437\u044f\u0442\u044c \u0438\u0437 \u043f\u0443\u043b\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        takeNumber.addActionListener(e -> this.mainLayout.show((Container)((Object)this), "resource_select"));
        this.rightPanel.add((Component)new JLabel("\u0410\u043b\u0438\u0430\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.alias, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440(\u0430)"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.pointNumbers, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)takeNumber, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)new JLabel("\u041f\u043e\u0440\u0442(\u044b)"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.pointPorts, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.pointPorts.setMinimumSize(new Dimension(200, 10));
        this.rightPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.pointPeriod, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)new JScrollPane(this.pointComment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        commentPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        this.ipnPanel = new AbstractIpListPanel();
        this.ipnPanel.setBorder((Border)new BGTitleBorder("Ip-\u0430\u0434\u0440\u0435\u0441"));
        this.rightPanel.add((Component)commentPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)((Object)this.ipnPanel), new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)objectPanel, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        pointEditorPanel.add((Component)this.rightPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.resourceSelectPanel.setActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.pointPeriod.setDateCalendar1(this.resourceSelectPanel.getDate());
                this.pointNumbers.setText(this.resourceSelectPanel.getNumber());
            }
            this.mainLayout.show((Container)((Object)this), "edit");
        });
        this.add(editPanel, "edit");
        this.add((Component)this.resourceSelectPanel, "resource_select");
        this.mainLayout.show((Container)((Object)this), "edit");
    }

    public void init(int contractId, int moduleId, int objectId) {
        super.init(contractId, moduleId, objectId);
        this.resourceSelectPanel.init(moduleId);
    }

    public void setData() throws Exception {
        Request req = new Request();
        req.setModule("load");
        req.setModuleId(this.getModuleId());
        req.setAction("SourceList");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.pointAts.setData(ClientUtils.getList((Node)XMLUtils.selectElement((Node)doc, (String)"/data/list")));
        }
        String objectId = "0";
        if (Utils.parseInt((String)this.id) > 0) {
            req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("ClientItemGet");
            req.setAttribute("id", this.id);
            doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc) && (item = XMLUtils.selectElement((Node)doc, (String)"/data/client_item")) != null) {
                objectId = item.getAttribute("object_id");
                this.alias.setText(item.getAttribute("alias"));
                this.pointNumbers.setText(item.getAttribute("clientNumbers"));
                this.pointNumbers.setEnabled(!item.getAttribute("resource_only").equals("true"));
                this.pointPorts.setText(item.getAttribute("clientPorts"));
                this.pointAts.setSelectedId(Utils.parseInt((String)item.getAttribute("sourceId")));
                this.pointPeriod.setDateString1(item.getAttribute("date1"));
                this.pointPeriod.setDateString2(item.getAttribute("date2"));
                this.pointComment.setText(item.getAttribute("comment"));
            }
        } else {
            req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("ClientItemGet");
            req.setAttribute("id", this.id);
            doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc) && (item = XMLUtils.selectElement((Node)doc, (String)"/data/client_item")) != null) {
                if (item.getAttribute("resource_only").equals("true")) {
                    this.pointNumbers.setEditable(false);
                } else {
                    this.pointNumbers.setEditable(true);
                }
            }
            this.alias.setText("");
            this.pointNumbers.setText("");
            this.pointPorts.setText("");
            this.pointComment.setText("");
            this.pointPeriod.setDateCalendar1((Calendar)new GregorianCalendar());
            this.pointPeriod.setDateCalendar2(null);
        }
        this.buildObjectCombo((JComboBox)this.object_CB, true, objectId);
        this.mainLayout.show((Container)((Object)this), "edit");
        IpPhoneService face = (IpPhoneService)this.getContext().getPort(IpPhoneService.class);
        int ipnMid = face.getIPNModuleId();
        String clazz = "ru.bitel.bgbilling.modules.phone.client.contract.IpListPanel";
        if (ipnMid > 0 && !this.rightPanel.getClass().getName().equals(clazz)) {
            this.rightPanel.remove((Component)((Object)this.ipnPanel));
            try {
                this.ipnPanel = (AbstractIpListPanel)((Object)Utils.newInstance((String)clazz, AbstractIpListPanel.class));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.ipnPanel.setBorder((Border)new BGTitleBorder("\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a ip-\u0430\u0434\u0440\u0435\u0441\u0443 \u043c\u043e\u0434\u0443\u043b\u044f IPN"));
            this.rightPanel.add((Component)((Object)this.ipnPanel), new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.ipnPanel.setItemId(Integer.valueOf(this.id));
        this.ipnPanel.setIpnMid(ipnMid);
        try {
            this.ipnPanel.setData();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        if (ipnMid <= 0) {
            this.ipnPanel.setVisible(false);
        } else {
            this.ipnPanel.setVisible(true);
        }
    }

    public boolean updateData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("ClientItemUpdate");
        request.setContractId(this.getContractId());
        request.setAttribute("id", this.id);
        request.setAttribute("object_id", ClientUtils.getIdFromComboBox(this.object_CB));
        request.setAttribute("type", "1");
        IdTitle item = this.pointAts.getSelected();
        if (item == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a!");
            return false;
        }
        if (!(Utils.notEmptyString((String)this.pointNumbers.getText().trim()) ^ Utils.notEmptyString((String)this.pointPorts.getText().trim()))) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043b\u0438\u0431\u043e \u043f\u043e\u0440\u0442\u044b \u043b\u0438\u0431\u043e \u043d\u043e\u043c\u0435\u0440\u0430!");
            return false;
        }
        request.setAttribute("clientNumbers", this.pointNumbers.getText());
        request.setAttribute("clientPorts", this.pointPorts.getText());
        request.setAttribute("sourceId", item.getId());
        if (Utils.isEmptyString((String)this.pointPeriod.getDateString1())) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
            return false;
        }
        request.setAttribute("date1", this.pointPeriod.getDateString1());
        request.setAttribute("date2", this.pointPeriod.getDateString2());
        request.setAttribute("comment", this.pointComment.getText());
        request.setAttribute("alias", this.alias.getText());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.params.put("objectId", ClientUtils.getIdFromComboBox(this.object_CB));
            this.ipnPanel.setItemId(Integer.valueOf(this.id));
            this.ipnPanel.setDateFrom(this.pointPeriod.getDateFrom());
            this.ipnPanel.setDateTo(this.pointPeriod.getDateTo());
            try {
                this.ipnPanel.update();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return true;
        }
        return false;
    }
}

