/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="CloudPaymentsExecutor", urlPatterns={"/cloudpayments/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_INVOICE_ID = "InvoiceId";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Transaction transaction;
        int moduleId;
        Connection con;
        block5: {
            con = null;
            moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            con = Setup.getSetup().getDBConnectionFromPool();
            String orderNumber = request.getParameter(PARAM_INVOICE_ID);
            transaction = (Transaction)new TransactionManager(con, moduleId).get(Utils.parseInt((String)orderNumber));
            if (transaction != null) break block5;
            this.getLogger().error("Not found transaction for ID = " + orderNumber);
            ServerUtils.closeConnection((Connection)con);
            return;
        }
        try {
            EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
        }
        catch (Exception ex) {
            try {
                this.logError(ex);
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(con);
                throw throwable;
            }
            ServerUtils.closeConnection((Connection)con);
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

