/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots.message;

import bitel.billing.server.contract.bean.ContractModuleManager;
import com.vk.api.sdk.objects.messages.Message;
import java.util.Optional;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagement;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.TelegramRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.VKRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.MessageBuilder;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.TelegramMessageBuilder;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.VKMessageBuilder;
import ru.bitel.bgbilling.modules.botmanager.server.service.BotManagerServiceImpl;
import ru.bitel.common.Utils;

public class ResponseOnMessage
extends BGLogger {
    private MessageBuilder messageBuilder;
    private RuntimeBot runtimeBot;

    public ResponseOnMessage(RuntimeBot runtimeBot) throws Exception {
        this.runtimeBot = runtimeBot;
        this.messageBuilder = this.defineMessageBuilder();
    }

    private MessageBuilder defineMessageBuilder() throws Exception {
        MessageBuilder messageBuilder = null;
        if (this.runtimeBot instanceof TelegramRuntimeBot) {
            messageBuilder = new TelegramMessageBuilder(this.runtimeBot);
        } else if (this.runtimeBot instanceof VKRuntimeBot) {
            messageBuilder = new VKMessageBuilder(this.runtimeBot);
        }
        return messageBuilder;
    }

    public BotApiMethod<?> response(long chatId, String messageText, int messageId) throws Exception {
        return (BotApiMethod)this.responseProcessor(chatId, chatId, messageId, messageText, SendMessage.class);
    }

    public Message response(Integer chatId, long userMessengerId, String messageText) throws Exception {
        return this.responseProcessor(chatId.intValue(), userMessengerId, -1, messageText, Message.class);
    }

    private <T> T responseProcessor(long chatId, long userMessengerId, int messageId, String messageText, Class<T> responseMessageType) throws Exception {
        Object responseMessage = null;
        int contractId = this.runtimeBot.getBotSessions().getOrDefault(chatId, -1);
        StatisticNote statisticNote = new StatisticNote(this.runtimeBot.getBotId(), contractId, userMessengerId);
        Optional<BotDialog> dialogByCommandOpt = this.defineDialogByCommand(messageText);
        if (dialogByCommandOpt.isPresent()) {
            Optional<DialogProcessing> startDialogProcessing;
            BotDialog dialogByCommand = dialogByCommandOpt.get();
            if (this.runtimeBot.getFirstDialog().getId() == dialogByCommand.getId() && (startDialogProcessing = this.messageBuilder.getDialogProcessingImplementation(dialogByCommand)).isPresent()) {
                startDialogProcessing.get().preDialog(this.runtimeBot.getServerContext(), this.runtimeBot.getUserBotData().getData().getOrDefault(chatId, new JSONObject()));
            }
            if (!dialogByCommand.isOnlySignedUser() || contractId > 0) {
                int dialogId = dialogByCommand.getId();
                responseMessage = this.messageBuilder.buildMessage(chatId, messageId, dialogByCommand, responseMessageType);
                this.runtimeBot.getDialogOfChat().put(chatId, dialogId);
                statisticNote.setLastViewedDialogId(dialogId);
            } else {
                this.getLogger().error("\u0414\u0438\u0430\u043b\u043e\u0433: " + dialogByCommand.getId() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0451\u043d \u0434\u043b\u044f \u043d\u0435\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
                responseMessage = this.messageBuilder.buildMessage(chatId, "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u044b", responseMessageType);
                statisticNote.setComment("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435 \u043a \u0434\u0438\u0430\u043b\u043e\u0433\u0443 ID=" + dialogByCommand.getId() + " \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043d\u0435 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d");
            }
            this.updateStatistic(statisticNote);
            return (T)responseMessage;
        }
        BotDialog currentDialog = this.runtimeBot.getDialogByChatId(chatId);
        if (contractId <= 0 && currentDialog == null) {
            responseMessage = this.messageBuilder.buildMessage(chatId, messageId, this.runtimeBot.getFirstDialog(), responseMessageType);
            this.runtimeBot.getDialogOfChat().put(chatId, this.runtimeBot.getFirstDialog().getId());
            statisticNote.setLastViewedDialogId(this.runtimeBot.getFirstDialog().getId());
        } else if (currentDialog != null) {
            int nextDialogId;
            JSONObject chatData = this.runtimeBot.getUserBotData().getData().getOrDefault(chatId, new JSONObject());
            this.runtimeBot.getUserBotData().getData().put(chatId, chatData);
            chatData.put("userChatId", chatId);
            Optional<DialogProcessing> dialogProcessing = this.messageBuilder.getDialogProcessingImplementation(currentDialog);
            if (dialogProcessing.isPresent()) {
                dialogProcessing.get().processDialog(this.runtimeBot.getServerContext(), chatData, messageText);
                int cid = chatData.optInt("contractId", -1);
                if (cid > 0) {
                    this.runtimeBot.getBotSessions().put(chatId, cid);
                }
            }
            this.runtimeBot.updateChatDataToBotSessions(chatId, chatData);
            BotDialog nextDialog = this.messageBuilder.getDialogByPressedButton(currentDialog, messageText);
            if (nextDialog == null && (nextDialogId = chatData.optInt("nextDialogId", -1)) > 0) {
                nextDialog = this.runtimeBot.getBotManagerService().getDialogById(nextDialogId);
            }
            if (nextDialog != null) {
                dialogProcessing = this.messageBuilder.getDialogProcessingImplementation(nextDialog);
                if (dialogProcessing.isPresent()) {
                    dialogProcessing.get().preDialog(this.runtimeBot.getServerContext(), chatData);
                }
                this.messageBuilder.processMacros(nextDialog, chatData);
                if (contractId <= 0 && nextDialog.isOnlySignedUser()) {
                    this.getLogger().error("\u0414\u0438\u0430\u043b\u043e\u0433: " + nextDialog.getId() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0451\u043d \u0434\u043b\u044f \u043d\u0435\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
                    responseMessage = this.messageBuilder.buildMessage(chatId, "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u044b", responseMessageType);
                    statisticNote.setComment("\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0435 \u043a \u0434\u0438\u0430\u043b\u043e\u0433\u0443 ID=" + nextDialog.getId() + " \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043d\u0435 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d");
                } else {
                    responseMessage = this.messageBuilder.buildMessage(chatId, messageId, nextDialog, responseMessageType);
                    this.runtimeBot.getDialogOfChat().put(chatId, nextDialog.getId());
                    statisticNote.setLastViewedDialogId(nextDialog.getId());
                }
            } else if (chatData.has("responseErrorMessage") || chatData.has("textMessage")) {
                String customMessageText = chatData.optString("responseErrorMessage");
                if (Utils.isBlankString((String)customMessageText)) {
                    customMessageText = chatData.optString("textMessage");
                }
                if (Utils.notBlankString((String)customMessageText)) {
                    responseMessage = this.messageBuilder.buildMessage(chatId, customMessageText, responseMessageType);
                    statisticNote.setComment("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435: " + customMessageText);
                }
            }
            this.runtimeBot.clearTemporaryChatData(chatData);
        }
        BotManagement.getOrInitAndGet(this.runtimeBot.getServerContext(), this.runtimeBot.getModuleId()).commitUserBotData(this.runtimeBot);
        if (responseMessage == null) {
            responseMessage = this.messageBuilder.buildErrorMessage(chatId, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0432\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435.");
            statisticNote.setComment("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435");
            this.updateStatistic(statisticNote);
            return (T)responseMessage;
        }
        if (contractId > 0 && !this.checkModuleOnContract(contractId)) {
            if (!this.runtimeBot.isModuleAutoAddOnContract()) {
                responseMessage = this.messageBuilder.buildErrorMessage(chatId, "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0431\u043e\u0442\u0443 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d \u0434\u043b\u044f \u0412\u0430\u0448\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0412\u0430\u0448\u0435\u043c\u0443 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443 \u0434\u043b\u044f \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b");
                statisticNote.setComment("\u041e\u0442\u0432\u0435\u0442 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d. \u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0435\u0442 \u043c\u043e\u0434\u0443\u043b\u044f");
                this.updateStatistic(statisticNote);
                return (T)responseMessage;
            }
            this.addModuleOnContract(contractId);
        }
        this.updateStatistic(statisticNote);
        return (T)responseMessage;
    }

    private void addModuleOnContract(int contractId) throws BGException {
        new ContractModuleManager(this.runtimeBot.getServerContext().getConnection()).addContractModule(contractId, this.runtimeBot.getModuleId());
        this.getLogger().debug("\u041c\u043e\u0434\u0443\u043b\u044c BotManager mid=" + this.runtimeBot.getModuleId() + " \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 contractId=" + contractId);
    }

    private Optional<BotDialog> defineDialogByCommand(String command) throws Exception {
        if (command.equals("/start") || command.equals("start")) {
            return Optional.of(this.runtimeBot.getFirstDialog());
        }
        return Optional.ofNullable(this.runtimeBot.getBotManagerService().getDialogByCommand(command));
    }

    private boolean checkModuleOnContract(int contractId) throws BGException {
        return new ContractModuleManager(this.runtimeBot.getServerContext().getConnection()).getContractModuleSet(contractId).contains(this.runtimeBot.getModuleId());
    }

    private void updateStatistic(StatisticNote statisticNote) {
        if (!this.runtimeBot.isStatisticEnable()) {
            return;
        }
        try {
            ((BotManagerServiceImpl)this.runtimeBot.getBotManagerService()).updateStatisticNote(statisticNote);
        }
        catch (Exception ex) {
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438: " + ex);
        }
    }
}

