/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory.organization;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItem;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItemType;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrganizationAccountManagerPanel;

public class ListTransferHandler
extends TransferHandler {
    private OrganizationAccountManagerPanel panel = null;

    public ListTransferHandler(OrganizationAccountManagerPanel panel) {
        this.panel = panel;
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent source) {
        return this.panel.getList().getSelectedValue();
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
        if (dropLocation == null) {
            return false;
        }
        OrgListItem orgListItem = this.panel.getListModel().get(dropLocation.getIndex());
        return orgListItem.getItemType().equals((Object)OrgListItemType.ORG) && orgListItem.getOrganization().getId() > 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
        if (dropLocation == null) {
            return false;
        }
        Transferable transferable = support.getTransferable();
        try {
            OrgListItem sourceOrgListItem = (OrgListItem)transferable.getTransferData(OrgListItem.ITEM_FLAVOR);
            sourceOrgListItem.getBankAccount().setOrganizationId(this.panel.getListModel().get(dropLocation.getIndex()).getOrganization().getId());
            this.panel.updateBankAccount(sourceOrgListItem.getBankAccount());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return true;
    }
}

