/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.server.load.ProcessIn;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.phone.server.RangeMapCache;
import ru.bitel.bgbilling.modules.phone.server.DataProcess;
import ru.bitel.bgbilling.modules.phone.server.FindItemConveyorContext;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.TariffConveyorEntry;
import ru.bitel.bgbilling.modules.phone.server.bean.CalculateClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemFinder;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.Conveyor;

class FindItemConveyor
extends Conveyor.ConveyorTask<TariffConveyorEntry, FindItemConveyorContext> {
    private static final Logger logger = LogManager.getLogger();
    private final ClientItemFinder itemFinder;
    private final boolean errorOnRulesNotFound;
    private final boolean errorOnManyRules;
    private final boolean errorOnPointNotFound;
    private final boolean storeIncomingSessions;
    private final DataProcess dataProcess;
    private final String lineStart;
    private final ProcessIn processIn;
    private final RangeMapCache rangeMapCache;
    private final List<Integer> contractNoErrorOnManyRules;

    public FindItemConveyor(DefaultServerSetup setup, DataProcess dataProcess, ProcessIn processIn, RangeMapCache rangeMapCache) {
        this.dataProcess = dataProcess;
        this.storeIncomingSessions = dataProcess.storeIncomingSessions;
        this.errorOnRulesNotFound = dataProcess.sourceSetup.getInt("error.on.session.rule.notfound", 0) > 0;
        this.errorOnPointNotFound = dataProcess.sourceSetup.getInt("error.on.session.point.notfound", 0) > 0;
        this.errorOnManyRules = dataProcess.sourceSetup.getInt("error.on.session.rule.many", 0) > 0;
        this.contractNoErrorOnManyRules = dataProcess.sourceSetup.getIntegerList("error.on.session.rule.many.contract.exclude", null);
        this.itemFinder = dataProcess.itemFinder;
        this.lineStart = dataProcess.lineStart;
        this.processIn = processIn;
        this.rangeMapCache = rangeMapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() {
        LogRecord record;
        ArrayList<LogRecord> list = new ArrayList<LogRecord>(20);
        do {
            record = null;
            list.clear();
            ProcessIn processIn = this.processIn;
            synchronized (processIn) {
                for (int i = 0; i < 20 && (record = (LogRecord)this.processIn.getRecord()) != null; ++i) {
                    list.add(record);
                }
            }
            this.dataProcess.count.addAndGet(list.size());
            this.processRecords(list, (FindItemConveyorContext)this.context);
        } while (record != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecords(List<LogRecord> records, FindItemConveyorContext threadContext) {
        for (LogRecord record : records) {
            if (logger.isDebugEnabled()) {
                logger.debug("Process record: " + record.toString());
            }
            CalculateClientItem pointItem = this.itemFinder.findPoint(record, false);
            if (this.dataProcess.cids == null || pointItem != null && this.dataProcess.cids.contains(pointItem.contract.id)) {
                threadContext.processPointRecord(pointItem, record);
            }
            if (this.errorOnPointNotFound && pointItem == null) {
                this.dataProcess.addError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0438\u043d\u0442!", null, record, null);
            }
            List<CalculateClientItem> operRules = this.itemFinder.findRuleList(record, this.rangeMapCache);
            for (CalculateClientItem operItem : operRules) {
                if (this.dataProcess.cids != null && !this.dataProcess.cids.contains(operItem.contract.id)) continue;
                threadContext.processRuleRecord(operItem, record);
            }
            if (this.errorOnRulesNotFound && operRules.size() == 0) {
                this.dataProcess.addError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u043e!", null, record, null);
                continue;
            }
            if (!this.errorOnManyRules || operRules.size() <= 1) continue;
            for (CalculateClientItem operItem : operRules) {
                if (!this.mustErrorOnManyRules(operItem)) continue;
                this.dataProcess.addError("\u0421\u0435\u0441\u0441\u0438\u044f \u043f\u043e\u043f\u0430\u043b\u0430 \u0432 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0430\u0432\u0438\u043b!", operItem, record, null);
            }
        }
        if (this.storeIncomingSessions) {
            StringBuilder incomingSessionBuffer = threadContext.incomingSessionBuffer;
            incomingSessionBuffer.setLength(0);
            for (LogRecord record : records) {
                CalculateClientItem item = this.itemFinder.findPoint(record, true);
                if (item == null || this.dataProcess.cids != null && !this.dataProcess.cids.contains(item.contract.id)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Found point for incoming call " + item.itemId);
                }
                this.dataProcess.clientIncomingSession.incrementAndGet();
                incomingSessionBuffer.append(this.lineStart);
                incomingSessionBuffer.append(String.valueOf(record.id));
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(TimeUtils.format((Calendar)record.sessionStart, (String)"yyyy-MM-dd HH:mm:ss"));
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(String.valueOf(record.sessionTime));
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(record.fromNumber);
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(record.fromNumber164);
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(record.toNumber);
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(record.toNumber164);
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(String.valueOf(item.contract.id));
                incomingSessionBuffer.append('\t');
                incomingSessionBuffer.append(String.valueOf(item.itemId));
                incomingSessionBuffer.append('\n');
            }
            Writer writer = this.dataProcess.incomingSessionWriter;
            synchronized (writer) {
                try {
                    this.dataProcess.incomingSessionWriter.write(incomingSessionBuffer.toString());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean mustErrorOnManyRules(CalculateClientItem operItem) {
        if (this.contractNoErrorOnManyRules == null) {
            return true;
        }
        return !this.contractNoErrorOnManyRules.contains(operItem.contract.id);
    }
}

