/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;

public final class IPFIXDataLogWriter
extends IPDataLogWriter {
    public IPFIXDataLogWriter(IPDataLog dataLog) {
        super(dataLog);
    }

    @Override
    public void writeRecord(ByteBuffer byteBuffer, long time) throws IOException {
        assert (this.writeBuffer.capacity() >= byteBuffer.remaining());
        if (this.writeBuffer.remaining() >= byteBuffer.remaining() + 16) {
            this.writeBuffer.putLong(time);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(byteBuffer.remaining());
            this.writeBuffer.put(byteBuffer);
        } else {
            this.flush();
            if (this.chunkSize > 0) {
                this.nextChunk();
            }
            this.writeBuffer.putLong(time);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(byteBuffer.remaining());
            this.writeBuffer.put(byteBuffer);
        }
    }

    @Override
    public void writeRecord(ByteBuffer byteBuffer, long time, int[] positionArray) throws IOException {
        int position;
        assert (this.writeBuffer.capacity() >= byteBuffer.remaining());
        if (this.writeBuffer.remaining() >= byteBuffer.remaining() + 16) {
            position = this.writeBuffer.position();
            this.writeBuffer.putLong(time);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(byteBuffer.remaining());
            this.writeBuffer.put(byteBuffer);
        } else {
            this.flush();
            if (this.chunkSize > 0) {
                this.nextChunk();
            }
            position = this.writeBuffer.position();
            this.writeBuffer.putLong(time);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(byteBuffer.remaining());
            this.writeBuffer.put(byteBuffer);
        }
        positionArray[0] = this.dataLogId;
        positionArray[1] = this.currentChunkId;
        positionArray[2] = position;
    }
}

