/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMSChapV2Authentificator;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPTLSAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public final class EAPPEAPAuthenticator0<N extends Nas<?, ?, ?>, P>
extends EAPTLSAuthenticator<N, P> {
    private static final Logger logger = LogManager.getLogger();
    public static final byte[] PEAPv0_START_A = new byte[]{32};
    private State state = State.none;
    private EAPAuthenticator<N, P> authenticator = null;

    public EAPPEAPAuthenticator0(EAPSession<N, P> session) {
        super(session);
    }

    @Override
    public EAPMessage start() {
        this.session.identifier = (byte)(this.session.identifier + 1);
        return new EAPMessage(1, this.session.identifier, 25, ByteBuffer.wrap(PEAPv0_START_A));
    }

    @Override
    protected byte tunneledAuthentificating(EAPMessage _eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws Exception {
        int result;
        EAPMessage out;
        byte[] in = this.tunnel.getAppBuffer();
        if (logger.isDebugEnabled()) {
            logger.debug("tunnel in:" + Utils.bytesToString(in));
        }
        EAPMessage eap = in.length > 0 ? new EAPMessage(_eap.code, _eap.identifier, in[0], ByteBuffer.wrap(Arrays.copyOfRange(in, 1, in.length))) : new EAPMessage(_eap.code, _eap.identifier, 0, null);
        block0 : switch (this.state) {
            case auth: {
                if (this.authenticator == null) {
                    this.authenticator = new EAPMSChapV2Authentificator(this.session);
                    out = this.authenticator.start();
                    result = 11;
                    break;
                }
                if (eap.type == this.authenticator.getAuthentificatorType() || eap.type == 2) {
                    out = this.authenticator.authenticate(eap, radiusSession, processor, req, nas, request, response, connectionSet, logRecordId);
                    switch (out.code) {
                        case 1: {
                            result = 11;
                            break block0;
                        }
                        case 3: {
                            this.tunnel.putAppBuffer(EAPMessage.toByteArray((byte)1, this.session.identifier, (byte)33, ByteBuffer.wrap(TLV.tlvResultSuccess)));
                            this.state = State.accepting;
                            return 11;
                        }
                    }
                    this.tunnel.putAppBuffer(this.reject().toByteArray());
                    return 11;
                }
                if (eap.type == 3) {
                    logger.debug("Recieve NAK");
                    out = new EAPMessage(1, this.session.identifier, 33, ByteBuffer.wrap(TLV.tlvResultFailure));
                    this.state = State.rejectingNAK;
                    result = 11;
                    break;
                }
                out = this.reject();
                result = 11;
                break;
            }
            case accepting: {
                boolean success = true;
                int i = in.length - 6;
                int j = 0;
                while (i < in.length) {
                    if (TLV.tlvResultSuccess[j] != in[i]) {
                        success = false;
                        break;
                    }
                    ++i;
                    ++j;
                }
                if (success) {
                    if (this.session != null && this.session.acceptPacket != null) {
                        this.session.acceptPacket.removeAttributes(-1, 79);
                        this.session.acceptPacket.removeAttributes(-1, 80);
                        this.session.acceptPacket.removeAttributes(311, 26);
                        this.session.acceptPacket.removeAttributes(311, 16);
                        this.session.acceptPacket.removeAttributes(311, 17);
                        response.addAttributes(this.session.acceptPacket);
                    }
                    return 2;
                }
                return 3;
            }
            case rejectingNAK: {
                return -1;
            }
            default: {
                logger.debug("Identity request");
                out = new EAPMessage(1, this.session.identifier, 1, null);
                this.state = State.auth;
                result = 11;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("tunnel out: " + Utils.bytesToString(out.toPEAPv0ByteArray()));
        }
        this.tunnel.putAppBuffer(out.toPEAPv0ByteArray());
        return (byte)result;
    }

    private EAPMessage reject() {
        this.session.rejecting();
        return new EAPMessage(1, this.session.identifier, 33, ByteBuffer.wrap(TLV.tlvResultFailure));
    }

    @Override
    public byte getAuthentificatorType() {
        return 25;
    }

    @Override
    public boolean checkPassword(RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
        return this.authenticator.checkPassword(request, response, openPassw, secret, authenticator);
    }

    static enum State {
        none,
        auth,
        accepting,
        rejectingNAK;

    }

    protected static final class TLV {
        public static final byte[] tlvResultSuccess = TLV.getBytesData(true, 3, new byte[]{0, 1});
        public static final byte[] tlvResultFailure = TLV.getBytesData(true, 3, new byte[]{0, 2});
        public final boolean mandatory;
        public final int type;
        public final byte[] value;

        protected TLV(boolean mandatory, int type, byte[] value) {
            this.mandatory = mandatory;
            this.type = type;
            this.value = value;
        }

        public byte[] getBytesData() {
            byte[] result = new byte[this.value.length + 4];
            result[0] = (byte)(this.type >> 8);
            result[1] = (byte)(this.type & 0xFF);
            result[0] = (byte)(result[0] & 0xBF);
            result[0] = this.mandatory ? (byte)(result[0] | 0x80) : (byte)(result[0] & 0x7F);
            result[2] = (byte)(this.value.length >> 8);
            result[3] = (byte)(this.value.length & 0xFF);
            System.arraycopy(this.value, 0, result, 4, this.value.length);
            return result;
        }

        public static byte[] getBytesData(boolean mandatory, int type, byte[] value) {
            byte[] result = new byte[value.length + 4];
            result[0] = (byte)(type >> 8);
            result[1] = (byte)(type & 0xFF);
            result[0] = (byte)(result[0] & 0xBF);
            result[0] = mandatory ? (byte)(result[0] | 0x80) : (byte)(result[0] & 0x7F);
            result[2] = (byte)(value.length >> 8);
            result[3] = (byte)(value.length & 0xFF);
            System.arraycopy(value, 0, result, 4, value.length);
            return result;
        }
    }
}

