/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoLoginManager;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoReplyBuilder;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="trayinfoBalanceSender", urlPatterns={"/balance_sender"})
public class ModuleExecutor
extends CommonExecutor {
    private Setup _setup;
    private Set<Integer> trayinfoMids;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._setup = Setup.getSetup();
        try {
            this.trayinfoMids = new HashSet<Integer>();
            List moduleList = ModuleCache.getInstance().getModulesList("trayinfo");
            for (BGModule module : moduleList) {
                this.trayinfoMids.add(module.getId());
            }
            this.trayinfoMids = Collections.unmodifiableSet(this.trayinfoMids);
        }
        catch (Throwable ex) {
            this.getLogger().error("error init executer", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Element rootNode = null;
        Connection conSlave = null;
        try {
            Document doc = XMLUtils.newDocument();
            rootNode = doc.createElement("data");
            rootNode.setAttribute("status", "ok");
            doc.appendChild(rootNode);
            String charsetXML = req.getParameter("encoding");
            if (Utils.isEmptyString((String)charsetXML)) {
                charsetXML = "UTF-8";
            }
            resp.setContentType("text/xml; charset=" + charsetXML);
            resp.setHeader("cache-control", "no-cache, no-store");
            conSlave = this._setup.getDBSlaveConnectionFromPool();
            String login = req.getParameter("login");
            String pswd = req.getParameter("pswd");
            int mid = Utils.parseInt((String)req.getParameter("mid"), (int)-1);
            if (login != null && pswd != null && mid > 0) {
                if (this.trayinfoMids.contains(mid)) {
                    TrayInfoLoginManager manager = new TrayInfoLoginManager(conSlave, mid);
                    int cid = manager.getCidIsActive(login, pswd);
                    if (cid > 0) {
                        ModuleSetup moduleSetup = new ModuleSetup(conSlave, mid);
                        boolean useSummaReply = moduleSetup != null ? moduleSetup.getInt("use.summa.reply", 1) == 1 : false;
                        String replyBuilderClass = moduleSetup.get("replybuilder");
                        if (replyBuilderClass != null) {
                            TrayInfoReplyBuilder dynReplyBuilder = (TrayInfoReplyBuilder)DynamicClassManager.getInstance().newInstance(TrayInfoReplyBuilder.class, replyBuilderClass);
                            dynReplyBuilder.init(this._setup, conSlave, mid);
                            String reply = dynReplyBuilder.reply(cid);
                            if (reply != null) {
                                XMLUtils.createTextNode((Node)rootNode, (String)reply);
                            } else {
                                this.getLogger().info("No reply for contract cid=" + cid + "!");
                            }
                        }
                        if (useSummaReply) {
                            BalanceUtils bu = new BalanceUtils(conSlave);
                            BigDecimal balance = bu.getBalance(LocalDate.now(), cid);
                            bu.close();
                            rootNode.setAttribute("summa", Utils.formatCost((BigDecimal)balance));
                        }
                    } else {
                        ModuleExecutor.setErrorStatus((HttpServletRequest)req, (Element)rootNode, (String)"Invalid PIN1 or PIN2!");
                    }
                } else {
                    ModuleExecutor.setErrorStatus((HttpServletRequest)req, (Element)rootNode, (String)"Invalid mid!");
                }
            } else {
                ModuleExecutor.setErrorStatus((HttpServletRequest)req, (Element)rootNode, (String)"Not all parameters was recived!");
            }
            XMLUtils.serialize((Node)doc.getDocumentElement(), (Result)new StreamResult((OutputStream)resp.getOutputStream()), (String)charsetXML, (boolean)true);
            ServerUtils.closeConnection((Connection)conSlave);
        }
        catch (Exception ex) {
            ModuleExecutor.setErrorStatus((HttpServletRequest)req, (Element)rootNode, (String)ex.getLocalizedMessage());
            this.getLogger().error("error executer", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(conSlave);
        }
    }

    protected boolean checkUser(HttpServletRequest request, Element rootNode, Connection con) {
        return false;
    }
}

