/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Operator;

public abstract class Report
extends BGLogger {
    protected Operator oper;
    protected Date month;
    private int id;
    protected static Map<String, JasperReport> cache = new HashMap<String, JasperReport>();

    public Report(Operator operator, Date month, int id) {
        this.oper = operator;
        this.month = month;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public abstract String getTitle();

    public abstract String getFileName();

    public abstract int getType();

    public abstract void getData(Connection var1, OutputStream var2);

    protected JasperReport getJasperReport(String templatePath) throws JRException {
        InputStream is;
        JasperReport report = null;
        if (this.oper.getModuleSetup().getInt("oper.report.cache", 0) == 1) {
            report = cache.get(templatePath);
        }
        if (report == null && (is = Report.class.getResourceAsStream(templatePath)) != null) {
            JasperDesign design = JRXmlLoader.load((InputStream)is);
            report = JasperCompileManager.compileReport((JasperDesign)design);
            cache.put(templatePath, report);
        }
        return report;
    }

    protected void sendJasperReport(Connection con, String templatePath, OutputStream out) {
        try {
            JasperReport report = this.getJasperReport(templatePath);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("oper", (Object)this.oper);
            params.put("operSetup", this.oper.getOperatorSetup());
            params.put("month", this.month);
            BGReportTemplate.fillReportToStream((JasperReport)report, (BGReportFilter)new BGReportFilter(params, 0), (Connection)con, (OutputStream)out);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

