/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.xcrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.xcrypt.ByteDeserializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.xcrypt.ByteSerializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.xcrypt.XcryptException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class XcryptCon
extends BGLogger {
    private String host;
    private int port;
    private int timeout;
    private int client_id;
    private String zip_code = "00000000";
    private boolean emailEnable;
    private boolean emailGroupEnable;
    private Charset emailCharset;
    private int emailBroadcastPeriod = 1;
    private int emailPriority = 0;
    private int subscribeBroadcastPeriod = 1;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private long data_channel_id = -1L;
    private List<SubscriptionInfo> response_0x0070;

    public XcryptCon(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 7000);
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined!");
        }
        this.timeout = preferences.getInt("timeout", 30000);
        this.client_id = preferences.getInt("client_id", 1);
        this.zip_code = preferences.get("zip_code", this.zip_code);
        this.emailEnable = preferences.getBoolean("emailEnable", false);
        this.emailGroupEnable = preferences.getBoolean("emailGroupEnable", false);
        this.emailCharset = Charset.forName(preferences.get("emailCharset", "utf-8"));
        this.emailBroadcastPeriod = preferences.getInt("emailBroadcastPeriod", this.emailBroadcastPeriod);
        this.emailPriority = preferences.getInt("emailPriority", this.emailPriority);
        this.subscribeBroadcastPeriod = preferences.getInt("subscribeBroadcastPeriod", this.subscribeBroadcastPeriod);
    }

    private void sendRequest(int cmd_message_type, int command_id, byte[] request, long cardNumber) throws BGException, IOException {
        this.$trace("  sendRequest: message_type=0x%04X, command_id=%s, request=%s", cmd_message_type, command_id != -1 ? Integer.valueOf(command_id) : "no", Utils.bytesToString((byte[])request));
        this.os.write(request);
        this.os.flush();
        this.$trace("  -> packet: %s", Utils.bytesToString((byte[])request));
        if (cmd_message_type == 4100) {
            this.$trace("  no wait body", new Object[0]);
            return;
        }
        long t = System.currentTimeMillis();
        while (this.is.available() == 0) {
            if (System.currentTimeMillis() - t <= (long)this.timeout) continue;
            throw new IOException("error timeout " + this.timeout + "ms wait reply to command");
        }
        ArrayList<XcryptException> errors = new ArrayList<XcryptException>();
        while (this.is.available() > 0) {
            byte[] responseHeader = new byte[4];
            Utils.readFullBuffer((InputStream)this.is, (byte[])responseHeader);
            this.$trace("  <- header: %s", Utils.bytesToString((byte[])responseHeader));
            ByteDeserializer bd = new ByteDeserializer(responseHeader);
            int message_type = bd.getInt(2);
            int length = bd.getInt(2);
            this.$trace("   message_type=0x%04X, length=%d", message_type, length);
            byte[] body = null;
            if (length > 0) {
                body = new byte[length];
                Utils.readFullBuffer((InputStream)this.is, (byte[])body);
                this.$trace("  <- body: %s", Utils.bytesToString((byte[])body));
            }
            int error_status = -1;
            XcryptException ex = null;
            if (body == null) continue;
            switch (message_type) {
                case 4098: {
                    this.$trace("   receive channel test message, channel_status will be sent...", new Object[0]);
                    this.channel_status();
                    break;
                }
                case 4099: {
                    this.$trace("   receive channel status message", new Object[0]);
                    break;
                }
                case 4101: {
                    this.$trace("   receive channel error message", new Object[0]);
                    error_status = this.read_channel_error_body(body);
                    if (error_status != 0) {
                        ex = new XcryptException(cmd_message_type, command_id, error_status, -1L);
                        this.$trace("   detect error: %s", ex.getMessage());
                        errors.add(ex);
                        break;
                    }
                    this.$trace("   detect no error", new Object[0]);
                    break;
                }
                case 4113: {
                    this.$trace("   receive subscriber data response message", new Object[0]);
                    error_status = this.read_subscriber_data_response_body(body);
                    if (error_status != 0) {
                        ex = new XcryptException(cmd_message_type, command_id, error_status, -1L);
                        this.$trace("   detect error: %s", ex.getMessage());
                        errors.add(ex);
                        break;
                    }
                    this.$trace("   detect no error", new Object[0]);
                    break;
                }
                case 4128: {
                    this.$trace("   receive SAS response message", new Object[0]);
                    this.read_SAS_response_body(body);
                }
            }
        }
        if (!errors.isEmpty()) {
            this.$trace("  sendRequest receive %s errors, throw first", errors.size());
            throw (XcryptException)((Object)errors.get(0));
        }
    }

    public void connect() throws IOException, BGException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.timeout);
        this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
        this.os = this.socket.getOutputStream();
        this.is = this.socket.getInputStream();
    }

    public void disconnect() throws IOException {
        this.is.close();
        this.is = null;
        this.os.close();
        this.os = null;
        this.socket.close();
        this.socket = null;
    }

    public void tuneconnect(XcryptCon newconnect) throws IOException, BGException {
        if (!this.host.equals(newconnect.host) || this.port != newconnect.port) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u043f\u0435\u0440\u0435\u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0442\u044c host \u0438 port");
        }
        if (this.timeout != newconnect.timeout) {
            this.socket.setSoTimeout(newconnect.timeout);
        }
        this.client_id = newconnect.client_id;
        this.zip_code = newconnect.zip_code;
        this.emailEnable = newconnect.emailEnable;
        this.emailGroupEnable = newconnect.emailGroupEnable;
        this.emailCharset = newconnect.emailCharset;
        this.emailBroadcastPeriod = newconnect.emailBroadcastPeriod;
        this.emailPriority = newconnect.emailPriority;
        this.subscribeBroadcastPeriod = newconnect.subscribeBroadcastPeriod;
    }

    private void $trace(String format, Object ... args) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("XcryptCon: " + String.format(format, args));
        }
    }

    private long generateChannelId() {
        return System.currentTimeMillis();
    }

    public void channel_setup() throws BGException, IOException {
        this.data_channel_id = this.generateChannelId();
        this.$trace("channel_setup: data_channel_id=%s", this.data_channel_id);
        ByteSerializer bd = new ByteSerializer(12);
        bd.put(4097, 2);
        bd.put(8, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        this.sendRequest(4097, -1, bd.getBuffer(), -1L);
    }

    public void channel_test() throws BGException, IOException {
        this.$trace("channel_test: data_channel_id=%s", this.data_channel_id);
        ByteSerializer bd = new ByteSerializer(12);
        bd.put(4098, 2);
        bd.put(8, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        this.sendRequest(4098, -1, bd.getBuffer(), -1L);
    }

    public void channel_status() throws BGException, IOException {
        this.$trace("channel_status: data_channel_id=%s", this.data_channel_id);
        ByteSerializer bd = new ByteSerializer(12);
        bd.put(4099, 2);
        bd.put(8, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        this.sendRequest(4099, -1, bd.getBuffer(), -1L);
    }

    public void channel_close() throws BGException, IOException {
        this.$trace("channel_close: data_channel_id=%s", this.data_channel_id);
        ByteSerializer bd = new ByteSerializer(12);
        bd.put(4100, 2);
        bd.put(8, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        this.sendRequest(4100, -1, bd.getBuffer(), -1L);
    }

    public void channel_error(int error_status) throws BGException, IOException {
        this.$trace("channel_error: data_channel_id=%s", this.data_channel_id);
        ByteSerializer bd = new ByteSerializer(14);
        bd.put(4101, 2);
        bd.put(10, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        bd.put(error_status, 2);
        this.sendRequest(4101, -1, bd.getBuffer(), -1L);
    }

    public int read_channel_error_body(byte[] buffer) throws BGException, IOException {
        ByteDeserializer bd = new ByteDeserializer(buffer);
        bd.getLong(4);
        bd.getLong(4);
        int error_status = bd.getInt(2);
        return error_status;
    }

    public int read_subscriber_data_response_body(byte[] buffer) throws BGException, IOException {
        ByteDeserializer bd = new ByteDeserializer(buffer);
        bd.getLong(4);
        bd.getLong(4);
        bd.getLong(4);
        int error_status = bd.getInt(2);
        return error_status;
    }

    public void read_SAS_response_body(byte[] buffer) throws BGException, IOException {
        ByteDeserializer bd = new ByteDeserializer(buffer);
        bd.getLong(4);
        bd.getLong(4);
        bd.getLong(4);
        int command_id = bd.getInt(2);
        int data_length = bd.getInt(2);
        if (data_length != bd.available()) {
            throw new BGException("SAS_response_body: data_length=" + data_length + "; packet data=" + bd.available());
        }
        if (command_id != 112) {
            throw new BGException("SAS_response_body: unknown command_id=" + command_id);
        }
        this.read_SAS_response_0x0070(bd.getBytes());
    }

    private void read_SAS_response_0x0070(byte[] response_data) {
        this.$trace("read_SAS_response_0x0070: response_data=%s", Utils.bytesToString((byte[])response_data));
        ByteDeserializer bd = new ByteDeserializer(response_data);
        this.response_0x0070 = new ArrayList<SubscriptionInfo>();
        long smartcard_no = bd.getLong(8);
        String CA_Dev_ID = bd.getString(8);
        String zip_code = bd.getString(8);
        for (int N = 0; N < 32; ++N) {
            LocalDate term_date = bd.getDTF32();
            if (term_date == null) continue;
            this.response_0x0070.add(new SubscriptionInfo(smartcard_no, CA_Dev_ID, zip_code, N, term_date));
        }
    }

    public void subscriber_data_provision_message(byte[] command, int command_id) throws BGException, IOException {
        this.$trace("subscriber_data_provision_message: command_id=0x%04X, command=%s", command_id, Utils.bytesToString((byte[])command));
        ByteSerializer bd = new ByteSerializer(16 + command.length);
        bd.put(4112, 2);
        bd.put(12 + command.length, 2);
        bd.put(this.client_id, 4);
        bd.put(this.data_channel_id, 4);
        bd.put(this.generateChannelId(), 4);
        bd.put(command);
        this.sendRequest(4112, command_id, bd.getBuffer(), -1L);
    }

    private void _command_first7field(ByteSerializer bd, int command_id, int broadcast_period, long smartcard_no, String CA_Dev_ID) {
        bd.put(command_id, 2);
        bd.putDTF(new Date());
        bd.putDTF(new Date());
        bd.put(broadcast_period, 2);
        bd.put(smartcard_no, 8);
        bd.putascii(CA_Dev_ID, 8);
        bd.putascii(this.zip_code, 8);
    }

    public void command_mail(long smartcard_no, String CA_Dev_ID, String message) throws BGException, IOException {
        this.$trace("command_mail: smartcard_no=%s CA_Dev_ID=%s message=%s (emailEnable=%b)", smartcard_no, CA_Dev_ID, message, this.emailEnable);
        if (this.emailEnable) {
            ByteSerializer bd = new ByteSerializer(666 + message.length());
            this._command_first7field(bd, 259, this.emailBroadcastPeriod, smartcard_no, CA_Dev_ID);
            bd.put(this.generateChannelId(), 2);
            bd.put(this.emailPriority, 1);
            bd.put(ByteSerializer.getStrBytesLen(message, this.emailCharset), 2);
            bd.put(message, this.emailCharset);
            this.subscriber_data_provision_message(bd.getBuffer(), 259);
        }
    }

    public void command_group_mail(String message) throws BGException, IOException {
        this.$trace("command_group_mail: message=%s (emailGroupEnable=%b)", message, this.emailGroupEnable);
        if (this.emailGroupEnable) {
            ByteSerializer bd = new ByteSerializer(666 + message.length());
            this._command_first7field(bd, 275, this.emailBroadcastPeriod, 0L, "");
            bd.put(1, 1);
            bd.put(this.generateChannelId(), 2);
            bd.put(this.emailPriority, 1);
            bd.put(ByteSerializer.getStrBytesLen(message, this.emailCharset), 2);
            bd.put(message, this.emailCharset);
            this.subscriber_data_provision_message(bd.getBuffer(), 275);
        }
    }

    public List<SubscriptionInfo> command_get_subscribers_information(long smartcard_no) throws BGException, IOException {
        this.$trace("command_get_subscribers_information: smartcard_no=%s", smartcard_no);
        ByteSerializer bd = new ByteSerializer(666);
        this._command_first7field(bd, 112, 0, smartcard_no, "");
        this.response_0x0070 = null;
        this.subscriber_data_provision_message(bd.getBuffer(), 112);
        return this.response_0x0070;
    }

    public void _command_51_54_57(int _command, long smartcard_no, String CA_Dev_ID, List<SubscriptionInfo> entitlements) throws BGException, IOException {
        ByteSerializer bd = new ByteSerializer(666);
        this._command_first7field(bd, _command, this.subscribeBroadcastPeriod, smartcard_no, CA_Dev_ID);
        bd.put(entitlements.size(), 1);
        for (SubscriptionInfo entitlement : entitlements) {
            bd.put(entitlement.product_group, 1);
            bd.putDTF32(entitlement.term_date);
        }
        this.subscriber_data_provision_message(bd.getBuffer(), _command);
    }

    public void command_subscription_creation(long smartcard_no, String CA_Dev_ID, List<SubscriptionInfo> entitlements) throws BGException, IOException {
        this.$trace("command_subscription_creation: smartcard_no=%s", smartcard_no);
        this._command_51_54_57(16, smartcard_no, CA_Dev_ID, entitlements);
    }

    public void command_adding_of_product(long smartcard_no, String CA_Dev_ID, List<SubscriptionInfo> entitlements) throws BGException, IOException {
        this.$trace("command_adding_of_product: smartcard_no=%s", smartcard_no);
        this._command_51_54_57(19, smartcard_no, CA_Dev_ID, entitlements);
    }

    public void command_product_cancellation(long smartcard_no, String CA_Dev_ID, List<SubscriptionInfo> entitlements) throws BGException, IOException {
        this.$trace("command_product_cancellation: smartcard_no=%s", smartcard_no);
        this._command_51_54_57(22, smartcard_no, CA_Dev_ID, entitlements);
    }

    public void command_subscription_termination(long smartcard_no, String CA_Dev_ID) throws BGException, IOException {
        this.$trace("command_subscription_termination: smartcard_no=%s", smartcard_no);
        ByteSerializer bd = new ByteSerializer(666);
        this._command_first7field(bd, 64, this.subscribeBroadcastPeriod, smartcard_no, CA_Dev_ID);
        this.subscriber_data_provision_message(bd.getBuffer(), 64);
    }

    public static class SubscriptionInfo {
        public long smartcard_no;
        public String CA_Dev_ID;
        public String zip_code;
        public int product_group;
        public LocalDate term_date;

        public SubscriptionInfo(long smartcard_no, String CA_Dev_ID, String zip_code, int product_group, LocalDate term_date) {
            this.smartcard_no = smartcard_no;
            this.CA_Dev_ID = CA_Dev_ID;
            this.zip_code = zip_code;
            this.product_group = product_group;
            this.term_date = term_date;
        }

        public static String getHeader() {
            return "smartcard_no | CA_Dev_ID | zip_code | product_group | term_date";
        }

        public String toString() {
            return String.format("%s | %s | %s | %s | %s", this.smartcard_no, this.CA_Dev_ID, this.zip_code, this.product_group, this.term_date);
        }
    }
}

