/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.bean;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailConfigDao;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.Setup;

public class MailConfigCache
extends BGLogger {
    private static Map<String, MailConfig> mailConfigCacheMap = null;

    public MailConfig getMailConfig(String componentId, int moduleId, String key) {
        return this.getMailConfigCacheMap().get(componentId + "_" + moduleId + "_" + key);
    }

    public void resetCache() {
        mailConfigCacheMap = null;
    }

    private Map<String, MailConfig> getMailConfigCacheMap() {
        if (mailConfigCacheMap == null) {
            HashMap<String, MailConfig> map = new HashMap<String, MailConfig>();
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                new MailConfigDao(con).list().forEach(a -> map.put(a.getComponentId() + "_" + a.getModuleId() + "_" + a.getKey(), (MailConfig)a));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            mailConfigCacheMap = map;
        }
        return mailConfigCacheMap;
    }
}

