/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.modules.subscription.common.bean.ValueUnit;
import ru.bitel.bgbilling.modules.subscription.common.event.SubscriptionTypeModifiedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.xml.JAXBUtils;

@DirectoryItem(eventClass=SubscriptionTypeModifiedEvent.class)
@XmlRootElement(name="subscriptionType")
public class SubscriptionType
extends IdTitle {
    private int serviceId;
    private String comment;
    private Period period;
    private ValueUnit duration = null;
    private ValueUnit delay = null;
    private ValueUnit round = null;
    private boolean avtoCommit = false;
    private String config = null;

    @XmlAttribute
    public int getServiceId() {
        return this.serviceId;
    }

    public SubscriptionType setServiceId(int serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public SubscriptionType setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.PeriodAdapter.class)
    public Period getPeriod() {
        return this.period;
    }

    public SubscriptionType setPeriod(Period period) {
        this.period = period;
        return this;
    }

    @XmlElement
    public ValueUnit getDuration() {
        return this.duration;
    }

    public SubscriptionType setDuration(ValueUnit duration) {
        this.duration = duration;
        return this;
    }

    @XmlElement
    public ValueUnit getDelay() {
        return this.delay;
    }

    public SubscriptionType setDelay(ValueUnit delay) {
        this.delay = delay;
        return this;
    }

    @XmlElement
    public ValueUnit getRound() {
        return this.round;
    }

    public SubscriptionType setRound(ValueUnit round) {
        this.round = round;
        return this;
    }

    @XmlAttribute
    public boolean isAvtoCommit() {
        return this.avtoCommit;
    }

    public SubscriptionType setAvtoCommit(boolean avtoCommit) {
        this.avtoCommit = avtoCommit;
        return this;
    }

    @XmlAttribute
    public String getConfig() {
        return this.config;
    }

    public SubscriptionType setConfig(String config) {
        this.config = config;
        return this;
    }

    public PeriodWithTime getNewRegistrationPeriod(Date initDate) {
        PeriodWithTime result = null;
        GregorianCalendar fromCalendar = new GregorianCalendar();
        if (initDate != null) {
            fromCalendar.setTime(initDate);
        }
        if (this.delay != null) {
            switch (this.delay.getUnit()) {
                case SECOND: {
                    ((Calendar)fromCalendar).add(13, (int)this.delay.getValue());
                    break;
                }
                case MINUTE: {
                    ((Calendar)fromCalendar).add(12, (int)this.delay.getValue());
                    break;
                }
                case HOUR: {
                    ((Calendar)fromCalendar).add(11, (int)this.delay.getValue());
                    break;
                }
                case DAY: {
                    ((Calendar)fromCalendar).add(5, (int)this.delay.getValue());
                    break;
                }
                case WEEK: {
                    ((Calendar)fromCalendar).add(3, (int)this.delay.getValue());
                    break;
                }
                case MONTH: {
                    ((Calendar)fromCalendar).add(2, (int)this.delay.getValue());
                    break;
                }
                case YEAR: {
                    ((Calendar)fromCalendar).add(1, (int)this.delay.getValue());
                    break;
                }
            }
        }
        if (this.round != null) {
            int value = 0;
            switch (this.round.getUnit()) {
                case SECOND: {
                    value = fromCalendar.get(13);
                    fromCalendar.set(13, value - value % (int)this.round.getValue());
                    fromCalendar.set(14, 0);
                    break;
                }
                case MINUTE: {
                    value = fromCalendar.get(12);
                    fromCalendar.set(12, value - value % (int)this.round.getValue());
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
                case HOUR: {
                    value = fromCalendar.get(11);
                    fromCalendar.set(11, value - value % (int)this.round.getValue());
                    fromCalendar.set(12, 0);
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
                case DAY: {
                    value = fromCalendar.get(5);
                    fromCalendar.set(5, value - value % (int)this.round.getValue());
                    fromCalendar.set(11, 0);
                    fromCalendar.set(12, 0);
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
                case WEEK: {
                    value = fromCalendar.get(3);
                    fromCalendar.set(3, value - value % (int)this.round.getValue());
                    fromCalendar.set(7, 2);
                    fromCalendar.set(11, 0);
                    fromCalendar.set(12, 0);
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
                case MONTH: {
                    value = fromCalendar.get(2);
                    fromCalendar.set(2, value - value % (int)this.round.getValue());
                    fromCalendar.set(5, 1);
                    fromCalendar.set(11, 0);
                    fromCalendar.set(12, 0);
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
                case YEAR: {
                    value = fromCalendar.get(1);
                    fromCalendar.set(1, value - value % (int)this.round.getValue());
                    fromCalendar.set(6, 1);
                    fromCalendar.set(11, 0);
                    fromCalendar.set(12, 0);
                    fromCalendar.set(13, 0);
                    fromCalendar.set(14, 0);
                    break;
                }
            }
        }
        if (this.duration != null) {
            result = new PeriodWithTime();
            result.setLocalDateTimeFrom(TimeUtils.convertDateToLocalDateTime((Date)fromCalendar.getTime()));
            switch (this.duration.getUnit()) {
                case SECOND: {
                    ((Calendar)fromCalendar).add(13, (int)this.duration.getValue());
                    break;
                }
                case MINUTE: {
                    ((Calendar)fromCalendar).add(12, (int)this.duration.getValue());
                    break;
                }
                case HOUR: {
                    ((Calendar)fromCalendar).add(11, (int)this.duration.getValue());
                    break;
                }
                case DAY: {
                    ((Calendar)fromCalendar).add(5, (int)this.duration.getValue());
                    break;
                }
                case WEEK: {
                    ((Calendar)fromCalendar).add(3, (int)this.duration.getValue());
                    break;
                }
                case MONTH: {
                    ((Calendar)fromCalendar).add(2, (int)this.duration.getValue());
                    break;
                }
                case YEAR: {
                    ((Calendar)fromCalendar).add(1, (int)this.duration.getValue());
                    break;
                }
            }
            result.setLocalDateTimeTo(TimeUtils.convertDateToLocalDateTime((Date)fromCalendar.getTime()));
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SubscriptionType type = new SubscriptionType();

        private Builder() {
        }

        public Builder setId(int value) {
            this.type.id = value;
            return this;
        }

        public Builder setServiceId(int serviceId) {
            this.type.serviceId = serviceId;
            return this;
        }

        public Builder setTitle(String title) {
            this.type.title = title;
            return this;
        }

        public Builder setComment(String comment) {
            this.type.comment = comment;
            return this;
        }

        public Builder setPeriod(Period period) {
            this.type.period = period;
            return this;
        }

        public Builder setDuration(ValueUnit duration) {
            this.type.duration = duration;
            return this;
        }

        public Builder setDelay(ValueUnit delay) {
            this.type.delay = delay;
            return this;
        }

        public Builder setRound(ValueUnit round) {
            this.type.round = round;
            return this;
        }

        public Builder setAvtoCommit(boolean avtoCommit) {
            this.type.avtoCommit = avtoCommit;
            return this;
        }

        public Builder setConfig(String config) {
            this.type.config = config;
            return this;
        }

        public SubscriptionType build() {
            try {
                SubscriptionType subscriptionType = this.type;
                return subscriptionType;
            }
            finally {
                this.type = null;
            }
        }
    }
}

