/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FakeSerialPort;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class DeviceSerialPort
extends BGLogger {
    private SerialParameters portParam;
    private SerialPort serialPort;
    private int timeout;

    public DeviceSerialPort(SerialParameters portParam) {
        this.portParam = portParam;
    }

    protected void _open() throws SerialPortException {
        this.serialPort = new SerialPort(this.portParam.getPortName());
        this.serialPort.openPort();
        this.serialPort.setParams(this.portParam.getBaudRate(), this.portParam.getDatabits(), this.portParam.getStopbits(), this.portParam.getParity());
    }

    protected void _open_fake(String hexBytes) {
        this.serialPort = new FakeSerialPort(hexBytes);
    }

    protected void _close() throws SerialPortException {
        if (this.serialPort != null) {
            this.serialPort.closePort();
        }
    }

    protected void _send(BGByteBuffer buffer) throws SerialPortException {
        if (buffer != null && buffer.getBytes().length > 0) {
            this.serialPort.writeBytes(buffer.getBytes());
        }
    }

    protected void _send(byte b) throws SerialPortException {
        this.serialPort.writeByte(b);
    }

    protected void _setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected BGByteBuffer _recv_all() throws SerialPortException {
        BGByteBuffer ret = new BGByteBuffer();
        try {
            while (true) {
                byte[] b = this.serialPort.readBytes(1, this.timeout);
                ret.pushEnd(b, b.length);
            }
        }
        catch (SerialPortTimeoutException e) {
            return ret;
        }
    }

    protected int _recv() throws SerialPortException {
        try {
            byte[] b = this.serialPort.readBytes(1, this.timeout);
            return b[0] & 0xFF;
        }
        catch (SerialPortTimeoutException e) {
            return -1;
        }
    }

    protected BGByteBuffer _recv(int len) throws SerialPortException {
        try {
            return new BGByteBuffer(this.serialPort.readBytes(len, this.timeout));
        }
        catch (SerialPortTimeoutException e) {
            return null;
        }
    }
}

