/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHosting;
import ru.bitel.common.Utils;

public class CPHostingManager {
    private Connection con;
    private String tableName;

    public CPHostingManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_cp_hosting_" + mid;
    }

    public CPHosting getHosting(int cpid) {
        CPHosting result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE cpid=?");
            ps.setInt(1, cpid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getHdServiceHostingFromRS(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private CPHosting getHdServiceHostingFromRS(ResultSet rs) throws SQLException {
        CPHosting result = new CPHosting();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setData(rs.getString("data"));
        result.setHostList(Utils.toList((String)rs.getString("host_name")));
        return result;
    }

    public List<CPHosting> getHostingList() {
        ArrayList<CPHosting> result = new ArrayList<CPHosting>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName);
            if (rs.next()) {
                result.add(this.getHdServiceHostingFromRS(rs));
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteHosting(int contractPackageId) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractPackageId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateHosting(CPHosting hosting) {
        try {
            this.deleteHosting(hosting.getContractPackageId());
            String query = null;
            query = "INSERT INTO " + this.tableName + " (cpid, data, host_name) VALUES (?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, hosting.getContractPackageId());
            ps.setString(2, hosting.getData());
            ps.setString(3, Utils.toString(hosting.getHostList()));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

