package ru.bitel.bgbilling.modules.paymaster.dyn;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.CSVFillerData;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.ReportResult;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class PaymasterReestrReport
    implements CSVFillerData
{
    @Override
    public void fillReport( Connection con, BGReportFilter filter, ReportResult result )
        throws Exception
    {
        int mid = filter.getIntParam( "mid" );
        List<Map<String, String>> fields = new ArrayList<>( 100 );
        
        String periodFrom = filter.getStringParam( "date1" );
        if ( Utils.isEmptyString( periodFrom ) )
        {
            Map<String, String> map = new HashMap<>();
            map.put( "date", "Укажите начало периода" );
            fields.add( map );
            result.setData( fields );
            return;
        }

        String periodTo = filter.getStringParam( "date2" );
        if ( Utils.isEmptyString( periodTo ) )
        {
            Map<String, String> map = new HashMap<>();
            map.put( "date", "Укажите конец периода" );
            fields.add( map );
            result.setData( fields );
            return;
        }
        
        DecimalFormat decimalFormatId = new DecimalFormat( "###,###,##0" );
        DecimalFormat decimalFormatSum = new DecimalFormat( "###,###,##0.00" );
        SimpleDateFormat dateFormat = new SimpleDateFormat( "dd.MM.yyyy" );
        Period period = new Period( dateFormat.parse( periodFrom ), dateFormat.parse( periodTo ) );

        int count = 0;
        BigDecimal sum = BigDecimal.ZERO;
        String query = "select t.id, t.payment_date, c.title, t.sum from paymaster_transaction_" + mid + " as t left join contract as c on c.id=t.contract_id where t.status='pay' AND t.payment_date>=? AND t.payment_date<?";
        PreparedStatement ps = con.prepareStatement( query );
        ps.setDate( 1, TimeUtils.convertDateToSqlDate( period.getDateFrom() ) );
        ps.setDate( 2, TimeUtils.convertDateToSqlDate( TimeUtils.getNextDay( period.getDateTo() ) ) );
        ResultSet rs = ps.executeQuery();
        while ( rs.next() )
        {
            BigDecimal tSum =rs.getBigDecimal( "t.sum" );
            sum = sum.add( tSum );
            count++;
            
            Map<String, String> map = new HashMap<>();
            map.put( "transactionId", decimalFormatId.format( rs.getInt( "t.id" ) ) );
            map.put( "date", dateFormat.format( rs.getDate( "t.payment_date" ) ) );
            map.put( "contractTitle", rs.getString( "c.title" ) );
            map.put( "sum", decimalFormatSum.format( tSum ) );
            fields.add( map );
        }
        rs.close();
        ps.close();

        Map<String, String> map = new HashMap<>();
        map.put( "transactionId", "Всего транзакций: " + decimalFormatId.format( count ) );
        map.put( "sum", "Итого: " + decimalFormatSum.format( sum ) );
        fields.add( map );
        
        result.setData( fields );
    }
}
