/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantMasterDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class AssistantActionDao
extends AbstractIdDao<AssistantAction> {
    private static final String TABLE_ASSISTANT_ACTION_USER_GROUP = "assistant_action_user_role";

    public AssistantActionDao(Connection con) {
        super(con, 0, "assistant_action");
    }

    public List<AssistantActionItem> assistantActions(int masterId) throws SQLException {
        ArrayList<AssistantActionItem> list = new ArrayList<AssistantActionItem>();
        String query = "SELECT id, action_id, title, dependent, sort FROM " + this.tableName + " WHERE `dependent`=? ORDER BY `title`";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            psSelect.setInt(1, masterId);
            try (ResultSet resultSet = psSelect.executeQuery();){
                while (resultSet.next()) {
                    AssistantActionItem item = AssistantActionItem.builder().setId(resultSet.getInt("id")).setActionId(resultSet.getString("action_id")).setTitle(resultSet.getString("title")).setDependent(resultSet.getInt("dependent")).setSort(resultSet.getInt("sort")).build();
                    list.add(item);
                }
            }
        }
        return list;
    }

    public void updateSortListAssistantAction(List<AssistantActionItem> assistantActions) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET sort=? WHERE id=?";
        try (PreparedStatement preparedStatement = this.con.prepareStatement(query);){
            for (AssistantActionItem assistantAction : assistantActions) {
                preparedStatement.setInt(1, assistantAction.getSort());
                preparedStatement.setInt(2, assistantAction.getId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    public List<Integer> checkActionIds(int masterId, List<Integer> actionIds) throws SQLException {
        ResultSet rs;
        ArrayList<Integer> outIds = new ArrayList<Integer>();
        if (actionIds == null || actionIds.isEmpty()) {
            return outIds;
        }
        String query = "SELECT id FROM " + this.tableName + " WHERE id IN ( " + Utils.toString(actionIds) + " )";
        try (Statement statement = this.con.createStatement();){
            rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    outIds.add(rs.getInt(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT id FROM " + this.tableName + " WHERE `dependent`=" + masterId;
        statement = this.con.createStatement();
        try {
            rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    if (outIds.contains(id)) continue;
                    outIds.add(id);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return outIds;
    }

    public List<AssistantActionItem> assistantActions(int masterId, int userId) throws SQLException {
        Optional roleOpt = PermissionOfRoles.getRoleByUserId((int)userId);
        if (roleOpt.isEmpty()) {
            throw new BGRuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0443\u044e \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 ID=" + userId);
        }
        ArrayList<Integer> roleIds = new ArrayList<Integer>();
        Role role = (Role)roleOpt.get();
        roleIds.add(role.getId());
        if (Utils.notEmptyCollection((Collection)role.getChildren())) {
            roleIds.addAll(role.getChildren().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()));
        }
        if (masterId > 0) {
            AssistantMaster assistantMaster = (AssistantMaster)new AssistantMasterDao(this.con).get(masterId);
            if (assistantMaster == null) {
                throw new BGRuntimeException("\u041c\u0430\u0441\u0442\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441 ID=" + masterId);
            }
            boolean checkRole = false;
            for (Integer roleId : roleIds) {
                checkRole = assistantMaster.getRoleIds().contains(roleId);
                if (!checkRole) continue;
                break;
            }
            if (!checkRole) {
                throw new BGRuntimeException("\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043c\u0430\u0441\u0442\u0435\u0440\u0443 \u0437\u0430\u043a\u0440\u044b\u0442 \u0441 userID=" + userId);
            }
        }
        ArrayList<AssistantActionItem> list = new ArrayList<AssistantActionItem>();
        String query = "SELECT DISTINCT action.* FROM " + this.tableName + " AS action LEFT JOIN assistant_master_action AS ma ON action.id=ma.action_id " + (String)(masterId > 0 ? "WHERE ma.master_id=" + masterId : "WHERE action.dependent=0");
        try (Statement statement = this.con.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                AssistantActionItem item = AssistantActionItem.builder().setId(resultSet.getInt("id")).setActionId(resultSet.getString("action_id")).setTitle(resultSet.getString("title")).setDependent(resultSet.getInt("dependent")).setSort(resultSet.getInt("sort")).build();
                list.add(item);
            }
        }
        return list;
    }

    public AssistantAction get(int id) throws SQLException {
        AssistantAction assistantAction = (AssistantAction)super.get(id);
        assistantAction.setUserRoleIds(this.getUserRoleIds(assistantAction.getId()));
        return assistantAction;
    }

    protected AssistantAction getFromRS(ResultSet rs) throws SQLException {
        AssistantAction assistantAction = new AssistantAction();
        assistantAction.setId(rs.getInt("id"));
        assistantAction.setTitle(rs.getString("title"));
        assistantAction.setConfig(rs.getString("config"));
        assistantAction.setActionId(rs.getString("action_id"));
        assistantAction.setActionClass(rs.getString("action_class"));
        assistantAction.setDependent(rs.getInt("dependent"));
        assistantAction.setSort(rs.getInt("sort"));
        return assistantAction;
    }

    protected void updateImpl(AssistantAction assistantAction) throws SQLException {
        String sqlSet = " SET title=?, config=?, action_id=?, action_class=?, dependent=?, sort=?";
        if (assistantAction.getId() > 0) {
            this.updateAction(assistantAction, sqlSet);
        } else {
            this.insertAssistantAction(assistantAction, sqlSet);
        }
        try (PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM assistant_action_user_role WHERE action_id=?");){
            psDelete.setInt(1, assistantAction.getId());
            psDelete.executeUpdate();
        }
        List userRoleIds = assistantAction.getUserRoleIds();
        if (Utils.notEmptyCollection((Collection)userRoleIds)) {
            this.updateUserRolesOfAssistantAction(assistantAction);
        }
    }

    private void updateAction(AssistantAction assistantAction, String sqlSet) throws SQLException {
        try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableName + sqlSet + " WHERE id=?");){
            int parameterIndex = 1;
            psUpdate.setString(parameterIndex++, assistantAction.getTitle());
            psUpdate.setString(parameterIndex++, assistantAction.getConfig());
            psUpdate.setString(parameterIndex++, assistantAction.getActionId());
            psUpdate.setString(parameterIndex++, assistantAction.getActionClass());
            psUpdate.setInt(parameterIndex++, assistantAction.getDependent());
            psUpdate.setInt(parameterIndex++, assistantAction.getSort());
            psUpdate.setInt(parameterIndex, assistantAction.getId());
            psUpdate.executeUpdate();
        }
    }

    private void insertAssistantAction(AssistantAction assistantAction, String sqlSet) throws SQLException {
        String query = "SELECT if( isnull( max(sort) ), 1, max(sort) + 1 ) FROM " + this.tableName;
        int sort = 0;
        try (PreparedStatement psUpdateSort = this.con.prepareStatement(query);
             ResultSet rs = psUpdateSort.executeQuery();
             PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + sqlSet, 1);){
            if (rs.next()) {
                sort = rs.getInt(1);
            }
            int parameterIndex = 1;
            psInsert.setString(parameterIndex++, assistantAction.getTitle());
            psInsert.setString(parameterIndex++, assistantAction.getConfig());
            psInsert.setString(parameterIndex++, assistantAction.getActionId());
            psInsert.setString(parameterIndex++, assistantAction.getActionClass());
            psInsert.setInt(parameterIndex++, assistantAction.getDependent());
            psInsert.setInt(parameterIndex, sort);
            psInsert.executeUpdate();
            assistantAction.setId(ServerUtils.lastInsertId((PreparedStatement)psInsert));
            psInsert.close();
        }
    }

    private void updateUserRolesOfAssistantAction(AssistantAction assistantAction) throws SQLException {
        String query = "INSERT INTO assistant_action_user_role SET action_id=?, user_role_id=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(query);){
            psInsert.setInt(1, assistantAction.getId());
            for (Integer roleId : assistantAction.getUserRoleIds()) {
                psInsert.setInt(2, roleId);
                psInsert.addBatch();
            }
            psInsert.executeBatch();
        }
    }

    protected int deleteImpl(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " USING " + this.tableName + " WHERE id=? AND ( dependent>0 OR (SELECT COUNT(*) FROM `assistant_master_action` WHERE action_id=?)<2)";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, id);
            psDelete.setInt(2, id);
            int n = psDelete.executeUpdate();
            return n;
        }
    }

    public AssistantAction getByActionId(String actionId, List<Integer> ids) throws SQLException {
        if (ids == null || ids.isEmpty()) {
            throw new BGRuntimeException("actionId = " + actionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445");
        }
        AssistantAction assistantAction = (AssistantAction)this.get("action_id=? AND id IN ( " + Utils.toString(ids) + " )", new Object[]{actionId});
        if (assistantAction != null) {
            assistantAction.setUserRoleIds(this.getUserRoleIds(assistantAction.getId()));
        }
        return assistantAction;
    }

    public List<Integer> getUserRoleIds(int id) throws SQLException {
        ArrayList<Integer> roles = new ArrayList<Integer>();
        String query = "SELECT user_role_id FROM assistant_action_user_role WHERE action_id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            psSelect.setInt(1, id);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    roles.add(rs.getInt(1));
                }
            }
        }
        return roles;
    }
}

