/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.client;

import bitel.billing.module.common.BGPasswordField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Result;

public class ManagerService
extends BGUPanel {
    private BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
    private BGUComboBox<IdTitle> registratorCB = new BGUComboBox();
    private BGPasswordField registratorPassword = new BGPasswordField();
    private JTextArea statusText = new JTextArea();
    private BGTextField summaTextCloseCheckFix = new BGTextField();
    private JButton bindPrinterButton = new JButton("???");
    private JButton testPrinterButton = new JButton(this.plugin.getResourceString("testPrinterButton_Title"));

    public ManagerService(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() throws Exception {
        JPanel filterPanel1 = new JPanel(new GridBagLayout());
        filterPanel1.add((Component)new JLabel(this.plugin.getResourceString("pos_LabelTitle")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.registratorCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.registratorPassword.setColumns(5);
        filterPanel1.add((Component)this.registratorPassword, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.testPrinterButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.bindPrinterButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JButton statusPrinterButton = new JButton(this.plugin.getResourceString("statusPrinterButton_Title"));
        filterPanel1.add((Component)statusPrinterButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel filterPanel2 = new JPanel(new GridBagLayout());
        JButton openDayButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b");
        JButton xButton = new JButton(this.plugin.getResourceString("xReport_Title"));
        JButton zButton = new JButton(this.plugin.getResourceString("zReport_Title"));
        JButton divButton = new JButton(this.plugin.getResourceString("divButton_Title"));
        filterPanel2.add((Component)new JLabel("\u0421\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0451\u0442\u043e\u0432"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JLabel labelEgg = new JLabel(":");
        filterPanel2.add((Component)labelEgg, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        filterPanel2.add((Component)openDayButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel2.add((Component)xButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel2.add((Component)zButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel2.add((Component)divButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel filterPanel4 = new JPanel(new GridBagLayout());
        this.summaTextCloseCheckFix.setColumns(10);
        JButton closeCheckButton = new JButton(this.plugin.getResourceString("closeCheckButton_Title"));
        filterPanel4.add((Component)new JLabel("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel4.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel4.add((Component)this.summaTextCloseCheckFix, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel4.add((Component)closeCheckButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel filterPanel5 = new JPanel(new GridBagLayout());
        JButton repeatCheckButton = new JButton(this.plugin.getResourceString("repeatCheckButton_Title"));
        JButton continuePrintButton = new JButton(this.plugin.getResourceString("continuePrintButton_Title"));
        JButton buzzerButton = new JButton(this.plugin.getResourceString("buzzerButton_Title"));
        JButton cancelCheckButton = new JButton(this.plugin.getResourceString("cancelButton_Title"));
        filterPanel5.add((Component)repeatCheckButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel5.add((Component)continuePrintButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel5.add((Component)buzzerButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel5.add((Component)cancelCheckButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(filterPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(filterPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(filterPanel4, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(filterPanel5, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(new JScrollPane(this.statusText), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.statusText.setEditable(false);
        this.registratorCB.setMaximumRowCount(20);
        xButton.addActionListener(e -> this.performAction("xReport"));
        zButton.addActionListener(e -> this.performAction("zReport"));
        this.registratorCB.addActionListener(e -> this.registratorPassword.setText(""));
        this.bindPrinterButton.addActionListener(e -> {
            if (this.registratorCB.isEnabled()) {
                this.performAction("bindPrinter");
            } else {
                this.performAction("unbindPrinter");
            }
        });
        statusPrinterButton.addActionListener(e -> this.performAction("refresh"));
        divButton.addActionListener(e -> this.performAction("divReport"));
        labelEgg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ManagerService.this.performAction("inputEgg");
                }
            }
        });
        closeCheckButton.addActionListener(e -> this.performAction("doCloseCheckButton"));
        repeatCheckButton.addActionListener(e -> this.performAction("doRepeatCheckButton"));
        continuePrintButton.addActionListener(e -> this.performAction("doContinuePrintButton"));
        buzzerButton.addActionListener(e -> this.performAction("doBuzzerButton"));
        cancelCheckButton.addActionListener(e -> this.performAction("doCancelCheckButton"));
        openDayButton.addActionListener(e -> this.performAction("doOpenDayButton"));
        this.testPrinterButton.addActionListener(e -> this.performAction("helloPrinter"));
        this.enableControlOnLogined(false);
        this.initList();
    }

    private void enableControlOnLogined(boolean logined) {
        this.registratorCB.setEnabled(!logined);
        this.registratorPassword.setEnabled(!logined);
        this.bindPrinterButton.setText(this.plugin.getResourceString(!logined ? "bindPrinterButton_Title" : "unbindPrinterButton_Title"));
    }

    private void initList() {
        int currentPrinterId = 0;
        try {
            Result result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).registratorList();
            List list = result.getList();
            this.registratorCB.setData(list);
            currentPrinterId = (Integer)result.getAttribute("registratorId");
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430!");
        }
        this.registratorCB.insertItemAt((Object)IdTitle.NO_SELECT, 0);
        this.registratorCB.setSelectedItem((Object)currentPrinterId);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                this.statusText.setText("\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...");
                String result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).getRegistratorStatus();
                this.statusText.setText(result);
                this.enableControlOnLogined(true);
            }
            catch (BGException e1) {
                this.statusText.setText(e1.getMessage());
                this.enableControlOnLogined(false);
            }
        });
        new AbstractBGUPanel.DefaultAction("xReport", "X-\u041e\u0442\u0447\u0451\u0442"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043d\u044f\u0442\u044c \u043e\u0442\u0447\u0451\u0442?") == 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).XReport();
                    ManagerService.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("zReport", "Z-\u041e\u0442\u0447\u0451\u0442"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043d\u044f\u0442\u044c \u0424\u0418\u0421\u041a\u0410\u041b\u042c\u041d\u042b\u0419 \u043e\u0442\u0447\u0451\u0442? \u0421\u043c\u0435\u043d\u0430 \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u0430.") == 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).ZReport();
                    ManagerService.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("divReport", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043d\u044f\u0442\u044c \u043e\u0442\u0447\u0451\u0442 \u043f\u043e \u0441\u0435\u043a\u0446\u0438\u044f\u043c?") == 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).divReport();
                    ManagerService.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("bindPrinter", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                int printerId = ((IdTitle)ManagerService.this.registratorCB.getSelectedItem()).getId();
                String paswd = String.valueOf(ManagerService.this.registratorPassword.getPassword());
                if (Utils.isEmptyString((String)paswd)) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c");
                    return;
                }
                if (printerId > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0439\u0442\u0438 \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440?") == 0) {
                    try {
                        ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).bindPrinter(printerId, paswd);
                        ManagerService.this.performAction("refresh");
                        ManagerService.this.enableControlOnLogined(true);
                    }
                    catch (BGException e1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430! " + e1.getMessage());
                        ManagerService.this.registratorCB.setSelectedIndex(0);
                        ManagerService.this.enableControlOnLogined(false);
                    }
                    ManagerService.this.registratorPassword.setText("");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("unbindPrinter", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430?") == 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).bindPrinter(0, null);
                    ManagerService.this.performAction("refresh");
                    ManagerService.this.registratorCB.setSelectedIndex(0);
                    ManagerService.this.enableControlOnLogined(false);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("helloPrinter", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                IdTitle registratorItem = (IdTitle)ManagerService.this.registratorCB.getSelectedItem();
                if (registratorItem.getId() > 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).helloPrinter(registratorItem.getId(), String.valueOf(ManagerService.this.registratorPassword.getPassword()));
                    ManagerService.this.performAction("refresh");
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("doCloseCheckButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0447\u0435\u043a?\n\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0422\u041e\u041b\u042c\u041a\u041e \u043f\u0440\u0438 \u0437\u0430\u0432\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \"\u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u0447\u0435\u043a\" (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0432\u044b\u0434\u0430\u0451\u0442\u0441\u044f \"\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f\")") == 0) {
                    BigDecimal fsumma;
                    try {
                        fsumma = new BigDecimal(ManagerService.this.summaTextCloseCheckFix.getText());
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0443\u043c\u043c\u0443, \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"" + ManagerService.this.summaTextCloseCheckFix.getText() + "\" \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e");
                        return;
                    }
                    String submit = ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).closeCheckFix(fsumma);
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0434\u0430\u0447\u0430: " + submit);
                    ManagerService.this.performAction("refresh");
                    ManagerService.this.summaTextCloseCheckFix.setText("");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("doContinuePrintButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog((Component)((Object)ManagerService.this), "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 '\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438'?\n\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0422\u041e\u041b\u042c\u041a\u041e \u043f\u0440\u0438 \u0437\u0430\u0432\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \"\u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0436\u0434\u0451\u0442 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438\"") == 0) {
                    ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).continuePrint();
                    ManagerService.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("doRepeatCheckButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).repeatCheck();
            }
        };
        new AbstractBGUPanel.DefaultAction("doBuzzerButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).buzzer();
            }
        };
        new AbstractBGUPanel.DefaultAction("doCancelCheckButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).cancelCheck();
                ManagerService.this.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("doOpenDayButton", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).openDay();
                ManagerService.this.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("inputEgg", "?"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                String t = JOptionPane.showInputDialog("<html>TEXT<u>line1</u>&lt;&gt;<u>line2</u>...<br/>CMD <u>byte1</u> <u>byte2</u> ... (hex)</html>");
                if (t != null) {
                    if (t.startsWith("TEXT")) {
                        t = t.substring(4);
                        ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).printText(t.replaceAll("<>", "\n"));
                    } else if (t.startsWith("CMD")) {
                        t = t.substring(3);
                        String replyRet = ((CashcheckService)((ClientContext)ManagerService.this.getContext()).getPort(CashcheckService.class)).sendPureCommand(t);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0432\u0435\u0442:\n" + replyRet);
                        ManagerService.this.performAction("refresh");
                    }
                }
            }
        };
    }
}

