/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.modules.inet.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetConnectionKeyMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class InetRadiusHelperProcessor
extends InetRadiusProcessor {
    private static final Logger logger = LogManager.getLogger();
    private final ConnectionKeyMap connectionMap;
    private volatile Set<Integer> keyDeviceTypeIds;
    private final InetApplication application;

    @ConstructorProperties(value={"setup", "access", "accounting"})
    public InetRadiusHelperProcessor(Setup setup, Access access, Accounting accounting) throws BGException {
        super(setup, access, accounting);
        this.application = access != null ? access : accounting;
        this.connectionMap = new ConnectionKeyMap(this.application);
    }

    @Override
    public void start() throws Exception {
        super.start();
        InetApplication application = this.access != null ? this.access : this.accounting;
        InetDeviceRuntime rootDevice = application.deviceMap.get(application.rootDeviceId);
        this.keyDeviceTypeIds = Utils.toIntegerSet((String)rootDevice.config.get("radius.key.deviceTypeIds", ""));
        this.connectionMap.load(this.keyDeviceTypeIds);
    }

    @Override
    protected void reloadNasList() {
        super.reloadNasList();
        InetApplication application = this.access != null ? this.access : this.accounting;
        InetDeviceRuntime rootDevice = application.deviceMap.get(application.rootDeviceId);
        this.keyDeviceTypeIds = Utils.toIntegerSet((String)rootDevice.config.get("radius.key.deviceTypeIds", ""));
    }

    protected InetNasConnection accounting(RadiusListenerWorker<InetNas> req, InetNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        InetNasConnection result = (InetNasConnection)super.accounting(req, (Nas)nas, request, response, connectionSet, time);
        this.setCallingStationIdAttribute(result, request);
        return result;
    }

    private void setCallingStationIdAttribute(InetNasConnection result, RadiusPacket request) {
        if (result == null || result.getSession() == null) {
            return;
        }
        InetConnection connection = result.getSession().connection;
        if (connection == null) {
            return;
        }
        this.setCallingStationIdAttribute(request, connection.getCallingStationId());
    }

    private void setCallingStationIdAttribute(RadiusPacket request, String callingStationId) {
        if (request.getStringAttribute(-1, 31, null) == null && callingStationId != null && callingStationId.length() != 0) {
            request.setStringAttribute(-1, 31, callingStationId);
        }
    }

    @Override
    protected ServSearchResult findServRuntime(InetApplication application, RadiusListenerWorker<?> req, InetNas nas, String userName, RadiusPacket request, Date time) {
        byte[] macAddress;
        InetDeviceRuntime deviceRuntime = nas.getDeviceRuntime();
        if (!this.keyDeviceTypeIds.contains(deviceRuntime.inetDeviceType.getId())) {
            return super.findServRuntime(application, req, nas, userName, request, time);
        }
        logger.debug("Search serv by key " + userName);
        Entry e = (Entry)this.connectionMap.get(userName);
        if (e == null) {
            logger.debug("Connection entry not found, use default search");
            return super.findServRuntime(application, req, nas, userName, request, time);
        }
        InetServRuntimeMap servRuntimeMap = application.getInetServRuntimeMap();
        InetServRuntime servRuntime = servRuntimeMap.get(e.servId);
        if (servRuntime == null) {
            logger.warn("Connection entry found, but inetServRuntime with id=" + e.servId + " not");
            return null;
        }
        List<InetServRuntime> children = servRuntimeMap.listChildren(servRuntime.inetServId, time.getTime());
        if (children != null && children.size() > 0) {
            for (InetServRuntime child : children) {
                if (!child.inetServTypeRef.get().radiusSecondFramedIp) continue;
                servRuntime = children.get(0);
            }
        }
        InetServRuntime parentServRuntime = servRuntime.getRootInetServRuntime(application);
        InetConnection connection = this.getConnection(e);
        if (connection == null) {
            logger.error("Connection entry found with " + userName + " but connection by entry with servId " + e.servId + " and id=" + e.connectionId + " not. Falling back to default search.");
            return super.findServRuntime(application, req, nas, userName, request, time);
        }
        int accessCode = connection.getAccessCode();
        if (!AccessCodes.isConnectionStateful((int)accessCode)) {
            accessCode = AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
        }
        String callingStationId = connection.getCallingStationId();
        if (request.getOption(InetRadiusProcessor.MAC_ADDRESS) == null && request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES) == null && (macAddress = MACParser.parseMacAddress((String)callingStationId)) != null && macAddress.length > 0) {
            request.setOption(InetRadiusProcessor.MAC_ADDRESS_BYTES, (Object)macAddress);
        }
        this.setCallingStationIdAttribute(request, callingStationId);
        return new ServSearchResult(0, parentServRuntime, servRuntime, accessCode);
    }

    protected InetConnection getConnection(Entry entry) {
        if (this.access != null) {
            List<InetConnectionRuntime> connectionRuntimeList = this.access.connectionManager.getByServId(entry.servId);
            if (connectionRuntimeList != null) {
                int size = connectionRuntimeList.size();
                for (int i = 0; i < size; ++i) {
                    InetConnection connection = connectionRuntimeList.get((int)i).connection;
                    if (connection.getId() != entry.connectionId) continue;
                    return connection;
                }
            }
            return null;
        }
        InetConnectionCallRuntime connectionCallRuntime = this.accounting.connectionMapCall.get(entry.connectionId);
        if (connectionCallRuntime != null) {
            return connectionCallRuntime.connection;
        }
        return null;
    }

    class ConnectionKeyMap
    extends InetConnectionKeyMap<InetNas, Entry> {
        public ConnectionKeyMap(InetApplication application) throws BGException {
            super(application, true);
        }

        @Override
        protected Entry newEntry(int ipResourceId, byte[] address, int servId, long connectionId) {
            return new Entry(ipResourceId, address, servId, connectionId);
        }

        @Override
        protected int getServSearchMode(InetNas nas) {
            return nas != null ? nas.getServSearchModes()[0][0] : 0;
        }

        @Override
        protected String getPattern(InetNas nas) {
            return nas != null ? nas.getKeyPattern() : "$ip";
        }

        @Override
        protected InetNas getDevice(int deviceId) {
            return (InetNas)InetRadiusHelperProcessor.this.nasList.get(deviceId);
        }

        @Override
        protected int getDeviceTypeId(InetNas nas) {
            return nas != null ? nas.getDeviceRuntime().inetDeviceType.getId() : 0;
        }

        @Override
        protected long getConnectionId(Entry entry) {
            return entry.connectionId;
        }
    }

    static class Entry {
        final int ipResourceId;
        final byte[] address;
        final int servId;
        volatile long connectionId;

        public Entry(int ipResourceId, byte[] address, int servId, long connectionId) {
            this.ipResourceId = ipResourceId;
            this.address = address;
            this.servId = servId;
            this.connectionId = connectionId;
        }
    }
}

