/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.BasicFlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.FlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.MonthFlowDetailMaker;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTaskManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.logging.BGNestedContext;

public class DetailMaker
extends Thread {
    private BGLogger logger = new BGLogger((Object)this);
    private Setup setup;
    private String sources;
    private int mid;
    private FlowDetailMaker detailMaker;
    private MonthFlowDetailMaker monthDetailMaker;

    public DetailMaker(Setup setup) {
        this.logger.getLogger().info("Starting detail maker...");
        this.setup = setup;
        this.sources = setup.get("process.sources", setup.get("sources", "0"));
        this.mid = setup.getInt("collector.mid", 0);
        try {
            this.detailMaker = Class.forName(setup.get("ipn.collector.detail.class", BasicFlowDetailMaker.class.getName())).asSubclass(FlowDetailMaker.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.detailMaker.init((ParameterMap)setup);
        }
        catch (Exception ex) {
            this.logger.logError((Throwable)ex);
            this.detailMaker = new BasicFlowDetailMaker();
            this.detailMaker.init((ParameterMap)setup);
        }
        this.monthDetailMaker = new MonthFlowDetailMaker();
        this.monthDetailMaker.init((ParameterMap)setup);
        this.setPriority(1);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BGNestedContext.push((String)"detail");
        this.logger.getLogger().info("Started detail maker...");
        while (true) {
            try {
                while (true) {
                    boolean taskWas = false;
                    Connection con = this.setup.getDBConnectionFromPool();
                    DetailCreateTask task = null;
                    try {
                        DetailCreateTaskManager taskManager = new DetailCreateTaskManager(con, this.mid);
                        task = taskManager.getNextTask(this.sources);
                        boolean bl = taskWas = task != null;
                        if (taskWas) {
                            this.logger.getLogger().info("Starting detail task...");
                            if (!task.isMonthPeriod()) {
                                this.detailMaker.createDetail((DefaultServerSetup)this.setup, con, task);
                            } else {
                                this.monthDetailMaker.createDetail((DefaultServerSetup)this.setup, con, task);
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.logger.getLogger().error(e.getMessage(), e);
                    }
                    finally {
                        ServerUtils.closeConnection((Connection)con);
                    }
                    if (taskWas) continue;
                    DetailMaker.sleep(5000L);
                }
            }
            catch (Exception ex) {
                this.logger.logError((Throwable)ex);
                continue;
            }
            break;
        }
    }
}

