/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TvRegistrationUtils {
    private static final Logger logger = LogManager.getLogger();

    public static TvAccount tvAccountCreate(ServerContext context, int moduleId, int contractId, int tvAccountSpecId, int parentId, Date dateFrom, String login, String password, String identifier, String deviceAccountId, String mac, String comment) throws Exception {
        TvAccount tvAccount = new TvAccount();
        tvAccount.setContractId(contractId);
        tvAccount.setSpecId(tvAccountSpecId);
        tvAccount.setDateFrom(dateFrom);
        tvAccount.setDateTo(null);
        tvAccount.setStatus(0);
        tvAccount.setLogin(login);
        tvAccount.setPassword(password);
        tvAccount.setIdentifier(Utils.maskNull((String)identifier));
        tvAccount.setDeviceAccountId(deviceAccountId);
        if (Utils.notEmptyString((String)mac)) {
            String[] macAddresses = mac.split("\\s*,\\s*");
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
            for (String macAddress : macAddresses) {
                if (macAddress.length() <= 0) continue;
                macAddressList.add(MACParser.parseMacAddress((String)macAddress));
            }
            tvAccount.setMacAddressList(macAddressList);
        }
        tvAccount.setComment(Utils.maskNull((String)comment));
        TvAccountService tvAccountService = (TvAccountService)context.getService(TvAccountService.class, moduleId);
        tvAccountService.tvAccountUpdate(tvAccount.getContractId(), tvAccount, Utils.isBlankString((String)login), Utils.isBlankString((String)password), 0L);
        logger.info("Created tvAccount:" + tvAccount.getId());
        return tvAccount;
    }

    public static TvAccount tvAccountRegister(ServerContext context, int moduleId, int contractId, int tvAccountSpecId, String login, String identifier, String mac, String comment) throws Exception {
        TvAccount tvAccount;
        logger.info("tvAccountRegister, contractId: " + contractId);
        TvAccountService tvAccountService = (TvAccountService)context.getService(TvAccountService.class, moduleId);
        TvAccount oldTvAccount = null;
        if (tvAccountSpecId <= 0) {
            throw new BGIllegalArgumentException("tvAccountSpecId");
        }
        TvAccount root = tvAccountService.tvAccountTree(contractId);
        for (TvAccount tvAccount2 : Optional.ofNullable(root).map(a -> a.getChildren()).orElse(Collections.emptyList())) {
            if (tvAccount2.getSpecId() != tvAccountSpecId || !TimeUtils.dateInRange((Date)new Date(), (Date)tvAccount2.getDateFrom(), (Date)tvAccount2.getDateTo())) continue;
            logger.info("Found existing tvAccount:" + tvAccount2.getId());
            oldTvAccount = tvAccount2;
            break;
        }
        if (oldTvAccount != null) {
            tvAccount = oldTvAccount;
        } else {
            logger.info("Creating new TvAccount");
            tvAccount = new TvAccount();
            tvAccount.setContractId(contractId);
            tvAccount.setSpecId(tvAccountSpecId);
            tvAccount.setDateFrom(new Date());
            tvAccount.setStatus(0);
            tvAccount.setIdentifier(Utils.maskNull((String)identifier));
            tvAccount.setComment(comment);
        }
        if (Utils.notBlankString((String)login)) {
            tvAccount.setLogin(login);
        }
        if (Utils.notBlankString((String)mac)) {
            String[] macAddresses = mac.split("\\s*,\\s*");
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
            for (String macAddress : macAddresses) {
                if (macAddress.length() <= 0) continue;
                macAddressList.add(MACParser.parseMacAddress((String)macAddress));
            }
            tvAccount.setMacAddressList(macAddressList);
        }
        tvAccountService.tvAccountUpdate(tvAccount.getContractId(), tvAccount, tvAccount.getId() <= 0 && Utils.isBlankString((String)login), tvAccount.getId() <= 0, 0L);
        logger.info("tvAccountId:" + tvAccount.getId());
        return tvAccount;
    }

    public static TvAccount tvAccountFind(TvAccountService tvAccountService, String username, String deviceAccountId) throws Exception {
        Date now = new Date();
        List list = tvAccountService.tvAccountSearch(Arrays.asList(new KeyValue("login", username), new KeyValue("extId", deviceAccountId)), 0, true);
        if (list != null) {
            for (TvAccount a : list) {
                if (a.getParentId() > 0 || !TimeUtils.dateInRange((Date)now, (Date)a.getDateFrom(), (Date)a.getDateTo())) continue;
                return a;
            }
        }
        return null;
    }

    public static void productActivate(ServerContext context, int moduleId, int contractId, Date time, int productSpecId, int activationModeId, String description, String comment) throws Exception {
        TvService tvService = (TvService)context.getService(TvService.class, moduleId);
        tvService.groupOperationActivate(Collections.singleton(contractId), time, productSpecId, activationModeId, Utils.maskNull((String)description), Utils.maskNull((String)comment));
    }
}

