/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import java.util.Set;
import ru.bitel.bgbilling.modules.ipn.server.Dlink30xx35xxGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.DlinkUtils;
import ru.bitel.bgbilling.modules.ipn.server.dlink.NextTaker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class IPMacBinding30xx
extends NextTaker {
    private static final String OID_30xx_MAC_FORWARD = "1.3.6.1.2.1.17.7";
    private static final String OID_30xx_MAC_FORWARD_MIDDLE = "1.3.1.1.4";
    private static final String OID_30xx_MAC_FORWARD_PORT_MIDDLE = "1.3.1.1.3";
    private int des30xxVlan = 1;
    private PortMask des30xxPortMask;
    private Set<String> macSet;

    public IPMacBinding30xx(int vlan, PortMask portMask, Set<String> macSet) {
        this.des30xxVlan = vlan;
        this.des30xxPortMask = portMask;
        this.macSet = macSet;
    }

    public void bind(UserPortStatus userPort, Dlink30xx35xxGateWorker gateWorker) throws Exception {
        String oid = null;
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        if (userPort.status.status == 3 && this.macSet.contains(userPort.macAddr)) {
            oid = "1.3.6.1.2.1.17.7.1.3.1.1.4." + this.des30xxVlan + "." + DlinkUtils.convertHexToOid(userPort.macAddr) + ".0";
            pairs.add(new Object[]{oid, new AsnInteger(2)});
        }
        if (userPort.status.status != 3 && !this.macSet.contains(userPort.macAddr)) {
            oid = "1.3.6.1.2.1.17.7.1.3.1.1.3." + this.des30xxVlan + "." + DlinkUtils.convertHexToOid(userPort.macAddr) + ".0";
            pairs.add(new Object[]{oid, new AsnOctets(this.des30xxPortMask.portToReverseMask(userPort.port))});
            oid = "1.3.6.1.2.1.17.7.1.3.1.1.4." + this.des30xxVlan + "." + DlinkUtils.convertHexToOid(userPort.macAddr) + ".0";
            pairs.add(new Object[]{oid, new AsnInteger(3)});
        }
        if (pairs.size() > 0) {
            gateWorker.sendSetPdu(pairs);
        }
    }

    public String getTopOid() {
        return OID_30xx_MAC_FORWARD;
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        String oidStart = "1.3.6.1.2.1.17.7.1.3.1.1.4." + this.des30xxVlan + ".";
        AsnObject value = var.getValue();
        if (oid.startsWith(oidStart) && value instanceof AsnInteger && value.toString().equals("3")) {
            String macAddress = oid.substring(oidStart.length(), oid.length() - 2);
            this.macSet.add(DlinkUtils.convertOidToHex(macAddress));
        }
    }
}

