/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.admin.resource.bean.NumberResourceManager;
import bitel.billing.server.admin.resource.bean.NumberResourceUse;
import bitel.billing.server.admin.resource.bean.NumberResourceUseManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.PagedList;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.event.ClientItemChangedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ClientItemManager {
    private Connection con;
    private String tableName;
    private String ipTableName;
    private int mid;
    private ContractUtils contractUtils;
    private static final Comparator<ClientItem> compDate = new Comparator<ClientItem>(){

        @Override
        public int compare(ClientItem o1, ClientItem o2) {
            Calendar d1 = o1.getDate1();
            Calendar d2 = o2.getDate1();
            if (d1 == null) {
                if (d2 == null) {
                    return 0;
                }
                return Integer.MIN_VALUE;
            }
            if (d2 == null) {
                return Integer.MAX_VALUE;
            }
            return d1.compareTo(d2);
        }
    };
    private static final Comparator<ClientItem> compNumber = new Comparator<ClientItem>(){

        @Override
        public int compare(ClientItem o1, ClientItem o2) {
            int m2;
            String sp2;
            String sn2;
            int m1;
            String sp1;
            String sn1;
            if (o1.getType() == 2 || o2.getType() == 2) {
                return 0;
            }
            if (Utils.notEmptyString((String)o1.getAlias())) {
                sn1 = o1.getAlias();
                sp1 = "";
                m1 = 0;
            } else {
                String string = sn1 = o1.getClientNumbers().size() > 0 ? o1.getClientNumbers().get(0) : "";
                if (o1.getClientPorts() != null && o1.getClientPorts().size() > 0) {
                    sp1 = o1.getClientPorts().get(0);
                    m1 = 2;
                } else {
                    sp1 = "";
                    m1 = 1;
                }
            }
            if (Utils.notEmptyString((String)o2.getAlias())) {
                sn2 = o2.getAlias();
                sp2 = "";
                m2 = 0;
            } else {
                String string = sn2 = o2.getClientNumbers().size() > 0 ? o2.getClientNumbers().get(0) : "";
                if (o2.getClientPorts() != null && o2.getClientPorts().size() > 0) {
                    sp2 = o2.getClientPorts().get(0);
                    m2 = 2;
                } else {
                    sp2 = "";
                    m2 = 1;
                }
            }
            return sn1.compareTo(sn2) + sp1.compareTo(sp2) + (m1 - m2) * 10000000;
        }
    };
    private ContractManager contractManager;

    public ClientItemManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "phone_client_item_" + mid;
        this.ipTableName = "phone_item_ip_" + mid;
        this.contractUtils = new ContractUtils(con);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void updateClientItem(ClientItem item) throws BGException {
        try {
            String result = null;
            if (item.getType() == 1 && Utils.notBlankString((String)(result = this.checkItem(item)))) {
                throw new BGException("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043d\u043e\u043c\u0435\u0440\u043e\u0432/\u043f\u043e\u0440\u0442\u043e\u0432 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440(\u0430\u043c\u0438) " + result);
            }
            String query = "UPDATE " + this.tableName + " SET cid=?, type=?, source_id=?, date1=?, date2=?,  comment=?, object_id=?, alias=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, item.getContractId());
            ps.setInt(2, item.getType());
            ps.setInt(3, item.getSourceId());
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate1()));
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate2()));
            ps.setString(6, item.getComment());
            ps.setInt(7, item.getObjectId());
            ps.setString(8, item.getAlias());
            ps.setInt(9, item.getId());
            ps.executeUpdate();
            ps.close();
            this.updateItemData(item);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void updateItemData(ClientItem item) throws SQLException {
        if (item.getType() == 1) {
            String query = "DELETE FROM phone_item_number_" + this.mid + " WHERE item_id=" + item.getId();
            Statement st = this.con.createStatement();
            st.executeUpdate(query);
            query = "INSERT INTO phone_item_number_" + this.mid + " (item_id, number) VALUES (" + item.getId() + ",?)";
            PreparedStatement numberPS = this.con.prepareStatement(query);
            for (String num : item.getClientNumbers()) {
                numberPS.setString(1, num);
                numberPS.executeUpdate();
            }
            numberPS.close();
            query = "DELETE FROM phone_item_port_" + this.mid + " WHERE item_id=" + item.getId();
            st.executeUpdate(query);
            st.close();
            query = "INSERT INTO phone_item_port_" + this.mid + " (item_id, port) VALUES (" + item.getId() + ",?)";
            PreparedStatement portPS = this.con.prepareStatement(query);
            for (String num : item.getClientPorts()) {
                portPS.setString(1, num);
                portPS.executeUpdate();
            }
            portPS.close();
        } else {
            String tableName = "phone_item_rule_data_" + this.mid;
            String query = "DELETE FROM " + tableName + " WHERE item_id=?";
            PreparedStatement psDel = this.con.prepareStatement(query);
            psDel.setInt(1, item.getId());
            psDel.executeUpdate();
            psDel.close();
            query = "INSERT INTO " + tableName + " (item_id, oper_fromports, oper_toports, oper_fromprefs, oper_toprefs, oper_not_fromprefs, oper_not_toprefs, oper_service_id, oper_from_range, oper_to_range, oper_not_from_range, oper_not_to_range, fromports_regexp, toports_regexp, oper_fromrangemap, oper_torangemap, oper_notfromrangemap, oper_nottorangemap) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement psInsert = this.con.prepareStatement(query);
            psInsert.setInt(1, item.getId());
            psInsert.setString(2, Utils.toString(item.getOperFromPorts()));
            psInsert.setString(3, Utils.toString(item.getOperToPorts()));
            psInsert.setString(4, item.getOperFromPrefs());
            psInsert.setString(5, item.getOperToPrefs());
            psInsert.setString(6, item.getOperNotFromPrefs());
            psInsert.setString(7, item.getOperNotToPrefs());
            psInsert.setInt(8, item.getOperServiceId());
            psInsert.setString(9, item.getOperFromRange());
            psInsert.setString(10, item.getOperToRange());
            psInsert.setString(11, item.getOperNotFromRange());
            psInsert.setString(12, item.getOperNotToRange());
            psInsert.setString(13, item.getOperFromPortsRegexp());
            psInsert.setString(14, item.getOperToPortsRegexp());
            psInsert.setString(15, item.getOperFromRangeMapIds());
            psInsert.setString(16, item.getOperToRangeMapIds());
            psInsert.setString(17, item.getOperNotFromRangeMapIds());
            psInsert.setString(18, item.getOperNotToRangeMapIds());
            psInsert.executeUpdate();
            psInsert.close();
        }
    }

    public void addClientItem(ClientItem item) throws BGException {
        try {
            if (item.getType() == 1) {
                String result = null;
                result = this.checkItem(item);
                if (Utils.notBlankString((String)result)) {
                    throw new BGException("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043d\u043e\u043c\u0435\u0440\u043e\u0432/\u043f\u043e\u0440\u0442\u043e\u0432 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440(\u0430\u043c\u0438) " + result);
                }
                result = this.checkResource(item);
                if (Utils.notBlankString((String)result)) {
                    throw new BGException("\u041d\u043e\u043c\u0435\u0440\u0430 \u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u0435 " + result);
                }
            }
            String query = "INSERT INTO " + this.tableName + " (cid, type, source_id, date1, date2, comment, object_id, alias) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, item.getContractId());
            ps.setInt(2, item.getType());
            ps.setInt(3, item.getSourceId());
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate1()));
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate2()));
            ps.setString(6, item.getComment());
            ps.setInt(7, item.getObjectId());
            ps.setString(8, item.getAlias());
            ps.executeUpdate();
            item.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
            this.updateItemData(item);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteClientItem(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM phone_item_number_" + this.mid + " WHERE item_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM phone_item_port_" + this.mid + " WHERE item_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM phone_item_rule_data_" + this.mid + " WHERE item_id=?";
            PreparedStatement psDel = this.con.prepareStatement(query);
            psDel.setInt(1, id);
            psDel.executeUpdate();
            psDel.close();
            query = "DELETE FROM contract_tariff WHERE eid=? AND emid=" + this.mid;
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            this.deleteIp(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ClientItem> getObjectItemList(int objectId) {
        ArrayList<ClientItem> result = new ArrayList<ClientItem>();
        try {
            String query = "SELECT items.*, source.title as source_title, service.title as oper_service_title, contract.title as contract_title FROM " + this.tableName + " as items LEFT JOIN source ON source.id=items.source_id LEFT JOIN phone_item_rule_data_" + this.mid + " as rules ON rules.item_id=items.id LEFT JOIN service ON service.id=rules.oper_service_id LEFT JOIN contract ON contract.id=items.cid WHERE items.object_id=? ORDER BY items.type";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ResultSet rs = ps.executeQuery();
            PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.mid);
            PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.mid);
            while (rs.next()) {
                result.add(this.getItemFromRS(rs, getNumbersPS, getPortsPS));
            }
            ps.close();
            getNumbersPS.close();
            getPortsPS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ClientItem> getItemList(int cid) {
        return this.getItemList(cid, -1, true, -1);
    }

    public List<ClientItem> getItemList(int cid, int type, boolean sortByDate, int objectId) {
        return this.getItemList(cid, type, sortByDate, objectId, null);
    }

    public List<ClientItem> getItemList(int cid, int type, boolean sortByDate, int objectId, java.util.Date dateFrom, java.util.Date dateTo) {
        return this.getItemList(cid, type, sortByDate, objectId, new Period(dateFrom, dateTo));
    }

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.con);
        }
        return this.contractManager;
    }

    public List<ClientItem> getItemList(int cid, int type, boolean sortByDate, int objectId, Period period) {
        ArrayList<ClientItem> result = new ArrayList<ClientItem>();
        try {
            Contract contract = this.getContractManager().getContractById(cid);
            boolean isIndependBalanceSub = contract.isSub() && contract.getSubMode() == 1;
            String query = "SELECT items.*, source.title as source_title, service.title as oper_service_title, contract.title as contract_title FROM " + this.tableName + " as items LEFT JOIN source ON source.id=items.source_id LEFT JOIN phone_item_rule_data_" + this.mid + " AS rule ON items.id=rule.item_id LEFT JOIN service ON service.id=rule.oper_service_id LEFT JOIN contract ON contract.id=items.cid WHERE items.cid=? ";
            if (type == 1 || type == 2) {
                query = query + " AND items.type=" + type;
            }
            if (objectId > 0) {
                query = query + " AND items.object_id=" + objectId;
            }
            if (period != null) {
                query = query + " AND ( items.date1<=? OR ? IS NULL OR items.date1 IS NULL ) AND ( items.date2>=? OR items.date2 IS NULL OR ? IS NULL )";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            if (isIndependBalanceSub) {
                ps.setInt(1, contract.getSuperId());
            } else {
                ps.setInt(1, cid);
            }
            if (period != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateTo()));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateTo()));
                ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateFrom()));
                ps.setDate(5, TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateFrom()));
            }
            ResultSet rs = ps.executeQuery();
            PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.mid);
            PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.mid);
            while (rs.next()) {
                result.add(this.getItemFromRS(rs, getNumbersPS, getPortsPS));
            }
            ps.close();
            getNumbersPS.close();
            getPortsPS.close();
            if (sortByDate) {
                Collections.sort(result, compDate);
            } else {
                Collections.sort(result, compNumber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ClientItem> getItemList(int cid, int type, boolean sortByDate) {
        return this.getItemList(cid, type, sortByDate, 0);
    }

    public ClientItem getItem(int id) {
        ClientItem result = null;
        try {
            String query = "SELECT items.*, rule.*, source.title as source_title, service.title as oper_service_title, contract.title as contract_title FROM " + this.tableName + " as items LEFT JOIN source ON source.id=items.source_id LEFT JOIN contract ON contract.id=items.cid LEFT JOIN phone_item_rule_data_" + this.mid + " AS rule ON items.id=rule.item_id LEFT JOIN service ON service.id=rule.oper_service_id WHERE items.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.mid);
            PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.mid);
            while (rs.next()) {
                result = this.getItemFromRS(rs, getNumbersPS, getPortsPS, true, true);
            }
            ps.close();
            getNumbersPS.close();
            getPortsPS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ClientItem getItemFromRS(ResultSet rs, PreparedStatement numbersPs, PreparedStatement portPS) throws SQLException {
        return this.getItemFromRS(rs, numbersPs, portPS, true, false);
    }

    private ClientItem getItemFromRS(ResultSet rs, PreparedStatement numbersPs, PreparedStatement portPS, boolean titleLoad, boolean ruleParamsLoad) throws SQLException {
        ClientItem result = new ClientItem();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setObjectId(rs.getInt("object_id"));
        result.setType(rs.getInt("type"));
        result.setDate1(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date2")));
        result.setSourceId(rs.getInt("source_id"));
        result.setAlias(rs.getString("alias"));
        result.setComment(rs.getString("comment"));
        if (titleLoad) {
            result.setSourceTitle(rs.getString("source_title"));
            result.setContractTitle(rs.getString("contract_title"));
        }
        if (result.getType() == 1) {
            ArrayList<String> clientNumbers = new ArrayList<String>();
            if (numbersPs != null) {
                numbersPs.setInt(1, result.getId());
                ResultSet nRS = numbersPs.executeQuery();
                while (nRS.next()) {
                    clientNumbers.add(nRS.getString(1));
                }
                result.setClientNumbers(clientNumbers);
            }
            if (portPS != null && clientNumbers.size() <= 0) {
                ArrayList<String> clientPorts = new ArrayList<String>();
                portPS.setInt(1, result.getId());
                ResultSet nRS = portPS.executeQuery();
                while (nRS.next()) {
                    clientPorts.add(nRS.getString(1));
                }
                result.setClientPorts(clientPorts);
            }
        } else {
            if (titleLoad) {
                result.setOperService(rs.getString("oper_service_title"));
            }
            if (ruleParamsLoad) {
                result.setOperFromPorts(Utils.toList((String)rs.getString("rule.oper_fromports")));
                result.setOperToPorts(Utils.toList((String)rs.getString("rule.oper_toports")));
                result.setOperFromPrefs(rs.getString("rule.oper_fromprefs"));
                result.setOperToPrefs(rs.getString("rule.oper_toprefs"));
                result.setOperNotFromPrefs(rs.getString("rule.oper_not_fromprefs"));
                result.setOperNotToPrefs(rs.getString("rule.oper_not_toprefs"));
                result.setOperServiceId(rs.getInt("rule.oper_service_id"));
                result.setOperFromRange(rs.getString("rule.oper_from_range"));
                result.setOperToRange(rs.getString("rule.oper_to_range"));
                result.setOperNotFromRange(rs.getString("rule.oper_not_from_range"));
                result.setOperNotToRange(rs.getString("rule.oper_not_to_range"));
                result.setOperFromPortsRegexp(rs.getString("rule.fromports_regexp"));
                result.setOperToPortsRegexp(rs.getString("rule.toports_regexp"));
                result.setOperFromRangeMapIds(rs.getString("rule.oper_fromrangemap"));
                result.setOperToRangeMapIds(rs.getString("rule.oper_torangemap"));
                result.setOperNotFromRangeMapIds(rs.getString("rule.oper_notfromrangemap"));
                result.setOperNotToRangeMapIds(rs.getString("rule.oper_nottorangemap"));
            }
        }
        return result;
    }

    private ClientItem getItemFromRSFindByNumber(ResultSet rs, PreparedStatement numbersPs, PreparedStatement portPs) throws SQLException {
        ClientItem result = new ClientItem();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setObjectId(rs.getInt("object_id"));
        result.setType(rs.getInt("type"));
        result.setDate1(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("date2")));
        result.setSourceId(rs.getInt("source_id"));
        result.setSourceTitle(rs.getString("source_title"));
        result.setContractTitle(rs.getString("contract_title"));
        result.setContractComment(rs.getString("contract_comment"));
        result.setComment(rs.getString("comment"));
        result.setAlias(rs.getString("alias"));
        ArrayList<String> clientNumbers = new ArrayList<String>();
        clientNumbers.add(rs.getString("number"));
        result.setClientNumbers(clientNumbers);
        return result;
    }

    public PagedList<ClientItem> findByNumber(String number, Calendar date1, Calendar date2, int sortBy, boolean sortType, String mode, Page page) {
        if (number == null) {
            number = "";
        }
        if ("start".equals(mode)) {
            number = (String)number + "%";
        } else if ("end".equals(mode)) {
            number = "%" + (String)number;
        } else if ("include".equals(mode)) {
            number = "%" + (String)number + "%";
        }
        int records = 0;
        ArrayList<ClientItem> result = new ArrayList<ClientItem>(page.getPageSize());
        try {
            int index = 1;
            StringBuilder where = new StringBuilder(" WHERE type=1 AND number.number LIKE ?");
            if (date1 != null) {
                where.append(" AND (items.date2 IS NULL OR items.date2>=?)");
            }
            if (date2 != null) {
                where.append(" AND (items.date1 IS NULL OR items.date1<=?)");
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) FROM " + this.tableName + " as items LEFT JOIN phone_item_number_" + this.mid + " as number");
            query.append(" ON number.item_id=items.id ");
            query.append((CharSequence)where);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(index++, (String)number);
            if (date1 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            }
            if (date2 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                records = rs.getInt(1);
            }
            rs.close();
            ps.close();
            page.setRecordCount(records);
            if (page.getPageIndex() > page.getPageCount()) {
                page.setPageIndex(page.getPageCount());
            }
            index = 1;
            query = new StringBuilder();
            query.append("SELECT items.*, number.number, source.title as source_title, ");
            query.append("contract.title AS contract_title, contract.comment AS contract_comment FROM ");
            query.append(this.tableName);
            query.append(" as items LEFT JOIN phone_item_number_");
            query.append(this.mid);
            query.append(" as number ON number.item_id=items.id");
            query.append(" LEFT JOIN source ON source.id=items.source_id");
            query.append(" LEFT JOIN contract ON contract.id=items.cid");
            query.append((CharSequence)where);
            if (sortBy > 0) {
                query.append(" ORDER BY ");
                switch (sortBy) {
                    case 1: {
                        query.append(" contract_title");
                        break;
                    }
                    case 2: {
                        query.append(" number.number");
                        break;
                    }
                    case 3: {
                        query.append(" items.date1");
                    }
                }
                if (!sortType) {
                    query.append(" DESC ");
                }
            }
            query.append(page.sqlLimit());
            ps = this.con.prepareStatement(query.toString());
            ps.setString(index++, (String)number);
            if (date1 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            }
            if (date2 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            }
            rs = ps.executeQuery();
            PreparedStatement getNumbersPS = ClientItemManager.getNumbersPS(this.con, this.mid);
            PreparedStatement getPortsPS = ClientItemManager.getPortsPS(this.con, this.mid);
            while (rs.next()) {
                result.add(this.getItemFromRSFindByNumber(rs, getNumbersPS, getPortsPS));
            }
            ps.close();
            getNumbersPS.close();
            getPortsPS.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return new PagedList(result, page, records);
    }

    protected static final PreparedStatement getNumbersPS(Connection con, int mid) throws SQLException {
        return con.prepareStatement("SELECT number FROM phone_item_number_" + mid + " WHERE item_id=?");
    }

    protected static final PreparedStatement getPortsPS(Connection con, int mid) throws SQLException {
        return con.prepareStatement("SELECT port FROM phone_item_port_" + mid + " WHERE item_id=?");
    }

    protected static final PreparedStatement getSimpleItemPS(Connection con, int mid) throws SQLException {
        String query = "SELECT item.alias, item.type as item_type, rule.oper_fromprefs, rule.oper_toprefs, rule.oper_fromports, rule.oper_toports, service.title  as oper_service FROM phone_client_item_" + mid + " as item LEFT JOIN phone_item_rule_data_" + mid + " AS rule ON item.id=rule.item_id LEFT JOIN service ON service.id=rule.oper_service_id WHERE item.id=?";
        return con.prepareStatement(query);
    }

    private String checkItem(ClientItem item) throws SQLException {
        StringBuilder query;
        List<String> paramList;
        boolean number;
        StringBuilder result = new StringBuilder();
        Date date1 = TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate1());
        Date date2 = TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate2());
        boolean bl = number = item.getClientNumbers().size() > 0;
        if (number) {
            paramList = item.getClientNumbers();
            query = new StringBuilder("SELECT number.id, item.cid FROM phone_item_number_" + this.mid + " as number LEFT JOIN " + this.tableName + " as item ON item.id=number.item_id WHERE number.number=? AND item.id!=" + item.getId());
        } else {
            paramList = item.getClientPorts();
            query = new StringBuilder("SELECT port.id, item.cid FROM phone_item_port_" + this.mid + " as port LEFT JOIN " + this.tableName + " as item ON item.id=port.item_id WHERE item.source_id=" + item.getSourceId() + " AND port.port=? AND item.id!=" + item.getId());
        }
        query.append(" AND (? IS NULL OR date2 IS NULL OR ?<=date2) AND (? IS NULL OR date1 IS NULL OR ?>=date1) ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setDate(2, date1);
        ps.setDate(3, date1);
        ps.setDate(4, date2);
        ps.setDate(5, date2);
        for (String param : paramList) {
            ps.setString(1, param);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append(this.contractUtils.getContractTitle(rs.getInt(2), false));
            }
            rs.close();
        }
        ps.close();
        return result.toString();
    }

    private String checkResource(ClientItem item) throws SQLException {
        boolean number;
        StringBuilder result = new StringBuilder();
        NumberResourceManager resourceManager = new NumberResourceManager(this.con, this.mid);
        Date dateFrom = TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate1());
        Date dateTo = TimeUtils.convertCalendarToSqlDate((Calendar)item.getDate2());
        boolean bl = number = item.getClientNumbers().size() > 0;
        if (number) {
            List<String> paramList = item.getClientNumbers();
            for (String param : paramList) {
                String res = resourceManager.checkResource(param, dateFrom, dateTo);
                if (Utils.isEmptyString((String)res)) continue;
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append(res);
            }
        }
        return result.toString();
    }

    public List<NumberResourceUse> getResourceUse(NumberResource res) {
        LinkedList<NumberResourceUse> result = new LinkedList<NumberResourceUse>();
        try {
            String query = "SELECT item.cid, item.date1, item.date2 FROM phone_item_number_" + this.mid + " AS number INNER JOIN  phone_client_item_" + this.mid + " AS item ON number.item_id=item.id  AND (? IS NULL OR (item.date1 IS NOT NULL AND ?<=item.date1)) AND (? IS NULL OR (item.date2 IS NOT NULL AND ?>=item.date2)) WHERE number.number=? ORDER BY item.date2";
            Date sqlDate1 = TimeUtils.convertDateToSqlDate((java.util.Date)res.getDateFrom());
            Date sqlDate2 = TimeUtils.convertDateToSqlDate((java.util.Date)res.getDateTo());
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate1);
            ps.setDate(2, sqlDate1);
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate2);
            ps.setString(5, res.getNumber());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NumberResourceUse resourceUse = new NumberResourceUse();
                resourceUse.setContractId(rs.getInt(1));
                resourceUse.setDateFrom((java.util.Date)rs.getDate(2));
                resourceUse.setDateTo((java.util.Date)rs.getDate(3));
                result.add(resourceUse);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Integer getIpRangeId(int itemId) throws SQLException {
        Integer rangeId = null;
        StringBuffer query = new StringBuffer();
        query.append(" SELECT  * from  " + this.ipTableName);
        query.append(" WHERE item_id = ? ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, itemId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rangeId = rs.getInt("range_id");
        }
        rs.close();
        ps.close();
        return rangeId;
    }

    public void setRangeId(int itemId, Integer rangeId) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append(" REPLACE INTO " + this.ipTableName + "( item_id, range_id ) ");
        query.append(" VALUES (?, ?) ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, itemId);
        ps.setLong(2, rangeId.intValue());
        ps.executeUpdate();
        ps.close();
    }

    public boolean checkPoints(int cid, Integer rangeId) throws SQLException {
        boolean result = true;
        StringBuffer query = new StringBuffer();
        query.append(" SELECT COUNT(*) ");
        query.append(" FROM  " + this.ipTableName + " as ip_phone");
        query.append(" WHERE range_id = ?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, rangeId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int count = rs.getInt(1);
            result = count <= 0;
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<ClientItem> getPointsForIpRange(int cid, Integer rangeId) throws SQLException {
        ArrayList<ClientItem> result = new ArrayList<ClientItem>();
        StringBuffer query = new StringBuffer();
        query.append(" SELECT item.*, ip_phone.range_id  ");
        query.append(" FROM  " + this.ipTableName + " as ip_phone");
        query.append(" LEFT JOIN " + this.tableName + " as item");
        query.append(" ON item.id = ip_phone.item_id");
        query.append(" WHERE item.cid =  ? AND ip_phone.range_id = ? ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int idx = 1;
        ps.setInt(idx++, cid);
        ps.setInt(idx++, rangeId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            ClientItem item = this.getItemFromRS(rs, null, null, false, false);
            item.setRangeId(rs.getInt("range_id"));
            result.add(item);
        }
        rs.close();
        ps.close();
        return result;
    }

    public void deleteIp(int itemId) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append(" DELETE FROM " + this.ipTableName);
        query.append(" WHERE item_id = ? ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, itemId);
        ps.executeUpdate();
        ps.close();
    }

    public void resourceAnalize(ClientItem item, Map<String, NumberChange> numberMap, boolean strictCheck) throws BGException {
        NumberResourceManager resourceManager = new NumberResourceManager(this.con, this.mid);
        if (item.getId() > 0) {
            ClientItem oldItem = this.getItem(item.getId());
            for (String number : oldItem.getClientNumbers()) {
                NumberChange numberChange = new NumberChange();
                numberChange.changeType = 1;
                numberChange.number = number;
                numberChange.oldDateFrom = TimeUtils.convertCalendarToDate((Calendar)oldItem.getDate1());
                numberChange.oldDateTo = TimeUtils.convertCalendarToDate((Calendar)oldItem.getDate2());
                numberMap.put(number, numberChange);
            }
        }
        for (String number : item.getClientNumbers()) {
            NumberChange numberChange = numberMap.get(number);
            if (numberChange == null) {
                numberChange = new NumberChange();
                numberChange.changeType = 3;
                numberChange.number = number;
                numberChange.newDateFrom = TimeUtils.convertCalendarToDate((Calendar)item.getDate1());
                numberChange.newDateTo = TimeUtils.convertCalendarToDate((Calendar)item.getDate2());
                numberMap.put(number, numberChange);
                continue;
            }
            if (!TimeUtils.dateEqual((Calendar)TimeUtils.convertDateToCalendar((java.util.Date)numberChange.oldDateFrom), (Calendar)item.getDate1()) || !TimeUtils.dateEqual((Calendar)TimeUtils.convertDateToCalendar((java.util.Date)numberChange.oldDateTo), (Calendar)item.getDate2())) {
                numberChange.changeType = 2;
                numberChange.newDateFrom = TimeUtils.convertCalendarToDate((Calendar)item.getDate1());
                numberChange.newDateTo = TimeUtils.convertCalendarToDate((Calendar)item.getDate2());
                continue;
            }
            numberChange.changeType = 4;
        }
        for (NumberChange numberChange : numberMap.values()) {
            if (numberChange.changeType == 4) continue;
            List resourceList = resourceManager.getResourceList(numberChange.number);
            if (resourceList.size() > 0) {
                NumberResource usedResource;
                if (numberChange.changeType == 3) {
                    usedResource = null;
                    for (NumberResource res : resourceList) {
                        if (!TimeUtils.periodInRange((java.util.Date)numberChange.newDateFrom, (java.util.Date)numberChange.newDateTo, (java.util.Date)res.getDateFrom(), (java.util.Date)res.getDateTo())) continue;
                        usedResource = res;
                        break;
                    }
                    if (usedResource == null) {
                        throw new BGMessageException("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 " + numberChange.number + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                    }
                    numberChange.resource = usedResource;
                    continue;
                }
                if (numberChange.changeType == 2) {
                    usedResource = null;
                    for (NumberResource res : resourceList) {
                        if (!TimeUtils.periodInRange((java.util.Date)numberChange.newDateFrom, (java.util.Date)numberChange.newDateTo, (java.util.Date)res.getDateFrom(), (java.util.Date)res.getDateTo()) || !TimeUtils.periodInRange((java.util.Date)numberChange.oldDateFrom, (java.util.Date)numberChange.oldDateTo, (java.util.Date)res.getDateFrom(), (java.util.Date)res.getDateTo())) continue;
                        usedResource = res;
                        break;
                    }
                    if (usedResource == null) {
                        throw new BGMessageException("\u0421\u0442\u0430\u0440\u044b\u0439 \u043b\u0438\u0431\u043e \u043d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u043e\u043c\u0435\u0440\u0430 " + numberChange.number + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                    }
                    numberChange.resource = usedResource;
                    continue;
                }
                if (numberChange.changeType != 1) continue;
                usedResource = null;
                for (NumberResource res : resourceList) {
                    if (!TimeUtils.periodInRange((java.util.Date)numberChange.oldDateFrom, (java.util.Date)numberChange.oldDateTo, (java.util.Date)res.getDateFrom(), (java.util.Date)res.getDateTo())) continue;
                    usedResource = res;
                    break;
                }
                if (usedResource == null) {
                    throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 " + numberChange.number + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
                numberChange.resource = usedResource;
                continue;
            }
            if (!strictCheck) continue;
            throw new BGMessageException("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0435\u0442 \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
        }
    }

    public void realUpdate(int userId, ClientItem item, boolean strictCheck, ServerContext context, boolean reserv) throws BGException {
        boolean create;
        NumberResourceUseManager resourceUseManager = new NumberResourceUseManager(this.con, this.mid);
        HashMap<String, NumberChange> numberMap = new HashMap<String, NumberChange>();
        if (item.getType() == 1) {
            this.resourceAnalize(item, numberMap, strictCheck);
        }
        boolean bl = create = item.getId() <= 0;
        if (item.getId() > 0) {
            this.updateClientItem(item);
        } else {
            this.addClientItem(item);
        }
        for (NumberChange change : numberMap.values()) {
            if (change.resource == null) continue;
            List<NumberResourceUse> useList = this.getResourceUse(change.resource);
            if (Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)).getBoolean("phone.resource.reserve", false) && !useList.isEmpty()) {
                NumberResourceUse lastNumberResourceUse = useList.get(useList.size() - 1);
                if (reserv && change.changeType == 2 && change.oldDateTo == null && change.newDateTo != null && TimeUtils.dateEqual((java.util.Date)change.newDateTo, (java.util.Date)lastNumberResourceUse.getDateTo()) && lastNumberResourceUse.getContractId() == item.getContractId()) {
                    int reserveMothCount = Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)).getInt("phone.resource.reserve.month.count", 1);
                    lastNumberResourceUse.setDateReserve(TimeUtils.plusPeriod((java.util.Date)lastNumberResourceUse.getDateTo(), (int)2, (int)reserveMothCount));
                }
            }
            resourceUseManager.updateResourceUse(change.resource.getId(), useList);
        }
        context.publishAfterCommit((Event)new ClientItemChangedEvent(userId, this.mid, item, create));
    }

    public void postDelete(Set<NumberResource> usedResource) {
        NumberResourceUseManager resourceUseManager = new NumberResourceUseManager(this.con, this.mid);
        for (NumberResource resource : usedResource) {
            List<NumberResourceUse> useList = this.getResourceUse(resource);
            resourceUseManager.updateResourceUse(resource.getId(), useList);
        }
    }

    public Set<NumberResource> preDelete(ClientItem item) throws BGMessageException {
        HashSet<NumberResource> usedResource = new HashSet<NumberResource>();
        NumberResource usedRes = null;
        if (item.getClientNumbers().size() > 0) {
            NumberResourceManager resourceManager = new NumberResourceManager(this.con, this.mid);
            for (String number : item.getClientNumbers()) {
                List resList = resourceManager.getResourceList(number);
                if (resList.size() <= 0) continue;
                for (NumberResource res : resList) {
                    if (!TimeUtils.periodInRange((Calendar)item.getDate1(), (Calendar)item.getDate2(), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo()))) continue;
                    usedRes = res;
                    break;
                }
                if (usedRes == null) {
                    throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 " + number + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
                usedResource.add(usedRes);
            }
        }
        return usedResource;
    }

    private static class NumberChange {
        public static final int REMOVED = 1;
        public static final int DATE_CHANGED = 2;
        public static final int ADDED = 3;
        public static final int ANOTHER_CHANGE = 4;
        public String number;
        public int changeType;
        public NumberResource resource;
        public java.util.Date oldDateFrom;
        public java.util.Date oldDateTo;
        public java.util.Date newDateFrom;
        public java.util.Date newDateTo;

        private NumberChange() {
        }
    }
}

