/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.proccess.radius;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.proccess.radius.VoiceRadiusProcessorMod;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLog;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusListener;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusListenerWorker;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceRadius;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class RadiusLogProcessTask
implements Runnable {
    private static Logger logger = LogManager.getLogger();
    private final int deviceId;
    private Setup setup;
    private Date day;
    private final int moduleId;
    private VoiceRadiusProcessorMod processor;
    private RadiusListener listener;
    private VoiceNas nas;
    private ConnectionSet connectionSet;

    public RadiusLogProcessTask(Setup setup, int deviceId, Date day, int moduleId) {
        this.setup = setup;
        this.deviceId = deviceId;
        this.day = day;
        this.moduleId = moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            this.connectionSet = connectionSet;
            VoiceRadius radius = new VoiceRadius(this.setup, false);
            radius.start();
            this.processor = new VoiceRadiusProcessorMod(this.setup, radius);
            this.nas = this.processor.getNas(this.deviceId);
            this.listener = new VoiceRadiusListener(null, 0, 0, 0, this.processor, RadiusListener.Mode.accounting, this.setup, null, 0, 0);
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.removeTask();
        }
    }

    private void process() throws SQLException, BGException {
        Calendar hourCal = TimeUtils.convertDateToCalendar((Date)this.day);
        for (int i = 0; i < 24; ++i) {
            hourCal.set(11, i);
            Date hour = hourCal.getTime();
            this.processHour(hour);
        }
    }

    private void processHour(Date hour) throws SQLException, BGException {
        try (VoiceSessionLogDao voiceSessionDao = new VoiceSessionLogDao(this.connectionSet.getConnection(), this.moduleId, this.day);){
            voiceSessionDao.deleteSessions(hour, this.deviceId);
        }
        int zoneDelta = RadiusLogProcessTask.getZoneDelta(this.setup, hour, this.moduleId);
        RadiusHourlyDataLog dataLog = new RadiusHourlyDataLog((DefaultServerSetup)this.setup, "datalog.radius.accounting.dir", this.deviceId, TimeUtils.convertDateToCalendar((Date)hour));
        try {
            RadiusDataLogReader radiusReader;
            while ((radiusReader = (RadiusDataLogReader)dataLog.nextReader(null, true)) != null) {
                RadiusPacket packet;
                long[] millisArr = new long[1];
                while ((packet = radiusReader.read(millisArr)) != null) {
                    long millis = millisArr[0] + (long)zoneDelta;
                    int acctStatusType = packet.getIntAttribute(-1, 40, Integer.valueOf(0));
                    VoiceRadiusListenerWorker worker = new VoiceRadiusListenerWorker((RadiusListener<VoiceNas>)this.listener, null, millis, null, 0);
                    if (acctStatusType != 2) continue;
                    this.processPacket(worker, packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processPacket(VoiceRadiusListenerWorker worker, RadiusPacket request) throws Exception {
        RadiusPacket response = new RadiusPacket(5, 0);
        if (this.nas.getProtocolHandler() != null) {
            this.nas.getProtocolHandler().preprocessAccountingRequest(request, response, this.connectionSet);
        }
        this.nas.stopConnection(worker, request, response, this.connectionSet);
    }

    private void removeTask() {
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            DataProccessRecordDao dao = new DataProccessRecordDao(con, this.moduleId);
            dao.delete(this.deviceId, Arrays.asList(this.day));
            dao.close();
        }
        catch (BGException ex) {
            logger.error("error while closing connection", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public static int getZoneDelta(Setup setup, Date hour, int moduleId) {
        int delta = 0;
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        String timeZoneName = moduleSetup.get("radius.accounting.process.logs.timezone");
        if (!Utils.isEmptyString((String)timeZoneName)) {
            long millis = hour.getTime();
            TimeZone processTimeZone = TimeZone.getTimeZone(timeZoneName);
            TimeZone currentTimeZone = TimeZone.getDefault();
            delta = processTimeZone.getOffset(millis) - currentTimeZone.getOffset(millis);
        }
        return delta;
    }
}

