/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.service.AlfabankService;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankAutopaymentEvent;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.alfabank.common.service.AlfabankService")
public class AlfabankServiceImpl
extends AbstractService
implements AlfabankService {
    @Resource
    private ContractAutopaymentService contractAutopaymentService;

    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult transactionSearchResult = new SearchResult(searchParam);
        this.getTransactionManager().searchTransaction(transactionSearchResult, searchParam);
        return transactionSearchResult;
    }

    public void checkTransaction(int transactionId) throws Exception {
        EventProcessor.getInstance().publish((Event)new AlfabankCheckEvent(this.moduleId, transactionId));
    }

    public void checkTransactions(int contractId) throws Exception {
        TransactionManager transactionManager = this.getTransactionManager();
        transactionManager.doCheckRequest(contractId, true);
        transactionManager.doCheckRequest(contractId, false);
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId));
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws BGException {
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (mode != null) {
            mode.value = "redirect";
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.tryCall(() -> {
            ModuleSetup moduleSetup = this.getModuleSetup();
            BigDecimal sum = amount.setScale(2, RoundingMode.HALF_EVEN);
            if (autopaymentMode == null) {
                BigDecimal sumMin = moduleSetup.getBigDecimal("alfabank.sum.min", new BigDecimal(100));
                BigDecimal sumMax = moduleSetup.getBigDecimal("alfabank.sum.max", new BigDecimal(5000));
                if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
                }
            }
            if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnection(), Integer.valueOf(contractId));
            if (contractRuntime == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!", "contract.notFound");
            }
            Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
            String resultUrl = (String)params.get("resultUrl");
            String customerAddress = (String)params.get("receiptTo");
            String contractTitle = contractRuntime.getContractTitle();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            if (autopaymentMode != null) {
                this.autopayment(contractId, contractTitle, autopaymentMode, customerAddress, dataMap, resultUrl);
            } else {
                new TransactionManager(this.getConnection(), this.moduleId).registerOrder(contractId, contractTitle, customerAddress, sum, dataMap, false, false, resultUrl);
            }
            url.value = Optional.ofNullable(dataMap.get("formUrl")).map(a -> String.valueOf(a)).orElse(null);
            if (url.value == null) {
                throw new BGMessageException(dataMap.get("errorMessage") + " [errorCode=" + dataMap.get("errorCode") + "]");
            }
            if (paramsHolder != null) {
                paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
            }
        });
    }

    private void autopayment(int contractId, String contractTitle, ContractAutopaymentMode mode, String customerAddress, Map<String, Object> dataMap, String resultUrl) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (mode != null && mode.getMode() != AutopaymentMode.OFF) {
            this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, mode);
        }
        if ((autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null) {
            if (autopayment.getMode() != AutopaymentMode.OFF) {
                autopaymentManager.autopaymentOff(autopayment);
            }
            if (mode.getMode() != autopayment.getMode()) {
                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                autopaymentManager.updateAutopayment(autopayment);
                autopayment = null;
            }
        } else if (mode.getMode() == AutopaymentMode.OFF) {
            throw new BGMessageException("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.", "autopayment.notFound");
        }
        if (autopayment == null) {
            autopayment = Autopayment.builder().setContractId(contractId).build();
        }
        if (mode.getMode() == AutopaymentMode.OFF) {
            autopayment.setMode(AutopaymentMode.OFF);
            autopayment.setModeData("");
            autopayment.setSum(BigDecimal.ZERO);
            autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
            autopayment.setAccessToken(null);
        } else {
            mode.toAutopayment(autopayment);
            this.getTransactionManager().registerOrder(contractId, contractTitle, customerAddress, autopayment.getSum(), dataMap, false, true, resultUrl);
        }
        autopaymentManager.updateAutopayment(autopayment);
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
        this.tryCall(() -> this.getTransactionManager().doCheckRequest(contractId, false));
    }

    public List<String[]> getAutopaymentBindingData(int contractId) throws Exception {
        ModuleSetup moduleSetup = this.getModuleSetup();
        String userName = moduleSetup.get("alfabank.rest.user.name", "user");
        String userPswd = moduleSetup.get("alfabank.rest.user.pswd", "password");
        userName = URLEncoder.encode(userName, "UTF-8");
        userPswd = URLEncoder.encode(userPswd, "UTF-8");
        String billingName = moduleSetup.get("alfabank.billing.name", Setup.getSetup().get("billing.name"));
        StringBuilder clientId = new StringBuilder();
        if (billingName != null) {
            clientId.append(billingName).append("_");
        }
        clientId.append(this.moduleId).append("_").append(contractId);
        String spec = moduleSetup.get("alfabank.rest.bindings.url", "https://test.paymentgate.ru/testpayment/rest/getBindings.do");
        StringBuilder query = new StringBuilder().append("?userName=").append(userName).append("&password=").append(userPswd).append("&clientId=").append(clientId.toString());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: {}", (Object)spec);
            this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: {}", (Object)query.toString());
        }
        StringBuilder resultJson = new StringBuilder();
        try {
            URL registerUrl = new URL(spec);
            HttpsURLConnection connection = (HttpsURLConnection)registerUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bw.write(query.toString().toCharArray());
            bw.close();
            connection.connect();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    resultJson.append(line);
                }
            }
            connection.disconnect();
            this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: {}", (Object)resultJson.toString());
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0410\u043b\u044c\u0444\u0430 \u0431\u0430\u043d\u043a\u0430", "alfabank.connectionError");
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] errorData = new String[2];
        try {
            JSONObject resultJsonObject = new JSONObject(resultJson.toString());
            if (resultJsonObject.has("errorCode")) {
                errorData[0] = String.valueOf(resultJsonObject.getInt("errorCode"));
            }
            if (resultJsonObject.has("errorMessage")) {
                errorData[1] = resultJsonObject.getString("errorMessage");
            }
            if (resultJsonObject.has("bindings")) {
                JSONArray array = resultJsonObject.getJSONArray("bindings");
                for (int index = 0; index < array.length(); ++index) {
                    JSONObject jsonObject = array.getJSONObject(index);
                    String[] listData = new String[]{jsonObject.getString("bindingId"), jsonObject.getString("maskedPan"), jsonObject.getString("expiryDate")};
                    list.add(listData);
                }
            }
            list.add(0, errorData);
        }
        catch (JSONException ex) {
            this.logError(ex);
        }
        return list;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            this.tryCall(() -> {
                AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                    EventProcessor.getInstance().publish((Event)new AlfabankAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
            });
        }
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        this.tryCall(() -> this.beginAutopaymentTransaction(contractId, amount, url, mode, paramsHolder, null));
    }

    public Autopayment autopaymentGet(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> {
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            return autopayment;
        });
    }

    public void autopaymentDeactivate(int contractId) throws BGException {
        this.tryCall(() -> {
            ContractAutopaymentMode.ContractAutopaymentModePeriodic mode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
            mode.setMode(AutopaymentMode.OFF);
            this.autopayment(contractId, null, (ContractAutopaymentMode)mode, null, null, null);
        });
    }
}

