/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.common.io.Base64;

@WebServlet(name="VidimaxTestApi", urlPatterns={"/vidimax_test_api/*"})
public class VidimaxTestApi
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean valid = this.basicAuth(request);
        if (!valid) {
            String s = "Basic realm=\"Login Vidimax Request\"";
            response.setHeader("WWW-Authenticate", s);
            response.setStatus(401);
        } else {
            String operation = request.getParameter("operation");
            if (operation.equals("list")) {
                this.list(request, response);
            } else if (operation.equals("active")) {
                this.active(request, response);
            } else if (operation.equals("subscribe")) {
                this.subscribe(request, response);
            }
        }
    }

    protected void active(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject activeTariff = new JSONObject();
        try {
            activeTariff.put("name", (Object)"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439");
            activeTariff.put("id", 2);
            activeTariff.put("description", (Object)"\u041d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0443 Vidimax");
            activeTariff.put("startCurrentPeriod", 1318017600000L);
            activeTariff.put("state", (Object)"ACTIVE");
            activeTariff.put("stopCurrentPeriod", 1320699600000L);
            activeTariff.put("resultCode", 0);
            activeTariff.put("result", (Object)"success");
            activeTariff.put("resultMessage", (Object)"");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(activeTariff.toString());
        out.flush();
    }

    protected void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayList<JSONObject> tariffList = new ArrayList<JSONObject>();
        JSONObject tariff1 = new JSONObject();
        try {
            tariff1.put("name", (Object)"\u0411\u0430\u0437\u043e\u0432\u044b\u0439");
            tariff1.put("id", 0);
            tariff1.put("price", 0);
            tariff1.put("description", (Object)"\u0422\u0430\u043a\u043e\u0439 \u0432\u043e\u0442 \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject tariff2 = new JSONObject();
        try {
            tariff2.put("name", (Object)"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439");
            tariff2.put("id", 2);
            tariff2.put("price", 10200);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        tariffList.add(tariff1);
        tariffList.add(tariff2);
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("result", (Object)"success");
            jsonObj.put("resultMessage", (Object)"");
            jsonObj.put("tariffList", tariffList);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(jsonObj.toString());
        out.flush();
    }

    protected void subscribe(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject subscribeResult = new JSONObject();
        try {
            subscribeResult.put("result", (Object)"failure");
            subscribeResult.put("resultMessage", (Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444.");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(subscribeResult.toString());
        out.flush();
    }

    private boolean basicAuth(HttpServletRequest request) throws IOException {
        String credentials;
        String userPass;
        int p;
        String basic;
        StringTokenizer st;
        String userId = null;
        String password = null;
        boolean valid = false;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (p = (userPass = Base64.decodeUTF8((String)(credentials = st.nextToken()))).indexOf(":")) != -1) {
            userId = userPass.substring(0, p);
            password = userPass.substring(p + 1);
            if (userId.trim().equals("test") && password.trim().equals("test")) {
                valid = true;
            }
        }
        return valid;
    }
}

