/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tasks;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatusBase;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffRequest;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class CalculatorUtils
extends BGLogger {
    private int moduleId = -1;
    private int daysInMonth;
    private int graceperiodCount = 1;
    private int graceperiodUnit = 0;
    private TariffAVDManager tm;
    private TariffModuleTreeSetDao tariffModuleTreeSetDao;
    private Calendar startMonth = null;
    private DrWebNTariffContext context;
    private ServiceCostCache costCache;
    boolean calcErrors = false;
    private Map<Integer, TariffAVD> tariffMap = new HashMap<Integer, TariffAVD>();
    private TariffModuleTreeSet tariffTreeSetCache = null;
    private int tariffTreeSetCacheCid = -1;

    public CalculatorUtils(Connection con, int mid, Calendar startMonth, DrWebNTariffContext context, ServiceCostCache costCache) throws BGException {
        this.moduleId = mid;
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
        if (moduleSetup != null) {
            this.graceperiodCount = moduleSetup.getInt("graceperiod.count", 0);
            String val = moduleSetup.get("graceperiod.unit", "month").toLowerCase();
            if (val.equals("month")) {
                this.graceperiodUnit = 0;
            } else if (val.equals("day")) {
                this.graceperiodUnit = 1;
            }
        }
        this.tm = new TariffAVDManager(con, mid);
        this.tariffModuleTreeSetDao = new TariffModuleTreeSetDao(con);
        this.context = context;
        this.costCache = costCache;
        this.startMonth = startMonth;
        this.daysInMonth = startMonth.getActualMaximum(5);
    }

    private TariffAVD getTariffAVD(int tariffId) throws SQLException {
        TariffAVD result = this.tariffMap.get(tariffId);
        if (result == null) {
            result = (TariffAVD)this.tm.get(tariffId);
            this.tariffMap.put(tariffId, result);
        }
        return result;
    }

    private TariffModuleTreeSet getTariffModuleTreeSet(int cid) throws BGException {
        TariffModuleTreeSet result = this.tariffTreeSetCache;
        if (this.tariffTreeSetCacheCid != cid || result == null) {
            this.tariffTreeSetCache = result = this.tariffModuleTreeSetDao.getRealtimeTariffTreeSet(cid, this.startMonth.getTime(), "drwebn", this.moduleId, 0, 0);
        }
        return result;
    }

    public String processStatus(DrwebAgent agent, DrwebAgentStatusBase agentStatus, Date day) throws SQLException, BGException {
        GregorianCalendar statusStart = new GregorianCalendar();
        statusStart.setTime(day);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("process day: " + TimeUtils.formatPeriod((Calendar)statusStart, (Calendar)statusStart));
        }
        if (TimeUtils.dateBefore((Date)day, (Date)agent.getDateFrom())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Agent id=>" + agent.getId() + " is not present in day =>" + TimeUtils.formatDate((Date)day));
            }
            return null;
        }
        if (agentStatus.getStatus() != 1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Agent id=>" + agent.getId() + " is not OK status in day =>" + TimeUtils.formatDate((Date)day));
            }
            return null;
        }
        int contractId = agent.getCid();
        TariffAVD tariffAVD = this.getTariffAVD(agentStatus.getTariffId());
        if (tariffAVD == null) {
            this.getLogger().error("Not find drweb tariff => " + agentStatus.getTariffId() + " for agent => " + agent.getId());
            return "\u0422\u0430\u0440\u0438\u0444 AVD id=>" + agentStatus.getTariffId() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
        }
        int sid = -1;
        sid = this.isNewAgent(agent.getDateFrom(), new Date()) && tariffAVD.getSidForNew() != -1 ? tariffAVD.getSidForNew() : tariffAVD.getSid();
        TariffModuleTreeSet tariffTreeSet = this.getTariffModuleTreeSet(contractId);
        boolean accept = false;
        for (TariffModuleTreeSet.Entry tariffPeriod : tariffTreeSet.entries()) {
            Calendar tariffFrom = tariffPeriod.getCalendarFrom();
            Calendar tariffTo = tariffPeriod.getCalendarTo();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Tariff period: " + TimeUtils.formatPeriod((Calendar)tariffFrom, (Calendar)tariffTo));
            }
            if (TimeUtils.dateBefore((Calendar)tariffTo, (Calendar)statusStart) || TimeUtils.dateBefore((Calendar)statusStart, (Calendar)tariffFrom)) continue;
            DrWebNTariffRequest request = new DrWebNTariffRequest(this.moduleId, contractId, -1);
            request.setAccountingMonthDays(this.daysInMonth);
            request.setServiceCost(sid, Collections.singletonList(new DrWebNTariffRequest.DrWebNServiceCost(sid, statusStart, statusStart, statusStart, statusStart, 1L)));
            request.setAgentId(agent.getId());
            TariffModuleTree tree = tariffPeriod.getTree();
            tree.execute((AbstractTariffRequest)request, (TariffContext)this.context);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Request after processing: " + tariffPeriod.getTree().getTreeId());
                this.getLogger().debug(request.toString());
            }
            if (request.isAccepted()) {
                accept = true;
                for (DrWebNTariffRequest.DrWebNServiceCost serviceCost : request.getServiceCostList()) {
                    CostSum sum = new CostSum(contractId, serviceCost.getServiceId(), serviceCost.getCost());
                    this.costCache.addAmount(sum);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Add cost cache cid: " + contractId + "; sid: " + serviceCost.getServiceId() + "; cost: " + serviceCost.getCost());
                }
            }
            if (accept) continue;
            this.getLogger().error("Tariff error contractId: " + contractId + "; serviceId: " + sid);
            return "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + sid;
        }
        return null;
    }

    private boolean isNewAgent(Date agentDate, Date nowDate) {
        if (agentDate == null) {
            return false;
        }
        if (this.graceperiodUnit == 0) {
            return TimeUtils.monthsDelta((Date)agentDate, (Date)nowDate) + 1 <= this.graceperiodCount;
        }
        if (this.graceperiodUnit == 1) {
            return TimeUtils.daysDelta((Date)agentDate, (Date)nowDate) + 1 <= this.graceperiodCount;
        }
        return false;
    }

    public static boolean isCurrentDayStatus(DrwebAgentStatus status, Calendar day) {
        if (status == null) {
            return false;
        }
        GregorianCalendar statusDate = new GregorianCalendar();
        statusDate.setTime(status.getStatusDate());
        return !TimeUtils.dateBefore((Calendar)day, (Calendar)statusDate);
    }

    public static boolean isStartDayStatus(DrwebAgentStatus status) {
        GregorianCalendar statusDate = new GregorianCalendar();
        statusDate.setTime(status.getStatusDate());
        return statusDate.get(10) == 0 && statusDate.get(12) == 0 && statusDate.get(13) == 0;
    }
}

